/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SwtRegistry {
    private static final ILogger logger = GlobalLog.getLogger(SwtRegistry.class);
    private static SwtRegistry manager = null;
    protected Display display;
    protected Map<RGB, Color> colors = new HashMap<RGB, Color>();
    protected Map<FontDescriptor, Font> fonts = new HashMap<FontDescriptor, Font>();

    public static SwtRegistry getInstance() {
        if (manager == null) {
            manager = new SwtRegistry();
        }
        return manager;
    }

    protected SwtRegistry() {
        this(Display.getCurrent());
    }

    protected SwtRegistry(Display display) {
        if (display == null) {
            throw new IllegalArgumentException("Needs a display");
        }
        this.display = display;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Color getColor(RGB rgb) {
        Color color = this.colors.get(rgb);
        if (color == null) {
            color = new Color((Device)this.display, rgb);
            this.colors.put(rgb, color);
        }
        return color;
    }

    public Color getColor(int rgb) {
        return this.getColor(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
    }

    public Color getColor(int r, int g, int b) {
        return this.getColor(new RGB(r, g, b));
    }

    public Color getSystemColor(int id) {
        return this.display.getSystemColor(id);
    }

    public Font getFont(FontDescriptor desc) {
        Font font = this.fonts.get(desc);
        if (font == null) {
            font = desc.createFont((Device)this.display);
            this.fonts.put(desc, font);
        }
        return font;
    }

    public Font getFont(FontData data) {
        FontDescriptor desc = FontDescriptor.createFrom(data);
        return this.getFont(desc);
    }

    public Font getFont(FontData[] data) {
        FontDescriptor desc = FontDescriptor.createFrom(data);
        return this.getFont(desc);
    }

    public Font getFont(String name, int height, int style) {
        return this.getFont(new FontData(name, height, style));
    }

    public Font getFont(Font basefont, Integer height, Integer style) {
        FontDescriptor desc = FontDescriptor.createFrom(basefont);
        if (height != null) {
            desc = desc.setHeight(height);
        }
        if (style != null) {
            desc = desc.setStyle(style);
        }
        return this.getFont(desc);
    }

    public void dispose() {
        for (Color color : this.colors.values()) {
            color.dispose();
        }
        for (Font font : this.fonts.values()) {
            font.dispose();
        }
    }
}

