/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class AdaptivePopupDialog
extends JebDialog {
    private static final int TYPE_INFORMATION = 1;
    private static final int TYPE_WARNING = 4;
    private static final int TYPE_QUESTION = 2;
    private static final int TYPE_QUESTION3 = 3;
    private int type;
    private boolean asking;
    private String message;
    private Button btnDoNotShow;
    private Integer retval = 0;
    boolean doNotShow = false;
    private String widgetDoNotShowName = null;
    private Integer defaultButton = null;

    public static AdaptivePopupDialog info(Shell parent, String caption, String message, String widgetName) {
        return new AdaptivePopupDialog(parent, 1, caption, message, widgetName);
    }

    public static AdaptivePopupDialog warn(Shell parent, String caption, String message, String widgetName) {
        return new AdaptivePopupDialog(parent, 4, caption, message, widgetName);
    }

    public static AdaptivePopupDialog question(Shell parent, String caption, String message) {
        return new AdaptivePopupDialog(parent, 2, caption, message, null);
    }

    public static AdaptivePopupDialog question3(Shell parent, String caption, String message) {
        return new AdaptivePopupDialog(parent, 3, caption, message, null);
    }

    private AdaptivePopupDialog(Shell parent, int type, String caption, String message, String widgetName) {
        super(parent, caption, true, true, widgetName);
        this.scrolledContainer = true;
        this.setMessage(message);
        this.setVisualBounds(30, -1, 15, -1);
        if (type != 1 && type != 4 && type != 2 && type != 3) {
            throw new IllegalArgumentException("Invalid dialog type");
        }
        this.type = type;
        this.asking = type == 2 || type == 3;
        this.widgetDoNotShowName = widgetName;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Integer open() {
        super.open();
        return this.retval;
    }

    private void setPreferredShellIcon() {
        Image icon = null;
        if (!this.asking) {
            if (this.type == 1) {
                icon = Display.getCurrent().getSystemImage(2);
            } else if (this.type == 4) {
                icon = Display.getCurrent().getSystemImage(8);
            }
        } else {
            icon = Display.getCurrent().getSystemImage(4);
        }
        if (icon != null) {
            this.shell.setImage(icon);
        }
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        this.setPreferredShellIcon();
        Label label = new Label(parent, 64);
        label.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        label.setText(Strings.safe(this.message, "< " + S.s(287) + " >"));
        new Label(parent, 64).setText("");
        String chkboxname = S.s(281) + (!this.asking ? " (forever)" : " (action only)");
        this.btnDoNotShow = UIUtil.createCheckbox(parent, chkboxname, null);
        if (this.getWidgetManager() != null && this.getWidgetName() != null) {
            if (this.widgetDoNotShowName == null) {
                this.btnDoNotShow.setSelection(false);
            } else {
                this.btnDoNotShow.setSelection(!this.getWidgetManager().getShouldShowDialog(this.getWidgetName()));
            }
        } else {
            this.btnDoNotShow.setEnabled(false);
        }
        if (this.asking) {
            if (this.type == 2) {
                this.createButtons(parent, new int[]{64, 128}, this.defaultButton != null ? this.defaultButton : 64);
            } else if (this.type == 3) {
                this.createButtons(parent, new int[]{64, 128, 256}, this.defaultButton != null ? this.defaultButton : 256);
            }
        } else {
            this.createButtons(parent, 32, 32);
        }
    }

    public void setDefaultButton(Boolean defaultValue) {
        this.defaultButton = defaultValue == null ? null : Integer.valueOf(defaultValue != false ? 64 : 128);
    }

    @Override
    protected void onCancel() {
        this.retval = null;
        this.record();
        super.onCancel();
    }

    @Override
    protected void onConfirm() {
        this.retval = 1;
        this.record();
        super.onConfirm();
    }

    @Override
    protected void onButtonYes() {
        this.retval = 1;
        this.record();
        super.onButtonYes();
    }

    @Override
    protected void onButtonNo() {
        this.retval = 0;
        this.record();
        super.onButtonNo();
    }

    public boolean isDoNotShow() {
        return this.doNotShow;
    }

    private void record() {
        this.doNotShow = this.btnDoNotShow.getSelection();
        if (this.getWidgetManager() != null && this.getWidgetName() != null) {
            this.getWidgetManager().setShouldShowDialog(this.getWidgetName(), !this.doNotShow);
        }
    }
}

