/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementWrapper;
import org.eclipse.jface.viewers.IElementComparer;

public class ViewerElementSet
implements Set {
    private final Set wrappedSet;
    private final IElementComparer comparer;

    public ViewerElementSet(IElementComparer comparer) {
        Assert.isNotNull(comparer);
        this.wrappedSet = new HashSet();
        this.comparer = comparer;
    }

    public ViewerElementSet(Collection collection, IElementComparer comparer) {
        this(comparer);
        this.addAll(collection);
    }

    @Override
    public boolean add(Object o) {
        return this.wrappedSet.add(new ViewerElementWrapper(o, this.comparer));
    }

    @Override
    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            changed |= this.wrappedSet.add(new ViewerElementWrapper(iterator.next(), this.comparer));
        }
        return changed;
    }

    @Override
    public void clear() {
        this.wrappedSet.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedSet.contains(new ViewerElementWrapper(o, this.comparer));
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            if (this.wrappedSet.contains(new ViewerElementWrapper(iterator.next(), this.comparer))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedSet.isEmpty();
    }

    @Override
    public Iterator iterator() {
        final Iterator wrappedIterator = this.wrappedSet.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            public Object next() {
                return ((ViewerElementWrapper)wrappedIterator.next()).unwrap();
            }

            @Override
            public void remove() {
                wrappedIterator.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return this.wrappedSet.remove(new ViewerElementWrapper(o, this.comparer));
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            changed |= this.remove(iterator.next());
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean changed = false;
        Object[] retainAll = c.toArray();
        Iterator iterator = this.iterator();
        block0: while (iterator.hasNext()) {
            Object element = iterator.next();
            int i = 0;
            while (i < retainAll.length) {
                if (this.comparer.equals(element, retainAll[i])) continue block0;
                ++i;
            }
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.wrappedSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.wrappedSet.size()]);
    }

    @Override
    public Object[] toArray(Object[] a) {
        int size = this.wrappedSet.size();
        ViewerElementWrapper[] wrappedArray = this.wrappedSet.toArray(new ViewerElementWrapper[size]);
        Object[] result = a;
        if (a.length < size) {
            result = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        while (i < size) {
            result[i] = wrappedArray[i].unwrap();
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set that = (Set)obj;
        return this.size() == that.size() && this.containsAll((Collection)that);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (Object element : this) {
            hash += element == null ? 0 : element.hashCode();
        }
        return hash;
    }

    public static Set withComparer(IElementComparer comparer) {
        if (comparer == null) {
            return new HashSet();
        }
        return new ViewerElementSet(comparer);
    }
}

