/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Objects;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class TreeViewerUpdater {
    private final AbstractTreeViewer viewer;
    private final TreeViewer treeViewer;

    public TreeViewerUpdater(AbstractTreeViewer viewer) {
        this.viewer = viewer;
        this.treeViewer = viewer instanceof TreeViewer ? (TreeViewer)viewer : null;
    }

    public void insert(Object parent, Object element, int position) {
        this.viewer.insert(parent, element, position);
    }

    public void replace(Object parent, Object oldElement, Object newElement, int position) {
        if (this.treeViewer != null && this.isElementOrderPreserved()) {
            this.treeViewer.replace(parent, position, newElement);
            this.treeViewer.refresh(newElement);
        } else {
            ITreeSelection selection = this.viewer.getStructuredSelection();
            this.remove(parent, oldElement, position);
            this.insert(parent, newElement, position);
            this.replaceElementInSelection(this.getPathParent(parent), oldElement, newElement, selection);
        }
    }

    private Object getPathParent(Object parent) {
        return parent == this.viewer.getInput() ? null : parent;
    }

    private void replaceElementInSelection(Object parent, Object oldElement, Object newElement, ITreeSelection selection) {
        IElementComparer comparer = this.viewer.getComparer();
        TreePath[] paths = selection.getPaths();
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            Object[] segments = new Object[path.getSegmentCount()];
            boolean replacePath = false;
            int j = 0;
            while (j < path.getSegmentCount()) {
                segments[j] = path.getSegment(j);
                Object pathParent = j > 0 ? path.getSegment(j - 1) : null;
                Object pathElement = path.getSegment(j);
                if (!replacePath && this.eq(comparer, parent, pathParent) && this.eq(comparer, oldElement, pathElement)) {
                    segments[j] = newElement;
                    replacePath = true;
                }
                ++j;
            }
            if (replacePath) {
                paths[i] = new TreePath(segments);
            }
            ++i;
        }
        this.viewer.setSelection(new TreeSelection(paths, this.viewer.getComparer()));
    }

    boolean isElementOrderPreserved() {
        return this.viewer.getComparator() == null && this.viewer.getFilters().length == 0;
    }

    public void move(Object parent, Object element, int oldPosition, int newPosition) {
        if (this.isElementOrderPreserved()) {
            ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
            this.remove(parent, element, oldPosition);
            this.insert(parent, element, newPosition);
            if (this.selectionContains(selection, this.getPathParent(parent), element)) {
                this.viewer.setSelection(selection);
            }
        }
    }

    private boolean selectionContains(ITreeSelection selection, Object parent, Object element) {
        if (!selection.isEmpty()) {
            TreePath[] paths;
            IElementComparer comparer = this.viewer.getComparer();
            TreePath[] treePathArray = paths = selection.getPaths();
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                int j = 0;
                while (j < path.getSegmentCount() - 1) {
                    Object pathParent = path.getSegment(j);
                    Object pathElement = path.getSegment(j + 1);
                    if (this.eq(comparer, parent, pathParent) && this.eq(comparer, element, pathElement)) {
                        return true;
                    }
                    ++j;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean eq(IElementComparer comparer, Object o1, Object o2) {
        return comparer == null ? Objects.equals(o1, o2) : comparer.equals(o1, o2);
    }

    public void remove(Object parent, Object element, int position) {
        if (this.treeViewer != null && this.viewer.getComparator() == null && this.viewer.getFilters().length == 0) {
            this.treeViewer.remove(parent, position);
        } else {
            this.viewer.remove(parent, new Object[]{element});
        }
    }

    public void add(Object parent, Object[] elements) {
        this.viewer.add(parent, elements);
    }

    public void remove(Object parent, Object[] elements) {
        this.viewer.remove(parent, elements);
    }
}

