/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.fieldassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDecoratingObservable;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.jface.databinding.viewers.IViewerObservable;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ControlDecorationSupport {
    private final int position;
    private final Composite composite;
    private final ControlDecorationUpdater updater;
    private IObservableValue<IStatus> validationStatus;
    private IObservableList<IObservable> targets;
    private IDisposeListener disposeListener = new IDisposeListener(){

        @Override
        public void handleDispose(DisposeEvent staleEvent) {
            ControlDecorationSupport.this.dispose();
        }
    };
    private IValueChangeListener<IStatus> statusChangeListener = new IValueChangeListener<IStatus>(){

        @Override
        public void handleValueChange(ValueChangeEvent<? extends IStatus> event) {
            ControlDecorationSupport.this.statusChanged((IStatus)ControlDecorationSupport.this.validationStatus.getValue());
        }
    };
    private IListChangeListener<IObservable> targetsChangeListener = new IListChangeListener<IObservable>(){

        @Override
        public void handleListChange(ListChangeEvent<? extends IObservable> event) {
            event.diff.accept(new TargetsListDiffAdvisor());
            ControlDecorationSupport.this.statusChanged((IStatus)ControlDecorationSupport.this.validationStatus.getValue());
        }
    };
    private List<TargetDecoration> targetDecorations;

    public static ControlDecorationSupport create(ValidationStatusProvider validationStatusProvider, int position) {
        return ControlDecorationSupport.create(validationStatusProvider, position, null, new ControlDecorationUpdater());
    }

    public static ControlDecorationSupport create(IObservableValue<IStatus> validationStatus, int position, IObservable ... targetsToBeDecorated) {
        return ControlDecorationSupport.create(validationStatus, position, null, new ControlDecorationUpdater(), ControlDecorationSupport.getObservableList(targetsToBeDecorated));
    }

    public static ControlDecorationSupport create(IObservableValue<IStatus> validationStatus, int position, IObservableList<IObservable> targetsToBeDecorated) {
        return ControlDecorationSupport.create(validationStatus, position, null, new ControlDecorationUpdater(), targetsToBeDecorated);
    }

    public static ControlDecorationSupport create(ValidationStatusProvider validationStatusProvider, int position, Composite composite) {
        return ControlDecorationSupport.create(validationStatusProvider, position, composite, new ControlDecorationUpdater());
    }

    public static ControlDecorationSupport create(IObservableValue<IStatus> validationStatus, int position, Composite composite, IObservable ... targetsToBeDecorated) {
        return ControlDecorationSupport.create(validationStatus, position, composite, new ControlDecorationUpdater(), ControlDecorationSupport.getObservableList(targetsToBeDecorated));
    }

    public static ControlDecorationSupport create(IObservableValue<IStatus> validationStatus, int position, Composite composite, IObservableList<IObservable> targetsToBeDecorated) {
        return ControlDecorationSupport.create(validationStatus, position, composite, new ControlDecorationUpdater(), targetsToBeDecorated);
    }

    public static ControlDecorationSupport create(ValidationStatusProvider validationStatusProvider, int position, Composite composite, ControlDecorationUpdater updater) {
        return ControlDecorationSupport.create(validationStatusProvider.getValidationStatus(), position, composite, updater, validationStatusProvider.getTargets());
    }

    public static ControlDecorationSupport create(IObservableValue<IStatus> validationStatus, int position, Composite composite, ControlDecorationUpdater updater, IObservable ... targetsToBeDecorated) {
        return ControlDecorationSupport.create(validationStatus, position, composite, updater, ControlDecorationSupport.getObservableList(targetsToBeDecorated));
    }

    public static ControlDecorationSupport create(IObservableValue<IStatus> validationStatus, int position, Composite composite, ControlDecorationUpdater updater, IObservableList<IObservable> targetsToBeDecorated) {
        return new ControlDecorationSupport(validationStatus, targetsToBeDecorated, position, composite, updater);
    }

    private ControlDecorationSupport(IObservableValue<IStatus> validationStatus, IObservableList<IObservable> targetsToBeDecorated, int position, Composite composite, ControlDecorationUpdater updater) {
        this.position = position;
        this.composite = composite;
        this.updater = updater;
        this.validationStatus = validationStatus;
        Assert.isTrue(!this.validationStatus.isDisposed());
        this.targets = targetsToBeDecorated;
        Assert.isTrue(!this.targets.isDisposed());
        this.targetDecorations = new ArrayList<TargetDecoration>();
        validationStatus.addDisposeListener(this.disposeListener);
        validationStatus.addValueChangeListener(this.statusChangeListener);
        this.targets.addDisposeListener(this.disposeListener);
        this.targets.addListChangeListener(this.targetsChangeListener);
        for (IObservable name : this.targets) {
            this.targetAdded(name);
        }
        this.statusChanged(validationStatus.getValue());
    }

    private void targetAdded(IObservable target) {
        Control control = this.findControl(target);
        if (control != null) {
            this.targetDecorations.add(new TargetDecoration(target, new ControlDecoration(control, this.position, this.composite)));
        }
    }

    private void targetRemoved(IObservable target) {
        Iterator<TargetDecoration> it = this.targetDecorations.iterator();
        while (it.hasNext()) {
            TargetDecoration targetDecoration = it.next();
            if (targetDecoration.target != target) continue;
            targetDecoration.decoration.dispose();
            it.remove();
        }
    }

    private Control findControl(IObservable target) {
        Object observed;
        IObservable decorated;
        Control control;
        Widget widget;
        if (target instanceof ISWTObservable && (widget = ((ISWTObservable)target).getWidget()) instanceof Control) {
            return (Control)widget;
        }
        if (target instanceof IViewerObservable) {
            Viewer viewer = ((IViewerObservable)target).getViewer();
            return viewer.getControl();
        }
        if (target instanceof IDecoratingObservable && (control = this.findControl(decorated = ((IDecoratingObservable)target).getDecorated())) != null) {
            return control;
        }
        if (target instanceof IObserving && (observed = ((IObserving)((Object)target)).getObserved()) instanceof IObservable) {
            return this.findControl((IObservable)observed);
        }
        return null;
    }

    private void statusChanged(IStatus status) {
        for (TargetDecoration targetDecoration : this.targetDecorations) {
            ControlDecoration decoration = targetDecoration.decoration;
            this.updater.update(decoration, status);
        }
    }

    private static IObservableList<IObservable> getObservableList(IObservable[] observables) {
        WritableList<IObservable> observableList = new WritableList<IObservable>();
        IObservable[] iObservableArray = observables;
        int n = observables.length;
        int n2 = 0;
        while (n2 < n) {
            IObservable observable = iObservableArray[n2];
            observableList.add(observable);
            ++n2;
        }
        return observableList;
    }

    public void dispose() {
        if (this.validationStatus != null) {
            this.validationStatus.removeDisposeListener(this.disposeListener);
            this.validationStatus.removeValueChangeListener(this.statusChangeListener);
            this.validationStatus = null;
        }
        if (this.targets != null) {
            this.targets.removeDisposeListener(this.disposeListener);
            this.targets.removeListChangeListener(this.targetsChangeListener);
            this.targets = null;
        }
        this.disposeListener = null;
        this.statusChangeListener = null;
        this.targetsChangeListener = null;
        if (this.targetDecorations != null) {
            for (TargetDecoration targetDecoration : this.targetDecorations) {
                targetDecoration.decoration.dispose();
            }
            this.targetDecorations.clear();
            this.targetDecorations = null;
        }
    }

    private static class TargetDecoration {
        public final IObservable target;
        public final ControlDecoration decoration;

        TargetDecoration(IObservable target, ControlDecoration decoration) {
            this.target = target;
            this.decoration = decoration;
        }
    }

    private class TargetsListDiffAdvisor<E extends IObservable>
    extends ListDiffVisitor<E> {
        private TargetsListDiffAdvisor() {
        }

        @Override
        public void handleAdd(int index, E element) {
            ControlDecorationSupport.this.targetAdded(element);
        }

        @Override
        public void handleRemove(int index, E element) {
            ControlDecorationSupport.this.targetRemoved(element);
        }
    }
}

