/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;

public class ValidationStatusMap
extends ObservableMap<Binding, IStatus> {
    private boolean isDirty = true;
    private final WritableList<Binding> bindings;
    private List<IObservableValue<IStatus>> dependencies = new ArrayList<IObservableValue<IStatus>>();
    private IChangeListener markDirtyChangeListener = event -> this.markDirty();

    public ValidationStatusMap(Realm realm, WritableList<Binding> bindings) {
        super(realm, new HashMap());
        this.bindings = bindings;
        bindings.addChangeListener(this.markDirtyChangeListener);
    }

    @Override
    public Object getKeyType() {
        return Binding.class;
    }

    @Override
    public Object getValueType() {
        return IStatus.class;
    }

    @Override
    protected void getterCalled() {
        this.recompute();
        super.getterCalled();
    }

    private void markDirty() {
        this.removeElementChangeListener();
        final Map oldMap = this.wrappedMap;
        MapDiff<Binding, IStatus> mapDiff = new MapDiff<Binding, IStatus>(){
            private MapDiff<Binding, IStatus> cachedDiff = null;

            private void ensureCached() {
                if (this.cachedDiff == null) {
                    ValidationStatusMap.this.recompute();
                    this.cachedDiff = Diffs.computeMapDiff(oldMap, ValidationStatusMap.this.wrappedMap);
                }
            }

            @Override
            public Set<Binding> getAddedKeys() {
                this.ensureCached();
                return this.cachedDiff.getAddedKeys();
            }

            @Override
            public Set<Binding> getChangedKeys() {
                this.ensureCached();
                return this.cachedDiff.getChangedKeys();
            }

            @Override
            public IStatus getNewValue(Object key) {
                this.ensureCached();
                return this.cachedDiff.getNewValue(key);
            }

            @Override
            public IStatus getOldValue(Object key) {
                this.ensureCached();
                return this.cachedDiff.getOldValue(key);
            }

            @Override
            public Set<Binding> getRemovedKeys() {
                this.ensureCached();
                return this.cachedDiff.getRemovedKeys();
            }
        };
        this.wrappedMap = new HashMap();
        this.isDirty = true;
        this.fireMapChange(mapDiff);
    }

    private void recompute() {
        if (this.isDirty) {
            HashMap<Binding, IStatus> newContents = new HashMap<Binding, IStatus>();
            for (Binding binding : this.bindings) {
                IObservableValue<IStatus> validationError = binding.getValidationStatus();
                this.dependencies.add(validationError);
                validationError.addChangeListener(this.markDirtyChangeListener);
                IStatus validationStatusValue = validationError.getValue();
                newContents.put(binding, validationStatusValue);
            }
            this.wrappedMap.putAll(newContents);
            this.isDirty = false;
        }
    }

    @Override
    public synchronized void dispose() {
        this.bindings.removeChangeListener(this.markDirtyChangeListener);
        this.removeElementChangeListener();
        super.dispose();
    }

    private void removeElementChangeListener() {
        for (IObservableValue<IStatus> observableValue : this.dependencies) {
            observableValue.removeChangeListener(this.markDirtyChangeListener);
        }
    }

    @Override
    public synchronized void addChangeListener(IChangeListener listener) {
        this.recompute();
        super.addChangeListener(listener);
    }

    @Override
    public synchronized void addMapChangeListener(IMapChangeListener<? super Binding, ? super IStatus> listener) {
        this.recompute();
        super.addMapChangeListener(listener);
    }
}

