/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.map;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.property.MapPropertyDetailValuesMap;

public abstract class MapProperty<S, K, V>
implements IMapProperty<S, K, V> {
    @Override
    public Map<K, V> getMap(S source) {
        if (source == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.doGetMap(source));
    }

    protected Map<K, V> doGetMap(S source) {
        IObservableMap<K, V> observable = this.observe(source);
        try {
            IdentityMap<K, V> identityMap = new IdentityMap<K, V>(observable);
            return identityMap;
        }
        finally {
            observable.dispose();
        }
    }

    @Override
    public final void setMap(S source, Map<K, V> map) {
        if (source != null) {
            this.doSetMap(source, map);
        }
    }

    protected void doSetMap(S source, Map<K, V> map) {
        MapDiff<K, V> diff = Diffs.computeMapDiff(this.doGetMap(source), map);
        this.doUpdateMap(source, diff);
    }

    @Override
    public final void updateMap(S source, MapDiff<K, V> diff) {
        if (source != null) {
            this.doUpdateMap(source, diff);
        }
    }

    protected void doUpdateMap(S source, MapDiff<K, V> diff) {
        IObservableMap<K, V> observable = this.observe(source);
        try {
            diff.applyTo(observable);
        }
        finally {
            observable.dispose();
        }
    }

    @Override
    public IObservableMap<K, V> observe(S source) {
        return this.observe(Realm.getDefault(), source);
    }

    @Override
    public IObservableFactory<S, IObservableMap<K, V>> mapFactory() {
        return target -> this.observe(target);
    }

    @Override
    public IObservableFactory<S, IObservableMap<K, V>> mapFactory(Realm realm) {
        return target -> this.observe(realm, target);
    }

    @Override
    public <U extends S> IObservableMap<K, V> observeDetail(IObservableValue<U> master) {
        return MasterDetailObservables.detailMap(master, this.mapFactory(master.getRealm()), this.getKeyType(), this.getValueType());
    }

    @Override
    public final <T> IMapProperty<S, K, T> values(IValueProperty<? super V, T> detailValues) {
        return new MapPropertyDetailValuesMap(this, detailValues);
    }
}

