/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.androidjnihelper;

import com.pnf.plugin.androidjnihelper.DynamicJNIDetectionPlugin;
import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.concurrent.atomic.AtomicLong;

class JNINativeMethod {
    long ptrName;
    long ptrSignature;
    long ptrFnPtr;
    String name;
    String signature;
    long fnPtr;
    INativeCodeUnit<?> codeUnit;

    public JNINativeMethod(String name, String signature, long fnPtr, long ptrName, long ptrSignature, long ptrFnPtr, INativeCodeUnit<?> codeUnit) {
        this.name = name;
        this.signature = signature;
        this.fnPtr = fnPtr;
        this.ptrName = ptrName;
        this.ptrSignature = ptrSignature;
        this.ptrFnPtr = ptrFnPtr;
        this.codeUnit = codeUnit;
    }

    public String toString() {
        return "JNINativeMethod [" + this.name + this.signature + ", @" + Long.toHexString(this.fnPtr) + "]";
    }

    public static JNINativeMethod buildJNIFromMemPointer(INativeCodeUnit<?> codeUnit, IVirtualMemory vm, AtomicLong ptrMutMethods) {
        long ptrMethodsInit;
        long ptrName = ptrMethodsInit = ptrMutMethods.get();
        try {
            long dataAddress = vm.readPointer(ptrName);
            String name = DynamicJNIDetectionPlugin.readStringUTF8(vm, dataAddress);
            if (Strings.isBlank((String)name)) {
                ptrMutMethods.set(ptrMethodsInit + (long)(3 * vm.getSpaceBits() / 8));
                return null;
            }
            long ptrSignature = ptrName + (long)(vm.getSpaceBits() / 8);
            dataAddress = vm.readPointer(ptrSignature);
            String signature = DynamicJNIDetectionPlugin.readStringUTF8(vm, dataAddress);
            if (!signature.startsWith("(") || !signature.contains(")")) {
                ptrMutMethods.set(ptrMethodsInit + (long)(3 * vm.getSpaceBits() / 8));
                return null;
            }
            long ptrFnPtr = ptrSignature + (long)(vm.getSpaceBits() / 8);
            long fnPtr = vm.readPointer(ptrFnPtr);
            if (!codeUnit.getCodeAnalyzer().getAnalysisRanges().contains(fnPtr)) {
                String message = Strings.f((String)"Dynamic Jni Pointer in %s @%xh is out of analysis range for Jni table @%xh", (Object[])new Object[]{codeUnit.getParent().getName(), fnPtr, ptrMethodsInit});
                DynamicJNIDetectionPlugin.logger.warn(message, new Object[0]);
                DynamicJNIDetectionPlugin.logger.catchingSilent((Throwable)new JebRuntimeException(message));
            }
            JNINativeMethod jni = new JNINativeMethod(name, signature, fnPtr, ptrName, ptrSignature, ptrFnPtr, codeUnit);
            ptrMutMethods.set(ptrFnPtr + (long)(vm.getSpaceBits() / 8));
            return jni;
        }
        catch (MemoryException e) {
            DynamicJNIDetectionPlugin.logger.error("Can not parse JNINativeMethod @%xh", new Object[]{ptrMethodsInit});
            ptrMutMethods.set(ptrMethodsInit + (long)(3 * vm.getSpaceBits() / 8));
            return null;
        }
    }
}

