/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.AddressEntry;
import com.pnf.libravm.LibraPoolEntry;
import com.pnf.libravm.LibraUnit;
import com.pnf.libravm.StringEntry;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
class ModuleHandle
extends LibraPoolEntry {
    @SerId(value=1)
    private int address_index;
    @SerId(value=2)
    private int name_index;

    public ModuleHandle(int address_index, int name_index) {
        this.address_index = address_index;
        this.name_index = name_index;
    }

    public AddressEntry getAddress(LibraUnit l) {
        return (AddressEntry)l.addressPool.get(this.address_index);
    }

    public String getName(LibraUnit l) {
        return ((StringEntry)l.stringPool.get(this.name_index)).get();
    }

    public String getFullName(LibraUnit l) {
        return l.addressPool.get(this.address_index) + "." + ((StringEntry)l.stringPool.get(this.name_index)).get();
    }

    @Override
    public TextBuilder format(LibraUnit l, TextBuilder t) {
        ((AddressEntry)l.addressPool.get(this.address_index)).format(l, t);
        t.append((Object)".");
        ((StringEntry)l.stringPool.get(this.name_index)).format(l, t);
        return t;
    }
}

