/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.AddressEntry;
import com.pnf.libravm.BytearrayEntry;
import com.pnf.libravm.FieldDef;
import com.pnf.libravm.FunctionDef;
import com.pnf.libravm.FunctionHandle;
import com.pnf.libravm.FunctionSignature;
import com.pnf.libravm.Libra;
import com.pnf.libravm.LibraInstruction;
import com.pnf.libravm.LibraUnit;
import com.pnf.libravm.LocalSignature;
import com.pnf.libravm.SignatureToken;
import com.pnf.libravm.StringEntry;
import com.pnf.libravm.StructDef;
import com.pnf.libravm.StructHandle;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.IEntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.AbstractConverter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ConverterInstructionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEGlobalContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEPrototypeHandler;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.UnsupportedConversionException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEReturn;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEUntranslatedInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IReferenceType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.IWildcardType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IWildcardTypeManager;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@Ser
public class LibraConverter
extends AbstractConverter<LibraInstruction> {
    private static final ILogger logger = GlobalLog.getLogger(LibraConverter.class);
    public static final int ID_PC = 0;
    public static final int ID_SP = 256;
    public static final String PFX_LOCAL = "local";
    public static final String PFX_PARAM = "local";
    public static final String PFX_STACK = "var";
    @SerId(value=1)
    IEVar pc;
    @SerId(value=2)
    IEVar sp;
    @SerId(value=3)
    IEGlobalContext _gCtx;
    @SerId(value=4)
    LibraUnit libra;
    @SerId(value=5)
    INativeCodeUnit<LibraInstruction> pbcu;
    @SerTransient
    FunctionDef functionDef;
    @SerTransient
    FunctionHandle functionHandle;
    @SerTransient
    List<IEVar> localSlotVars;
    @SerTransient
    private List<StackSlot> opndstack = new LinkedList<StackSlot>();
    @SerTransient
    private int opndstackIndex = 0;
    @SerTransient
    private int opndstackCounter = 0;

    protected LibraConverter(LibraUnit libra, INativeCodeUnit<LibraInstruction> code) {
        super((IProcessor)libra.getBytecodeParser(), 64);
        this.libra = libra;
        if (code == null) {
            throw new IllegalArgumentException();
        }
        this.pbcu = code;
        this.pc = this.gCtx.createRegister(0, "pc", this.regNormalBitsize);
        this.sp = this.gCtx.createRegister(256, "sp", this.regNormalBitsize);
    }

    public IEVar getProgramCounter() {
        return this.pc;
    }

    public IEVar getStackPointer() {
        return this.sp;
    }

    private IEVar createVariable(String name, int bitsize) {
        return this.ctx.createVirtualVar(name, bitsize);
    }

    protected void preRoutineConversion(INativeMethodItem routine, IERoutineContext ctx) {
        this.autoAssignFunctionPrototypes();
        this.functionDef = this.libra.getFunctionByName(routine.getName(false));
        this.functionHandle = this.functionDef.getHandle(this.libra);
        LocalSignature locals = this.functionDef.getCode().getLocals(this.libra);
        int index = 0;
        this.localSlotVars = new ArrayList<IEVar>();
        for (SignatureToken token : locals.getTokens()) {
            IEVar slot = this.createVariable("local" + index, this.getLibraTypeBitsize(token));
            slot.setType(ctx.getWildcardTypeManager().create(this.convertLibraType(token)));
            ++index;
            this.localSlotVars.add(slot);
        }
        this.opndstack = new LinkedList<StackSlot>();
        this.opndstackIndex = 0;
        this.opndstackCounter = 0;
    }

    protected void postRoutineConversion(INativeMethodItem routine, IERoutineContext ctx) {
        this.functionDef = null;
        this.functionHandle = null;
        this.localSlotVars = null;
        this.opndstack = null;
        this.opndstackIndex = 0;
        this.opndstackCounter = 0;
    }

    protected void convertBlock(BasicBlock<LibraInstruction> b, List<IEStatement> interlist) {
        long base;
        long address = base = b.getFirstAddress();
        ArrayList r = new ArrayList();
        ConverterInstructionEntry e = new ConverterInstructionEntry();
        e.r = r;
        LibraInstruction insn = null;
        try {
            for (int i = 0; i < b.size(); ++i) {
                insn = (LibraInstruction)b.get(i);
                if (i == 0) {
                    this.opndstackIndex = insn.preExecStackDelta;
                }
                r.clear();
                int irAddress = interlist.size();
                e.insn = insn;
                e.address = address;
                e.irAddress = irAddress;
                Libra.OpcodeDef opcode = insn.getOpcode();
                switch (opcode) {
                    case LD_CONST: {
                        long val = insn.getOperandAsLong();
                        this.pushAssign((ConverterInstructionEntry<LibraInstruction>)e, SignatureToken.stUint64, (IEGeneric)this.ctx.createImm(val, 64));
                        break;
                    }
                    case ST_LOC: {
                        int idx = insn.getOperandAsIndex();
                        IEVar dst = this.getLocalSlot(idx);
                        IEVar var = this.pop();
                        e.r.add(this.ctx.createAssign((IEGeneric)dst, (IEGeneric)var));
                        break;
                    }
                    case LD_FALSE: 
                    case LD_TRUE: {
                        this.pushAssign((ConverterInstructionEntry<LibraInstruction>)e, SignatureToken.stBool, (IEGeneric)this.ctx.createImm(opcode == Libra.OpcodeDef.LD_FALSE ? 0L : 1L, 64));
                        break;
                    }
                    case COPY_LOC: 
                    case MOVE_LOC: {
                        int idx = insn.getOperandAsIndex();
                        IEVar var = this.getLocalSlot(idx);
                        SignatureToken sig = this.functionDef.getCode().getLocals(this.libra).getTokens().get(idx);
                        this.pushAssign((ConverterInstructionEntry<LibraInstruction>)e, sig, (IEGeneric)var);
                        if (opcode != Libra.OpcodeDef.MOVE_LOC) break;
                        e.r.add(this.ctx.createAssign((IEGeneric)var, (IEGeneric)this.ctx.createImm(0L, var.getBitsize())));
                        break;
                    }
                    case BR_FALSE: 
                    case BR_TRUE: {
                        IEVar cond = this.pop();
                        if (opcode == Libra.OpcodeDef.BR_FALSE) {
                            cond = this.ctx.createOperation(OperationType.LOG_NOT, (IEGeneric)cond);
                        }
                        long ftNativeAddress = e.address + (long)insn.getSize();
                        long brNativeAddress = ((IEntryPointDescription)insn.getBreakingFlow(e.address).getTargets().get(1)).getAddress();
                        IEAssign stm = this.ctx.createBranchAssign((IEGeneric)this.pc, (IEGeneric)this.ctx.createCond((IEGeneric)cond, (IEGeneric)this.ctx.createImm(brNativeAddress, 64), (IEGeneric)this.ctx.createImm(ftNativeAddress, 64)), false);
                        e.r.add(stm);
                        break;
                    }
                    case BRANCH: {
                        long brNativeAddress = ((IEntryPointDescription)insn.getBreakingFlow(e.address).getTargets().get(0)).getAddress();
                        IEAssign stm = this.ctx.createBranchAssign((IEGeneric)this.pc, (IEGeneric)this.ctx.createImm(brNativeAddress, 64), false);
                        e.r.add(stm);
                        break;
                    }
                    case NOT: {
                        OperationType optype = this.opcodeToOperationType(opcode);
                        IEVar opnd = this.pop();
                        IEOperation res = this.ctx.createOperation(optype, (IEGeneric)opnd);
                        res = res.zeroExtend(64);
                        this.pushAssign((ConverterInstructionEntry<LibraInstruction>)e, SignatureToken.stUint64, (IEGeneric)res);
                        break;
                    }
                    case ADD: 
                    case SUB: 
                    case MUL: 
                    case MOD: 
                    case DIV: 
                    case BIT_OR: 
                    case BIT_AND: 
                    case XOR: 
                    case OR: 
                    case AND: 
                    case EQ: 
                    case NEQ: 
                    case LT: 
                    case GT: 
                    case LE: 
                    case GE: {
                        OperationType optype = this.opcodeToOperationType(opcode);
                        IEVar opnd1 = this.pop();
                        IEVar opnd0 = this.pop();
                        IEOperation res = this.ctx.createOperation(optype, (IEGeneric)opnd0, (IEGeneric)opnd1);
                        SignatureToken token = SignatureToken.stUint64;
                        res = res.zeroExtend(64);
                        this.pushAssign((ConverterInstructionEntry<LibraInstruction>)e, token, (IEGeneric)res);
                        break;
                    }
                    case RET: {
                        IEReturn ret;
                        List<SignatureToken> returnTokens = this.functionHandle.getSignature(this.libra).getReturnTokens();
                        if (returnTokens.isEmpty()) {
                            ret = this.ctx.createReturn();
                        } else if (returnTokens.size() == 1) {
                            IEVar retvar = this.pop();
                            ret = this.ctx.createReturn((IEGeneric)retvar);
                        } else {
                            ArrayList<IEVar> retvars = new ArrayList<IEVar>(returnTokens.size());
                            for (int itoken = 0; itoken < returnTokens.size(); ++itoken) {
                                retvars.add(0, this.pop());
                            }
                            ret = this.ctx.createReturn(retvars);
                        }
                        e.r.add(ret);
                        break;
                    }
                    case POP: {
                        this.pop();
                        break;
                    }
                    case CALL: {
                        int idx = insn.getOperandAsIndex();
                        FunctionHandle f = (FunctionHandle)this.libra.functionHandles.get(idx);
                        String fname = f.getName(this.libra);
                        FunctionSignature fsig = f.getSignature(this.libra);
                        INativeMethodItem targetRoutine = this.pbcu.getInternalMethod(f.mappedAddress, true);
                        if (targetRoutine == null && (targetRoutine = this.pbcu.getMethod(fname)) == null) {
                            throw new UnsupportedConversionException("Cannot resolve routine");
                        }
                        IPrototypeItem proto = this.convertLibraPrototype(fsig);
                        if (targetRoutine.getPrototype() == null) {
                            targetRoutine.setPrototype(proto);
                        }
                        ArrayList<IEVar> _paramExp = new ArrayList<IEVar>();
                        for (SignatureToken signatureToken : fsig.getParamTokens()) {
                            _paramExp.add(0, this.pop());
                        }
                        ArrayList<IEVar> _returnExp = new ArrayList<IEVar>();
                        for (SignatureToken token : fsig.getReturnTokens()) {
                            _returnExp.add(this.push(token));
                        }
                        IEVar iEVar = this.ctx.createGlobalSymbol((INativeItem)targetRoutine);
                        IECall call = this.ctx.createCall((IEGeneric)iEVar, null, _returnExp, _paramExp, 0, null);
                        e.r.add(call);
                        break;
                    }
                    case LD_ADDR: {
                        int idx = insn.getOperandAsIndex();
                        byte[] bytes = ((AddressEntry)this.libra.addressPool.get(idx)).getBytes();
                        IEImm addr = this.ctx.createImm(bytes, 256);
                        this.pushAssign((ConverterInstructionEntry<LibraInstruction>)e, SignatureToken.stAddress, (IEGeneric)addr);
                        break;
                    }
                    case LD_BYTEARRAY: {
                        int idx = insn.getOperandAsIndex();
                        long addr = ((BytearrayEntry)this.libra.bytearrayPool.get((int)idx)).mappedAddress;
                        INativeContinuousItem item = this.pbcu.getNativeItemAt(addr);
                        IEVar symbol = this.ctx.createGlobalSymbol((INativeItem)item);
                        this.pushAssign((ConverterInstructionEntry<LibraInstruction>)e, SignatureToken.stBytearray, (IEGeneric)symbol);
                        break;
                    }
                    case LD_STR: {
                        int idx = insn.getOperandAsIndex();
                        long addr = ((StringEntry)this.libra.stringPool.get((int)idx)).mappedAddress;
                        INativeContinuousItem item = this.pbcu.getNativeItemAt(addr);
                        IEVar symbol = this.ctx.createGlobalSymbol((INativeItem)item);
                        this.pushAssign((ConverterInstructionEntry<LibraInstruction>)e, SignatureToken.stString, (IEGeneric)symbol);
                        break;
                    }
                    case BORROW_REF: {
                        int idx = insn.getOperandAsIndex();
                        StructDef sd = (StructDef)this.libra.structDefs.get(idx);
                        IEVar arg_addr = this.pop();
                        SignatureToken token = new SignatureToken(sd.getHandleIndex());
                        token = new SignatureToken(token, true);
                        IEVar res = this.push(token);
                        e.r.add(this.createUntranslated(this.ctx, address, insn, (IEGeneric)res, new IEGeneric[]{arg_addr}));
                        break;
                    }
                    case FREEZE_REF: {
                        IEVar arg_mutref = this.pop();
                        IEVar res = this.pushForce(arg_mutref.getType());
                        e.r.add(this.createUntranslated(this.ctx, address, insn, (IEGeneric)res, new IEGeneric[]{arg_mutref}));
                        break;
                    }
                    case LD_REF_FIELD: {
                        int idx = insn.getOperandAsIndex();
                        FieldDef field = (FieldDef)this.libra.fieldDefs.get(idx);
                        IEVar arg_ref = this.pop();
                        SignatureToken token = field.getSignature(this.libra).getToken();
                        token = new SignatureToken(token, true);
                        long fieldNameAddr = ((StringEntry)this.libra.stringPool.get((int)field.name_index)).mappedAddress;
                        INativeContinuousItem fieldNameItem = this.pbcu.getNativeItemAt(fieldNameAddr);
                        IEVar arg_fieldname = this.ctx.createGlobalSymbol((INativeItem)fieldNameItem);
                        IEVar iEVar = this.push(token);
                        e.r.add(this.createUntranslated(this.ctx, address, insn, (IEGeneric)iEVar, new IEGeneric[]{arg_ref, arg_fieldname}));
                        break;
                    }
                    case READ_REF: {
                        IEVar res;
                        IEVar arg_ref = this.pop();
                        IWildcardType t = arg_ref.getType();
                        if (t != null && t.getNativeType() instanceof IReferenceType) {
                            INativeType nt = ((IReferenceType)t.getNativeType()).getPointedType();
                            t = this.ctx.getWildcardTypeManager().create(nt);
                            res = this.pushForce(t);
                        } else {
                            res = this.push(SignatureToken.stAnyMutableRef);
                        }
                        e.r.add(this.createUntranslated(this.ctx, address, insn, (IEGeneric)res, new IEGeneric[]{arg_ref}));
                        break;
                    }
                    case WRITE_REF: {
                        IEVar refval = this.pop();
                        IEVar val = this.pop();
                        e.r.add(this.createUntranslated(this.ctx, address, insn, null, new IEGeneric[]{refval, val}));
                        break;
                    }
                    case PACK: {
                        int idx = insn.getOperandAsIndex();
                        StructDef sd = (StructDef)this.libra.structDefs.get(idx);
                        int popcnt = sd.getFieldCount();
                        IEGeneric[] opnds = new IEGeneric[popcnt];
                        for (int opndindex = 0; opndindex < popcnt; ++opndindex) {
                            opnds[popcnt - 1 - opndindex] = this.pop();
                        }
                        SignatureToken token = new SignatureToken(sd.getHandleIndex());
                        token = new SignatureToken(token, true);
                        IEVar res = this.push(token);
                        e.r.add(this.createUntranslated(this.ctx, address, insn, (IEGeneric)res, opnds));
                        break;
                    }
                    case UNPACK: {
                        int idx = insn.getOperandAsIndex();
                        StructDef sd = (StructDef)this.libra.structDefs.get(idx);
                        IEVar instance = this.pop();
                        int pushcnt = sd.getFieldCount();
                        ArrayList<IEVar> retvals = new ArrayList<IEVar>(pushcnt);
                        for (int fi = 0; fi < pushcnt; ++fi) {
                            retvals.add(this.push(sd.getFields(this.libra).get(fi).getSignature(this.libra).getToken()));
                        }
                        IEUntranslatedInstruction ir = this.createUntranslated(this.ctx, address, insn, null, new IEGeneric[]{instance});
                        ir.setResultExpressions(retvals);
                        e.r.add(ir);
                        break;
                    }
                    case MOVE_TO: {
                        int idx = insn.getOperandAsIndex();
                        StructDef sd = (StructDef)this.libra.structDefs.get(idx);
                        IEVar arg_addr = this.pop();
                        e.r.add(this.createUntranslated(this.ctx, address, insn, null, new IEGeneric[]{arg_addr}));
                        break;
                    }
                    case MOVE_FROM: {
                        int idx = insn.getOperandAsIndex();
                        StructDef sd = (StructDef)this.libra.structDefs.get(idx);
                        IEVar arg_addr = this.pop();
                        e.r.add(this.createUntranslated(this.ctx, address, insn, null, new IEGeneric[]{arg_addr}));
                        break;
                    }
                    case EXISTS: {
                        int idx = insn.getOperandAsIndex();
                        StructDef sd = (StructDef)this.libra.structDefs.get(idx);
                        IEVar arg_addr = this.pop();
                        IEVar res = this.push(SignatureToken.stBool);
                        e.r.add(this.createUntranslated(this.ctx, address, insn, (IEGeneric)res, new IEGeneric[]{arg_addr}));
                        break;
                    }
                    case LD_REF_LOC: {
                        int idx = insn.getOperandAsIndex();
                        SignatureToken token = this.functionDef.getCode().getLocals(this.libra).getTokens().get(idx);
                        token = new SignatureToken(token, false);
                        IEVar local = this.getLocalSlot(idx);
                        IEVar res = this.push(token);
                        e.r.add(this.createUntranslated(this.ctx, address, insn, (IEGeneric)res, new IEGeneric[]{local}));
                        break;
                    }
                    case GET_TXN_SEQUENCE_NUMBER: 
                    case GET_GAS_REMAINING: 
                    case GET_TXN_GAS_UNIT_PRICE: 
                    case GET_TXN_MAX_GAS_UNITS: 
                    case GET_TXN_SENDER: 
                    case GET_TXN_PUBLIC_KEY: 
                    case ASSERT: 
                    case EMIT_EVENT: 
                    case CREATE_ACCOUNT: 
                    case RELEASE_REF: {
                        Assert.a((insn.getOpcode().getOperandType() == Libra.OpndType.None ? 1 : 0) != 0);
                        int popcnt = insn.getOpcode().getPopCount();
                        int pushcnt = insn.getOpcode().getPushCount();
                        IEGeneric[] opnds = new IEGeneric[popcnt];
                        for (int opndindex = 0; opndindex < popcnt; ++opndindex) {
                            opnds[popcnt - 1 - opndindex] = this.pop();
                        }
                        IEVar res = null;
                        Assert.a((pushcnt <= 1 ? 1 : 0) != 0);
                        if (pushcnt == 1) {
                            switch (opcode) {
                                case EXISTS: {
                                    res = this.push(SignatureToken.stBool);
                                    break;
                                }
                                case GET_TXN_SEQUENCE_NUMBER: 
                                case GET_GAS_REMAINING: 
                                case GET_TXN_GAS_UNIT_PRICE: 
                                case GET_TXN_MAX_GAS_UNITS: {
                                    res = this.push(SignatureToken.stUint64);
                                    break;
                                }
                                case GET_TXN_SENDER: {
                                    res = this.push(SignatureToken.stAddress);
                                    break;
                                }
                                case GET_TXN_PUBLIC_KEY: {
                                    res = this.push(SignatureToken.stBytearray);
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("TBI: return type for " + (Object)((Object)opcode));
                                }
                            }
                        }
                        e.r.add(this.createUntranslated(this.ctx, address, insn, (IEGeneric)res, opnds));
                        break;
                    }
                    default: {
                        throw new UnsupportedConversionException(String.format("Cannot convert instruction: %s", insn.getOpcode().getHLMnemonic()));
                    }
                }
                this.ctx.registerConvertedAddressRange(address, irAddress, irAddress + r.size());
                for (IEStatement stm : r) {
                    logger.i("0x%X -> %s", new Object[]{address, stm});
                    interlist.add(stm);
                }
                address += (long)insn.getSize();
            }
        }
        catch (Throwable ex) {
            logger.error("Error: Instruction cannot be converted: %Xh: %s: %s", new Object[]{address, Formatter.byteArrayToHexString((byte[])insn.getCode()), insn.format(address)});
            logger.catchingSilent(ex);
            throw ex;
        }
    }

    OperationType opcodeToOperationType(Libra.OpcodeDef opcode) {
        switch (opcode) {
            case ADD: {
                return OperationType.ADD;
            }
            case SUB: {
                return OperationType.SUB;
            }
            case MUL: {
                return OperationType.MUL_U;
            }
            case MOD: {
                return OperationType.REM_U;
            }
            case DIV: {
                return OperationType.DIV_U;
            }
            case BIT_OR: {
                return OperationType.OR;
            }
            case BIT_AND: {
                return OperationType.AND;
            }
            case XOR: {
                return OperationType.XOR;
            }
            case OR: {
                return OperationType.LOG_OR;
            }
            case AND: {
                return OperationType.LOG_AND;
            }
            case EQ: {
                return OperationType.LOG_EQ;
            }
            case NEQ: {
                return OperationType.LOG_NEQ;
            }
            case LT: {
                return OperationType.LT_U;
            }
            case GT: {
                return OperationType.GT_U;
            }
            case LE: {
                return OperationType.LE_U;
            }
            case GE: {
                return OperationType.GE_U;
            }
            case NOT: {
                return OperationType.LOG_NOT;
            }
        }
        throw new RuntimeException("TBI: conversion for operator: " + (Object)((Object)opcode));
    }

    IEVar getLocalSlot(int index) {
        return this.localSlotVars.get(index);
    }

    void pushAssign(ConverterInstructionEntry<LibraInstruction> e, SignatureToken st, IEGeneric expression) {
        IEVar stkvar = st == null ? this.pushForce(expression.getBitsize()) : this.push(st);
        e.r.add(this.ctx.createAssign((IEGeneric)stkvar, expression));
    }

    IEVar pushForce(int bitsize) {
        IEVar stkvar;
        if (this.opndstackIndex < this.opndstack.size()) {
            stkvar = this.createVariable(PFX_STACK + this.opndstackCounter, bitsize);
            this.opndstack.set(this.opndstackIndex, new StackSlot(stkvar, null));
            ++this.opndstackCounter;
        } else {
            stkvar = this.createVariable(PFX_STACK + this.opndstackCounter, bitsize);
            this.opndstack.add(new StackSlot(stkvar, null));
            ++this.opndstackCounter;
        }
        ++this.opndstackIndex;
        return stkvar;
    }

    IEVar pushForce(IWildcardType type) {
        IEVar stkvar;
        if (this.opndstackIndex < this.opndstack.size()) {
            stkvar = this.createVariable(PFX_STACK + this.opndstackCounter, type.getBitsize());
            this.opndstack.set(this.opndstackIndex, new StackSlot(stkvar, null));
            ++this.opndstackCounter;
        } else {
            stkvar = this.createVariable(PFX_STACK + this.opndstackCounter, type.getBitsize());
            this.opndstack.add(new StackSlot(stkvar, null));
            ++this.opndstackCounter;
        }
        stkvar.setType(type);
        ++this.opndstackIndex;
        return stkvar;
    }

    IEVar push(SignatureToken st) {
        IEVar stkvar;
        Assert.a((st != null ? 1 : 0) != 0);
        INativeType nativeType = this.convertLibraType(st);
        IWildcardType type = this.ctx.getWildcardTypeManager().create(nativeType);
        if (this.opndstackIndex < this.opndstack.size()) {
            StackSlot slot = this.opndstack.get(this.opndstackIndex);
            if (slot.st != null && slot.st.equals(st)) {
                stkvar = slot.var;
            } else {
                stkvar = this.createVariable(PFX_STACK + this.opndstackCounter, type.getBitsize());
                stkvar.setType(type);
                this.opndstack.set(this.opndstackIndex, new StackSlot(stkvar, st));
                ++this.opndstackCounter;
            }
        } else {
            stkvar = this.createVariable(PFX_STACK + this.opndstackCounter, type.getBitsize());
            stkvar.setType(type);
            this.opndstack.add(new StackSlot(stkvar, st));
            ++this.opndstackCounter;
        }
        ++this.opndstackIndex;
        return stkvar;
    }

    IEVar pop() {
        Assert.a((this.opndstackIndex > 0 ? 1 : 0) != 0);
        --this.opndstackIndex;
        return this.opndstack.get((int)this.opndstackIndex).var;
    }

    IEVar peek() {
        Assert.a((this.opndstackIndex > 0 ? 1 : 0) != 0);
        return this.opndstack.get((int)(this.opndstackIndex - 1)).var;
    }

    public int insertReturns(IERoutineContext _ctx) {
        return 0;
    }

    void autoAssignFunctionPrototypes() {
        for (INativeMethodItem routine : this.pbcu.getMethods()) {
            this.autoAssignFunctionPrototype(routine, false);
        }
    }

    IPrototypeItem autoAssignFunctionPrototype(INativeMethodItem routine, boolean force) {
        IPrototypeItem proto = routine.getPrototype();
        if (proto == null || force) {
            FunctionHandle f = this.libra.getFunctionHandleByName(routine.getName(false));
            proto = this.convertLibraPrototype(f.getSignature(this.libra));
            routine.setPrototype(proto);
        }
        return proto;
    }

    IPrototypeItem convertLibraPrototype(FunctionSignature fsig) {
        ICallingConvention cc = this.pbcu.getTypeManager().getCallingConventionManager().getDefaultConvention();
        ArrayList<INativeType> nativeParameterTypes = new ArrayList<INativeType>();
        for (SignatureToken token : fsig.getParamTokens()) {
            INativeType t = this.convertLibraType(token);
            nativeParameterTypes.add(t);
        }
        ArrayList<INativeType> nativeReturnTypes = new ArrayList<INativeType>();
        for (SignatureToken token : fsig.getReturnTokens()) {
            INativeType t = this.convertLibraType(token);
            nativeReturnTypes.add(t);
        }
        if (fsig.getReturnTokens().size() >= 2) {
            logger.debug("take not: method has 2+ return values: %s", new Object[]{this.libra.formatObject(fsig)});
        }
        return this.pbcu.getTypeManager().createPrototypeEx(cc, nativeReturnTypes, nativeParameterTypes, null);
    }

    int getLibraTypeBitsize(SignatureToken st) {
        switch (st.getSerializedType()) {
            case BOOL: {
                return 64;
            }
            case INTEGER: {
                return 64;
            }
            case MUTABLE_REFERENCE: {
                return 64;
            }
            case REFERENCE: {
                return 64;
            }
            case ADDRESS: {
                return 256;
            }
            case BYTEARRAY: {
                return 64;
            }
            case STRING: {
                return 64;
            }
            case STRUCT: {
                return 64;
            }
        }
        throw new RuntimeException();
    }

    INativeType convertLibraType(SignatureToken token) {
        ITypeManager typeman = this.pbcu.getTypeManager();
        switch (token.getSerializedType()) {
            case BOOL: {
                return typeman.getType("bool");
            }
            case INTEGER: {
                return typeman.getType("u64");
            }
            case ADDRESS: {
                return typeman.getType("address");
            }
            case BYTEARRAY: {
                return typeman.getType("bytearray");
            }
            case STRING: {
                return typeman.getType("string");
            }
            case STRUCT: {
                StructHandle sh = token.getStructureHandle(this.libra);
                String sname = sh.getFullName(this.libra).replace('@', '_').replace('.', '_');
                INativeType stype = typeman.getType(sname);
                if (stype == null) {
                    stype = typeman.createStructure(sname);
                }
                return stype.getReference();
            }
            case MUTABLE_REFERENCE: 
            case REFERENCE: {
                SignatureToken token0 = token.getReference();
                if (token0 == null) {
                    return typeman.getVoidReference();
                }
                INativeType t = this.convertLibraType(token0);
                return typeman.createReference(t);
            }
        }
        throw new RuntimeException("TBI: type conversion: " + token);
    }

    List<IEVar> getIRParameterVariables(IERoutineContext ctx, FunctionHandle fh) {
        IWildcardTypeManager etypeman = ctx.getWildcardTypeManager();
        ArrayList<IEVar> r = new ArrayList<IEVar>();
        List<SignatureToken> tokens = fh.getSignature(this.libra).getParamTokens();
        for (int index = 0; index < tokens.size(); ++index) {
            IEVar var = ctx.getVariableByName("local" + index);
            var.setType(etypeman.create(this.convertLibraType(tokens.get(index))));
            r.add(var);
        }
        return r;
    }

    List<IWildcardType> getIRReturnTypes(IERoutineContext ctx, FunctionHandle fh) {
        IWildcardTypeManager etypeman = ctx.getWildcardTypeManager();
        ArrayList<IWildcardType> r = new ArrayList<IWildcardType>();
        for (SignatureToken token : fh.getSignature(this.libra).getReturnTokens()) {
            r.add(etypeman.create(this.convertLibraType(token)));
        }
        return r;
    }

    public IEPrototypeHandler getPrototypeHandler(IERoutineContext ctx) {
        return new ProtoHandler(ctx);
    }

    IEUntranslatedInstruction createUntranslated(IERoutineContext ctx, long nativeAddress, LibraInstruction insn, IEGeneric irResult, IEGeneric ... irOperands) {
        String mn = insn.getOpcode().getHLMnemonic();
        IEUntranslatedInstruction _1 = ctx.createUntranslatedInstruction(nativeAddress, mn, irOperands);
        _1.setTag((Object)insn.getOpcode().getOpcode());
        _1.setResultExpression(irResult);
        return _1;
    }

    private class ProtoHandler
    implements IEPrototypeHandler {
        IERoutineContext ctx;

        ProtoHandler(IERoutineContext ctx) {
            this.ctx = ctx;
        }

        public void applyTypesToVars() {
        }

        public void retrieveTypesAndVars(List<IEVar> params, List<IWildcardType> rettypes) {
            FunctionHandle fh = LibraConverter.this.libra.getFunctionHandleByName(this.ctx.getRoutine().getName(false));
            params.addAll(LibraConverter.this.getIRParameterVariables(this.ctx, fh));
            rettypes.addAll(LibraConverter.this.getIRReturnTypes(this.ctx, fh));
        }

        public int refineWildcardPrototype() {
            return 0;
        }
    }

    static class StackSlot {
        IEVar var;
        SignatureToken st;

        public StackSlot(IEVar var, SignatureToken st) {
            this.var = var;
            this.st = st;
        }
    }
}

