/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.exceptions.NativeAnalyzerException;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.units.code.EntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.asm.ChainedOperationResult;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.AbstractAnalyzerExtension;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.ILabelManager;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureTypeField;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.core.units.codeobject.CoffDebugDirectoryEntry;
import com.pnfsoftware.jeb.core.units.codeobject.IPECOFFUnit;
import com.pnfsoftware.jeb.core.units.codeobject.IPEDataDirectory;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.corei.parsers.winpe.Uk;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.INet;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.Gj;
import com.pnfsoftware.jebglobal.Go;
import com.pnfsoftware.jebglobal.Ns;
import com.pnfsoftware.jebglobal.TF;
import com.pnfsoftware.jebglobal.Ym;
import com.pnfsoftware.jebglobal.xZ;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;

@Ser
public class ZX
extends AbstractAnalyzerExtension<xZ> {
    private static final ILogger eO = GlobalLog.getLogger(ZX.class);
    @SerId(value=1)
    private Integer Le;

    @Override
    public ChainedOperationResult<Boolean> preprocessImage(int n) {
        Assert.a(this.gca.getContainer() instanceof IPECOFFUnit);
        IPECOFFUnit iPECOFFUnit = (IPECOFFUnit)this.gca.getContainer();
        if (n == 0) {
            try {
                this.eO(iPECOFFUnit);
                this.Le(iPECOFFUnit);
            }
            catch (Exception exception) {
                JebCoreService.notifySilentExceptionToClient(new NativeAnalyzerException("PE preprocessing"));
            }
        }
        if (this.Le == null || this.Le < 0) {
            try {
                this.Le = this.Qx(iPECOFFUnit);
            }
            catch (Exception exception) {
                this.Le = null;
                eO.catchingSilent(exception);
            }
            if (this.Le != null && this.Le > 0) {
                eO.info("Applied debug symbols: %d", this.Le);
            }
        }
        return ChainedOperationResult.TRUE_CONTINUE;
    }

    private void eO(IPECOFFUnit iPECOFFUnit) {
        ILabelManager iLabelManager = this.gca.getModel().getLabelManager();
        long l2 = iPECOFFUnit.getLoaderInformation().getImageBase();
        boolean bl2 = iPECOFFUnit.getLoaderInformation().getTargetProcessor().is64Bit();
        INativeType iNativeType = this.gca.getTypeManager().getType("IMAGE_DOS_HEADER");
        if (iNativeType != null) {
            this.gca.defineData(l2, iNativeType);
            iLabelManager.setLabel(l2, "MZHeader", true, true, false);
        }
        IVirtualMemory iVirtualMemory = this.gca.getMemory();
        try {
            INativeType iNativeType2;
            int n = iVirtualMemory.readInt(l2 + 60L);
            int n2 = n + 4 + 20;
            int n3 = iVirtualMemory.readShort(l2 + (long)n + 4L + 16L) & 0xFFFF;
            int n4 = n2 + n3;
            int n5 = iVirtualMemory.readShort(l2 + (long)n + 4L + 2L) & 0xFFFF;
            int n6 = 24 + n3;
            INativeType iNativeType3 = this.gca.getTypeManager().getType("IMAGE_NT_HEADERS" + (bl2 ? "64" : ""));
            if (iNativeType3 != null) {
                this.gca.defineData(l2 + (long)n, iNativeType3, n6);
                iLabelManager.setLabel(l2 + (long)n, "PEHeader", true, true, false);
            }
            if ((iNativeType2 = this.gca.getTypeManager().getType("IMAGE_SECTION_HEADER")) != null) {
                for (int j = 0; j < n5; ++j) {
                    this.gca.defineData(l2 + (long)n4, iNativeType2);
                    iLabelManager.setLabel(l2 + (long)n4, String.format("SectionHeader%02d", j), true, true, false);
                    n4 += 40;
                }
            }
        }
        catch (MemoryException memoryException) {
            return;
        }
    }

    private void Le(IPECOFFUnit iPECOFFUnit) {
        int n;
        IPEDataDirectory iPEDataDirectory;
        boolean bl2;
        long l2;
        IVirtualMemory iVirtualMemory = this.gca.getMemory();
        try {
            l2 = iPECOFFUnit.getLoaderInformation().getImageBase();
            bl2 = iPECOFFUnit.getLoaderInformation().getTargetProcessor().is64Bit();
        }
        catch (Exception exception) {
            return;
        }
        try {
            if (iPECOFFUnit.getPEOptionalHeader() != null && (iPEDataDirectory = iPECOFFUnit.getPEOptionalHeader().getDataDirectory()[10]).getPosition() > 0L && iPEDataDirectory.getSize() > 0L) {
                INativeDataItem iNativeDataItem;
                long l3;
                int n2;
                INativeType iNativeType = this.gca.getTypeManager().getType("DWORD");
                INativeType iNativeType2 = this.gca.getTypeManager().getType("IMAGE_LOAD_CONFIG_DIRECTORY" + (bl2 ? "64" : "32"));
                if (iNativeType2 != null && (n2 = iVirtualMemory.readInt(l3 = l2 + iPEDataDirectory.getPosition())) >= 0 && n2 <= 4096 && (iNativeDataItem = this.gca.defineData(l3, iNativeType2, n2)) != null) {
                    iNativeDataItem.setName("loadConfigDir");
                    IStructureTypeField iStructureTypeField = TypeUtil.getStructureField(iNativeType2, "SEHandlerTable");
                    IStructureTypeField iStructureTypeField2 = TypeUtil.getStructureField(iNativeType2, "SEHandlerCount");
                    if (iStructureTypeField != null && iStructureTypeField2 != null && iStructureTypeField.getLastOffset() <= n2 && iStructureTypeField2.getLastOffset() <= n2) {
                        long l4 = iVirtualMemory.readPointer(l3 + (long)iStructureTypeField.getOffset());
                        for (long j = iVirtualMemory.readPointer(l3 + (long)iStructureTypeField2.getOffset()); j > 0L; --j) {
                            n = iVirtualMemory.readInt(l4);
                            long l5 = l2 + (long)n;
                            this.gca.defineData(l4, iNativeType);
                            this.gca.getModel().getCommentManager().addComment(l4, String.format("Structured Exception Handler @ %Xh", l5));
                            this.gca.enqueuePointerForAnalysis(new EntryPointDescription(l5));
                            l4 += 4L;
                        }
                    }
                    iStructureTypeField = TypeUtil.getStructureField(iNativeType2, "GuardCFFunctionTable");
                    iStructureTypeField2 = TypeUtil.getStructureField(iNativeType2, "GuardCFFunctionCount");
                    IStructureTypeField iStructureTypeField3 = TypeUtil.getStructureField(iNativeType2, "GuardFlags");
                    if (iStructureTypeField != null && iStructureTypeField2 != null && iStructureTypeField3 != null && iStructureTypeField.getLastOffset() <= n2 && iStructureTypeField2.getLastOffset() <= n2) {
                        long l6 = iVirtualMemory.readPointer(l3 + (long)iStructureTypeField.getOffset());
                        long l7 = iVirtualMemory.readPointer(l3 + (long)iStructureTypeField2.getOffset());
                        int n3 = iVirtualMemory.readInt(l3 + (long)iStructureTypeField3.getOffset());
                        int n4 = 4 + ((n3 & 0xF0000000) >> 28);
                        this.gca.getModel().getCommentManager().addComment(l6, String.format("__guard_fids_table", new Object[0]));
                        int n5 = 0;
                        while ((long)n5 < l7) {
                            int n6 = iVirtualMemory.readInt(l6);
                            long l8 = l2 + (long)n6;
                            this.gca.defineData(l6, iNativeType);
                            this.gca.enqueuePointerForAnalysis(new EntryPointDescription(l8));
                            l6 += (long)n4;
                            ++n5;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            JebCoreService.notifySilentExceptionToClient(new NativeAnalyzerException("PE LOAD_CONFIGURATION parsing"));
        }
        try {
            byte[] byArray;
            int n7;
            long l9;
            if (bl2 && iPECOFFUnit.getPEOptionalHeader() != null && (iPEDataDirectory = iPECOFFUnit.getPEOptionalHeader().getDataDirectory()[3]).getPosition() > 0L && iPEDataDirectory.getSize() > 0L && iVirtualMemory.read(l9 = l2 + iPEDataDirectory.getPosition(), n7 = (int)iPEDataDirectory.getSize(), byArray = new byte[n7], 0) == n7) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                while (byteBuffer.remaining() >= 12) {
                    int n8;
                    long l10 = l2 + (long)byteBuffer.getInt();
                    byteBuffer.getInt();
                    long l11 = l2 + ((long)byteBuffer.getInt() & 0xFFFFFFFFL);
                    int n9 = iVirtualMemory.readInt(l11);
                    if ((n9 & 7) != 1) continue;
                    int n10 = n9 >> 3 & 0x1F;
                    if (n10 == 0 && this.gca.getAnalysisRanges().contains(l10)) {
                        this.gca.enqueuePointerForAnalysis(new EntryPointDescription(l10));
                    }
                    if ((n10 & 3) == 0) continue;
                    if (this.gca.getAnalysisRanges().contains(l10)) {
                        this.gca.enqueuePointerForAnalysis(new EntryPointDescription(l10));
                    }
                    n = (n8 = n9 >> 16 & 0xFF) % 2 == 0 ? n8 : n8 + 1;
                    int n11 = 4 + n * 2;
                    long l12 = l2 + ((long)iVirtualMemory.readInt(l11 + (long)n11) & 0xFFFFFFFFL);
                    if (!this.gca.getAnalysisRanges().contains(l12)) continue;
                    this.gca.enqueuePointerForAnalysis(new EntryPointDescription(l12));
                }
            }
        }
        catch (Exception exception) {
            JebCoreService.notifySilentExceptionToClient(new NativeAnalyzerException("PE IMAGE_DIRECTORY_ENTRY_EXCEPTION parsing"));
        }
    }

    private int Qx(IPECOFFUnit iPECOFFUnit) throws IOException {
        if (this.gca.getDebugInformationPolicy().getUsage() != 2) {
            return -1;
        }
        for (CoffDebugDirectoryEntry coffDebugDirectoryEntry : Uk.eO(iPECOFFUnit)) {
            if (coffDebugDirectoryEntry.getType() != 2) continue;
            int n = coffDebugDirectoryEntry.getPointerToRawData();
            SeekableByteChannel seekableByteChannel = iPECOFFUnit.getInput().getChannel();
            Throwable throwable = null;
            try {
                int n2 = ChannelUtil.getInt(seekableByteChannel, n, ByteOrder.LITTLE_ENDIAN);
                if (n2 != 1396986706) continue;
                Ns ns2 = Ns.eO(seekableByteChannel);
                eO.i("PDB: %s", ns2);
                int n3 = this.eO(iPECOFFUnit, ns2);
                return n3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (seekableByteChannel == null) continue;
                if (throwable != null) {
                    try {
                        seekableByteChannel.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                seekableByteChannel.close();
            }
        }
        return 0;
    }

    private int eO(IPECOFFUnit iPECOFFUnit, Ns ns2) throws IOException {
        Object object;
        Object object2;
        int n = this.gca.getDebugInformationPolicy().getRetrieval();
        if (n == 0) {
            eO.warn("PDB: %s", ns2);
            return -1;
        }
        Object object3 = null;
        if (iPECOFFUnit.getInput() instanceof FileInput && Gj.eO(ns2, (File)(object2 = IO.replaceExtension((File)(object = ((FileInput)iPECOFFUnit.getInput()).getFile()), ".pdb")))) {
            object3 = object2;
        }
        if (object3 == null) {
            object = null;
            if (n == 2) {
                object2 = JebCoreService.getDefaultEnginesContext();
                object = object2.getNetworkUtility();
            }
            object2 = Gj.eO(false);
            ((Gj)object2).eO((INet)object);
            object3 = ((Gj)object2).eO(ns2);
            if (object3 == null) {
                return object == null ? -1 : 0;
            }
        }
        object = new TF(new FileInput((File)object3));
        object2 = null;
        try {
            if (!((TF)object).eO(ns2)) {
                int n2 = 0;
                return n2;
            }
            int n3 = 0;
            for (Ym ym2 : ((TF)object).Le(ns2.Le())) {
                if (!(ym2 instanceof Go)) continue;
                Go go2 = (Go)ym2;
                String string = go2.lS();
                long l2 = this.eO(iPECOFFUnit, go2.Qx(), go2.Le());
                if (Strings.isBlank(string) || l2 == -1L) continue;
                boolean bl2 = this.gca.getModel().getLabelManager().setLabel(l2, string, true, true, false);
                eO.debug("Debug Symbol: %Xh: %s: %s", l2, string, bl2 ? "success" : "failure");
                ++n3;
            }
            int n4 = n3;
            return n4;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((TF)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((TF)object).close();
                }
            }
        }
    }

    private long eO(IPECOFFUnit iPECOFFUnit, int n, int n2) {
        if (n < 0 || n >= iPECOFFUnit.getSegmentCount()) {
            return -1L;
        }
        if (n2 == -1) {
            return -1L;
        }
        ISegmentInformation iSegmentInformation = iPECOFFUnit.getSegment(n);
        return iPECOFFUnit.getLoaderInformation().getImageBase() + iSegmentInformation.getOffsetInMemory() + (long)(n2 & 0xFFFFFFFF);
    }
}

