/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.LEDataInputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.reflect.ReflectionHelper;
import com.pnfsoftware.jeb.util.serialization.AbstractInternalDeserializer;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.PreCollection;
import com.pnfsoftware.jeb.util.serialization.PreMap;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class Deserializer_v4
extends AbstractInternalDeserializer {
    private static final ILogger logger = GlobalLog.getLogger(Deserializer_v4.class);
    private List<String> stringpool;

    public Deserializer_v4(ITypeIdProvider iTypeIdProvider, List<ClassLoader> list, LEDataInputStream lEDataInputStream) {
        super(iTypeIdProvider, list, lEDataInputStream);
    }

    public void setStringPool(List<String> list) {
        this.stringpool = list;
    }

    public List<String> getStringPool() {
        return this.stringpool;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object readInternal(Object object, Class<?> clazz) throws IOException {
        int n;
        boolean bl2;
        boolean bl3 = bl2 = clazz == null;
        if (bl2 && object != null) {
            throw new SerializationException("Object should not be provided, a leaf is being deserialized", clazz);
        }
        Object object2 = object;
        int n2 = this.in.readIntULEB128();
        int n3 = 0;
        String string = null;
        int n4 = 0;
        int n5 = 0;
        if (bl2) {
            Class<?> clazz2;
            int n6;
            if ((n2 & 0x10) != 0) {
                n5 = this.in.readByte() & 0xFF;
            }
            if (n2 == 1) {
                return null;
            }
            if ((n2 & 0x40) != 0) {
                int n7 = n2 & 0x3F;
                switch (n7) {
                    case 0: {
                        return Boolean.FALSE;
                    }
                    case 1: {
                        return Boolean.TRUE;
                    }
                    case 2: {
                        return this.in.readIntULEB128();
                    }
                    case 3: {
                        return this.in.readLongULEB128();
                    }
                    case 4: {
                        return "";
                    }
                    case 5: {
                        return 0;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return -1;
                    }
                    case 8: {
                        return 0L;
                    }
                    case 9: {
                        return 1L;
                    }
                    case 10: {
                        return -1L;
                    }
                }
                throw new SerializationException("Unknown special object index: " + n7);
            }
            n3 = this.in.readIntULEB128();
            if ((n2 & 4) != 0) {
                Object v2 = this.objmap.get(n3);
                if (v2 != null) return v2;
                throw new SerializationException(String.format("Expected an already-deserialized object for id: %d", n3), clazz);
            }
            n4 = this.in.readIntULEB128() - 128;
            if ((n2 & 0x100) != 0) {
                n6 = this.in.readIntULEB128();
                byte[] byArray = new byte[n6];
                this.in.readFully(byArray);
                string = Strings.decodeUTF8(byArray);
            } else if ((n2 & 0x200) != 0) {
                n6 = this.in.readIntULEB128();
                Class<?> clazz3 = this.objmap.get(n6).getClass();
                string = ReflectionHelper.reduceDimensions(clazz3).getName();
            }
            try {
                clazz2 = n4 > 0 ? this.customTypeIdProvider.getType(n4) : (n4 < 0 ? this.nativeTypeIdProvider.getType(n4) : this.loadClass(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SerializationException(String.format("Class not found for type id: %d", n4), classNotFoundException, clazz);
            }
            if (clazz != null && clazz != clazz2) {
                throw new SerializationException(String.format("Unexpected class was found for type id %d: %s", n4, clazz2), clazz);
            }
            clazz = clazz2;
            if (clazz2 == null) {
                throw new SerializationException(String.format("Type was expected for id %d, got null", n4), clazz);
            }
        } else {
            n4 = this.nativeTypeIdProvider.getId(clazz);
            if (n4 == 0) {
                n4 = this.customTypeIdProvider.getId(clazz);
            }
        }
        if ((n2 & 2) != 0) {
            int n8 = this.in.readIntULEB128();
            object2 = clazz.getEnumConstants()[n8];
            this.registerObject(true, n3, object2);
            return object2;
        }
        int n9 = n = (n2 & 0x20) != 0 ? this.in.readIntULEB128() : 0;
        if (n4 >= 0 && n5 == 0) {
            Class<?> clazz4;
            if (bl2) {
                Object v3 = this.constructorMap.get(clazz);
                if (v3 == null) {
                    void var11_23;
                    Object object3 = this.mootObject;
                    try {
                        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                        if (constructor.getAnnotation(SerConstructor.class) != null) {
                            Constructor<?> constructor2 = constructor;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (Exception exception) {
                        throw new SerializationException(exception, clazz);
                    }
                    this.constructorMap.put(clazz, var11_23);
                }
                try {
                    void var11_24;
                    object2 = var11_24 instanceof Constructor ? ReflectionHelper.newInstance2((Constructor)var11_24) : this.objenesis.getInstantiatorOf(clazz).newInstance();
                }
                catch (Exception exception) {
                    throw new SerializationException(exception, clazz);
                }
                this.registerObject(bl2, n3, object2);
            }
            if ((clazz4 = clazz.getSuperclass()) != null) {
                this.read(object2, clazz4);
            }
            AbstractInternalDeserializer.CustomMethods customMethods = this.getCustomMethods(object2, clazz);
            if (customMethods.mCustomRead != null) {
                try {
                    ReflectionHelper.invoke2(customMethods.mCustomRead, object2, new DeserializerHelper(this, object2, clazz, n));
                }
                catch (Exception exception) {
                    throw new SerializationException("Custom read failed", exception, clazz);
                }
            } else {
                this.restoreFields(object2, clazz);
            }
            if (customMethods.mCustomInit != null) {
                try {
                    ReflectionHelper.invoke2(customMethods.mCustomInit, object2, new Object[0]);
                }
                catch (Exception exception) {
                    throw new SerializationException("Initializer failed", exception, clazz);
                }
            }
            this.notifyDeserializationEvent(1, clazz, object2);
        } else if (n5 > 0) {
            int n10;
            int[] nArray = new int[n5];
            nArray[0] = n10 = this.in.readIntULEB128();
            Object object4 = Array.newInstance(clazz, nArray);
            this.registerObject(bl2, n3, object4);
            for (int j = 0; j < n10; ++j) {
                Array.set(object4, j, this.read());
            }
            object2 = object4;
        } else if (clazz == Object.class) {
            if (object == null) {
                object = new Object();
            }
            object2 = object;
        } else if (clazz == Boolean.class) {
            object2 = this.in.readByte() == 0 ? Boolean.FALSE : Boolean.TRUE;
        } else if (clazz == boolean[].class) {
            int n11 = this.in.readIntULEB128();
            boolean[] blArray = new boolean[n11];
            for (int j = 0; j < n11; ++j) {
                blArray[j] = this.in.readByte() != 0;
            }
            object2 = blArray;
        } else if (clazz == Byte.class) {
            object2 = this.in.readByte();
        } else if (clazz == byte[].class) {
            int n12 = this.in.readIntULEB128();
            byte[] byArray = new byte[n12];
            for (int j = 0; j < n12; ++j) {
                byArray[j] = this.in.readByte();
            }
            object2 = byArray;
        } else if (clazz == Character.class) {
            object2 = Character.valueOf(this.in.readChar());
        } else if (clazz == char[].class) {
            int n13 = this.in.readIntULEB128();
            char[] cArray = new char[n13];
            for (int j = 0; j < n13; ++j) {
                cArray[j] = this.in.readChar();
            }
            object2 = cArray;
        } else if (clazz == Short.class) {
            object2 = this.in.readShort();
        } else if (clazz == short[].class) {
            int n14 = this.in.readIntULEB128();
            short[] sArray = new short[n14];
            for (int j = 0; j < n14; ++j) {
                sArray[j] = this.in.readShort();
            }
            object2 = sArray;
        } else if (clazz == Integer.class) {
            object2 = this.in.readIntULEB128();
        } else if (clazz == int[].class) {
            int n15 = this.in.readIntULEB128();
            int[] nArray = new int[n15];
            for (int j = 0; j < n15; ++j) {
                nArray[j] = this.in.readIntULEB128();
            }
            object2 = nArray;
        } else if (clazz == Long.class) {
            object2 = this.in.readLongULEB128();
        } else if (clazz == long[].class) {
            int n16 = this.in.readIntULEB128();
            long[] lArray = new long[n16];
            for (int j = 0; j < n16; ++j) {
                lArray[j] = this.in.readLongULEB128();
            }
            object2 = lArray;
        } else if (clazz == Float.class) {
            object2 = Float.valueOf(this.in.readFloat());
        } else if (clazz == float[].class) {
            int n17 = this.in.readIntULEB128();
            float[] fArray = new float[n17];
            for (int j = 0; j < n17; ++j) {
                fArray[j] = this.in.readFloat();
            }
            object2 = fArray;
        } else if (clazz == Double.class) {
            object2 = this.in.readDouble();
        } else if (clazz == double[].class) {
            int n18 = this.in.readIntULEB128();
            double[] dArray = new double[n18];
            for (int j = 0; j < n18; ++j) {
                dArray[j] = this.in.readDouble();
            }
            object2 = dArray;
        } else if (clazz == String.class) {
            if (this.stringpool != null) {
                int n19 = this.in.readIntULEB128();
                object2 = this.stringpool.get(n19);
            } else {
                int n20 = this.in.readIntULEB128();
                byte[] byArray = new byte[n20];
                this.in.readFully(byArray);
                object2 = Strings.decodeUTF8(byArray);
            }
        } else if (clazz == BigInteger.class) {
            int n21 = this.in.readIntULEB128();
            byte[] byArray = new byte[n21];
            this.in.readFully(byArray);
            object2 = new BigInteger(byArray);
        } else if (clazz == BigDecimal.class) {
            int n22 = this.in.readIntULEB128();
            byte[] byArray = new byte[n22];
            this.in.readFully(byArray);
            object2 = new BigDecimal(Strings.decodeUTF8(byArray));
        } else if (clazz == AtomicBoolean.class) {
            object2 = new AtomicBoolean(this.in.readByte() != 0);
        } else if (clazz == AtomicInteger.class) {
            object2 = new AtomicInteger(this.in.readIntULEB128());
        } else if (clazz == AtomicLong.class) {
            object2 = new AtomicLong(this.in.readLongULEB128());
        } else if (clazz == SoftReference.class) {
            if (!bl2) {
                throw new RuntimeException("Unexpected non-lead SoftReference object");
            }
            object2 = new SoftReference<Object>(this.read());
        } else if (clazz == WeakReference.class) {
            if (!bl2) {
                throw new RuntimeException("Unexpected non-lead WeakReference object");
            }
            object2 = new WeakReference<Object>(this.read());
        } else if (Collection.class.isAssignableFrom(clazz) && (clazz == ArrayList.class || clazz == LinkedList.class || clazz == ArrayDeque.class || clazz == HashSet.class || clazz == TreeSet.class || clazz == LinkedHashSet.class || clazz == CopyOnWriteArrayList.class || clazz == CopyOnWriteArraySet.class || clazz == ConcurrentSkipListSet.class)) {
            void var12_70;
            int n23 = this.in.readIntULEB128();
            if (bl2) {
                if (clazz == ArrayList.class) {
                    ArrayList arrayList = new ArrayList(n23);
                } else if (clazz == LinkedList.class) {
                    LinkedList linkedList = new LinkedList();
                } else if (clazz == ArrayDeque.class) {
                    ArrayDeque arrayDeque = new ArrayDeque(n23);
                } else if (clazz == HashSet.class) {
                    HashSet hashSet = new HashSet(n23);
                } else if (clazz == TreeSet.class) {
                    TreeSet treeSet = new TreeSet();
                } else if (clazz == LinkedHashSet.class) {
                    LinkedHashSet linkedHashSet = new LinkedHashSet();
                } else if (clazz == CopyOnWriteArrayList.class) {
                    CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
                } else if (clazz == CopyOnWriteArraySet.class) {
                    CopyOnWriteArraySet copyOnWriteArraySet = new CopyOnWriteArraySet();
                } else {
                    if (clazz != ConcurrentSkipListSet.class) throw new SerializationException("Unsupported collection type", clazz);
                    ConcurrentSkipListSet concurrentSkipListSet = new ConcurrentSkipListSet();
                }
            } else {
                Collection collection = (Collection)object2;
            }
            this.registerObject(bl2, n3, var12_70);
            PreCollection preCollection = new PreCollection((Collection<Object>)var12_70, n23);
            for (int j = 0; j < n23; ++j) {
                Object object5 = this.read();
                preCollection.record(object5);
            }
            this.deferredObjects.add(preCollection);
            object2 = var12_70;
        } else {
            void var12_78;
            if (!Map.class.isAssignableFrom(clazz) || clazz != HashMap.class && clazz != TreeMap.class && clazz != LinkedHashMap.class && clazz != IdentityHashMap.class && clazz != ConcurrentHashMap.class && clazz != ConcurrentSkipListMap.class) throw new SerializationException("Unsupported type", clazz);
            int n24 = this.in.readIntULEB128();
            if (bl2) {
                if (clazz == HashMap.class) {
                    HashMap hashMap = new HashMap(n24);
                } else if (clazz == TreeMap.class) {
                    TreeMap treeMap = new TreeMap();
                } else if (clazz == LinkedHashMap.class) {
                    LinkedHashMap linkedHashMap = new LinkedHashMap(n24);
                } else if (clazz == IdentityHashMap.class) {
                    IdentityHashMap identityHashMap = new IdentityHashMap(n24);
                } else if (clazz == ConcurrentHashMap.class) {
                    ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(n24);
                } else {
                    if (clazz != ConcurrentSkipListMap.class) throw new SerializationException("Unsupported map type", clazz);
                    ConcurrentSkipListMap concurrentSkipListMap = new ConcurrentSkipListMap();
                }
            } else {
                Map map = (Map)object2;
            }
            this.registerObject(bl2, n3, var12_78);
            PreMap preMap = new PreMap((Map<Object, Object>)var12_78, n24);
            for (int j = 0; j < n24; ++j) {
                Object object6 = this.read();
                Object object7 = this.read();
                preMap.record(object6, object7);
            }
            this.deferredObjects.add(preMap);
            object2 = var12_78;
        }
        this.registerObject(bl2, n3, object2);
        return object2;
    }

    @Override
    public void restoreFields(Object object, Class<?> clazz) throws IOException {
        int n;
        while ((n = this.in.readIntULEB128()) != 0) {
            Object object2 = this.read();
            this.restoreFieldValue(object, clazz, n, object2);
        }
    }
}

