/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization;

import com.pnfsoftware.jeb.util.base.IProgressCallback;
import com.pnfsoftware.jeb.util.collect.MultiMap;
import com.pnfsoftware.jeb.util.io.LEDataInputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.reflect.ReflectionHelper;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.IDeserializationEventHandler;
import com.pnfsoftware.jeb.util.serialization.IInternalDeserializer;
import com.pnfsoftware.jeb.util.serialization.IPreObject;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.NativeTypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomRead;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.objenesis.ObjenesisStd;

public abstract class AbstractInternalDeserializer
implements IInternalDeserializer {
    private static final ILogger logger = GlobalLog.getLogger(AbstractInternalDeserializer.class);
    protected LEDataInputStream in;
    protected ITypeIdProvider nativeTypeIdProvider;
    protected ITypeIdProvider customTypeIdProvider;
    protected List<ClassLoader> classloaders;
    protected ObjenesisStd objenesis;
    protected boolean cancelled;
    protected Map<Class<?>, Object> constructorMap = new HashMap();
    protected Object mootObject = new Object();
    protected Map<Integer, Object> objmap = new TreeMap<Integer, Object>();
    protected Set<Integer> objIdPostgraphDone = new HashSet<Integer>();
    protected List<IPreObject> deferredObjects = new ArrayList<IPreObject>();
    private static final int thresholdDepthWarning = 150;
    private int depth;
    private int maxDepthReached;
    private static Map<Class<?>, Map<Integer, Field>> fieldCache = new HashMap();
    protected static Map<Class<?>, CustomMethods> customMethods = new HashMap();
    protected int expectedObjectCount;
    protected List<IProgressCallback> progressCallbacks = new ArrayList<IProgressCallback>();
    protected MultiMap<Class<?>, IDeserializationEventHandler> objectCreatedHookMap = new MultiMap();

    protected AbstractInternalDeserializer(ITypeIdProvider iTypeIdProvider, List<ClassLoader> list, LEDataInputStream lEDataInputStream) {
        this.in = lEDataInputStream;
        this.nativeTypeIdProvider = NativeTypeIdProvider.getInstance();
        this.customTypeIdProvider = iTypeIdProvider;
        this.classloaders = list;
        this.objenesis = new ObjenesisStd();
    }

    @Override
    public int getObjectCount() {
        return this.objmap.size();
    }

    @Override
    public Collection<Object> getObjects() {
        return this.objmap.values();
    }

    @Override
    public InputStream getStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return AbstractInternalDeserializer.this.in.readByte();
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                return AbstractInternalDeserializer.this.in.read(byArray);
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                return AbstractInternalDeserializer.this.in.read(byArray, n, n2);
            }
        };
    }

    @Override
    public Object deserializeInternal() throws IOException {
        Object object = null;
        try {
            object = this.read(null, null);
        }
        finally {
            this.resolveDeferredObjects();
        }
        for (Map.Entry<Integer, Object> entry : this.objmap.entrySet()) {
            if (!this.objIdPostgraphDone.add(entry.getKey())) continue;
            CustomMethods customMethods = this.getCustomMethods(entry.getValue(), null);
            if (customMethods.mCustomInitPostGraph == null) continue;
            try {
                ReflectionHelper.invoke2(customMethods.mCustomInitPostGraph, entry.getValue(), new Object[0]);
            }
            catch (Exception exception) {
                throw new SerializationException("Post-graph initializer failed", exception, null);
            }
        }
        if (this.cancelled) {
            throw new SerializationException("The deserialization process was cancelled");
        }
        this.notifyProgressCallbacks();
        return object;
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    @Override
    public Object read() throws IOException {
        return this.read(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(Object object, Class<?> clazz) throws IOException {
        Object object2;
        block11: {
            block9: {
                Object var3_4;
                block10: {
                    block7: {
                        Object var3_3;
                        block8: {
                            ++this.depth;
                            try {
                                if (this.depth > this.maxDepthReached) {
                                    this.maxDepthReached = this.depth;
                                    if (this.depth > 150) {
                                        logger.debug("Deserialization depth: %d: read() o=%s c=%s", this.depth, object == null ? "null" : object.getClass(), clazz);
                                    }
                                }
                                if (!this.cancelled) break block7;
                                var3_3 = null;
                                --this.depth;
                                if (this.depth != 0 || this.depth <= 150) break block8;
                            }
                            catch (Throwable throwable) {
                                --this.depth;
                                if (this.depth == 0 && this.depth > 150) {
                                    logger.debug("Maximum depth reached during deserialization: %d", this.maxDepthReached);
                                }
                                throw throwable;
                            }
                            logger.debug("Maximum depth reached during deserialization: %d", this.maxDepthReached);
                        }
                        return var3_3;
                    }
                    if (!Thread.interrupted()) break block9;
                    this.cancelled = true;
                    var3_4 = null;
                    --this.depth;
                    if (this.depth != 0 || this.depth <= 150) break block10;
                    logger.debug("Maximum depth reached during deserialization: %d", this.maxDepthReached);
                }
                return var3_4;
            }
            object2 = this.readInternal(object, clazz);
            --this.depth;
            if (this.depth != 0 || this.depth <= 150) break block11;
            logger.debug("Maximum depth reached during deserialization: %d", this.maxDepthReached);
        }
        return object2;
    }

    protected abstract Object readInternal(Object var1, Class<?> var2) throws IOException;

    protected void registerObject(boolean bl2, int n, Object object) {
        Object object2;
        if (bl2 && (object2 = this.objmap.put(n, object)) != object && !this.objmap.isEmpty() && this.objmap.size() % 1000000 == 0) {
            logger.debug("Deserializing... status: %d unique objects", this.objmap.size());
            this.notifyProgressCallbacks();
        }
    }

    protected Class<?> loadClass(String string) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.classloaders) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return ClassLoader.getSystemClassLoader().loadClass(string);
    }

    protected void restoreFieldValue(Object object, Class<?> clazz, int n, Object object2) throws SerializationException {
        int n2;
        Field[] fieldArray;
        Class<?> clazz2 = clazz == null ? object.getClass() : clazz;
        Map<Integer, Field> map = fieldCache.get(clazz2);
        if (map == null) {
            map = new HashMap<Integer, Field>();
            fieldCache.put(clazz2, map);
            fieldArray = clazz2.getDeclaredFields();
            n2 = fieldArray.length;
            for (int j = 0; j < n2; ++j) {
                Field field = fieldArray[j];
                SerId serId = field.getAnnotation(SerId.class);
                if (serId == null) continue;
                map.put(serId.value(), field);
            }
        }
        if ((fieldArray = map.get(n)) != null) {
            n2 = fieldArray.isAccessible();
            if (n2 == 0) {
                fieldArray.setAccessible(true);
            }
            try {
                fieldArray.set(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SerializationException(illegalAccessException, clazz2);
            }
            if (n2 == 0) {
                fieldArray.setAccessible(false);
            }
        }
    }

    protected CustomMethods getCustomMethods(Object object, Class<?> clazz) throws SerializationException {
        Class<?> clazz2 = clazz == null ? object.getClass() : clazz;
        CustomMethods customMethods = AbstractInternalDeserializer.customMethods.get(clazz2);
        if (customMethods == null) {
            customMethods = new CustomMethods();
            int n = 0;
            for (Method method : clazz2.getDeclaredMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    Class<? extends Annotation> clazz3 = annotation.annotationType();
                    if ((n & 1) == 0 && clazz3 == SerCustomRead.class) {
                        if (!this.isValidMethodCustomRead(method)) {
                            throw new SerializationException("Invalid prototype for custom reader method: " + method);
                        }
                        customMethods.mCustomRead = method;
                        n |= 1;
                        break;
                    }
                    if ((n & 2) == 0 && clazz3 == SerCustomInit.class) {
                        if (!this.isValidMethodCustomInit(method)) {
                            throw new SerializationException("Invalid prototype for custom initializer method: " + method);
                        }
                        customMethods.mCustomInit = method;
                        n |= 2;
                        break;
                    }
                    if ((n & 4) != 0 || clazz3 != SerCustomInitPostGraph.class) continue;
                    if (!this.isValidMethodCustomInit(method)) {
                        throw new SerializationException("Invalid prototype for custom post-graph initializer method: " + method);
                    }
                    customMethods.mCustomInitPostGraph = method;
                    n |= 4;
                    break;
                }
                if (n == 7) break;
            }
            AbstractInternalDeserializer.customMethods.put(clazz2, customMethods);
        }
        return customMethods;
    }

    private boolean isValidMethodCustomRead(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1 || classArray[0] != DeserializerHelper.class) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            return false;
        }
        return (method.getModifiers() & 2) != 0;
    }

    private boolean isValidMethodCustomInit(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 0) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            return false;
        }
        return (method.getModifiers() & 2) != 0;
    }

    protected void resolveDeferredObjects() {
        for (IPreObject iPreObject : this.deferredObjects) {
            iPreObject.build();
        }
        this.deferredObjects.clear();
    }

    @Override
    public void setExpectedObjectCount(int n) {
        this.expectedObjectCount = n;
    }

    @Override
    public void addProgressCallback(IProgressCallback iProgressCallback) {
        this.progressCallbacks.add(iProgressCallback);
    }

    @Override
    public void removeProgressCallback(IProgressCallback iProgressCallback) {
        this.progressCallbacks.remove(iProgressCallback);
    }

    protected void notifyProgressCallbacks() {
        for (IProgressCallback iProgressCallback : this.progressCallbacks) {
            iProgressCallback.progress(this.getObjectCount(), this.expectedObjectCount);
        }
    }

    @Override
    public void addObjectCreatedHook(Class<?> clazz, IDeserializationEventHandler iDeserializationEventHandler) {
        if (clazz.isInterface() || clazz.isArray() || clazz.isPrimitive()) {
            throw new IllegalArgumentException(String.format("Illegal object type to be monitored: %s (must be a pure object: no interface, no array, no primitive)", clazz.getSimpleName()));
        }
        this.objectCreatedHookMap.put(clazz, iDeserializationEventHandler);
    }

    @Override
    public void removeObjectCreatedHook(Class<?> clazz, IDeserializationEventHandler iDeserializationEventHandler) {
        this.objectCreatedHookMap.removeValue(clazz, iDeserializationEventHandler);
    }

    protected void notifyDeserializationEvent(int n, Class<?> clazz, Object object) {
        if (n == 1) {
            for (IDeserializationEventHandler iDeserializationEventHandler : this.objectCreatedHookMap.getSafe(clazz)) {
                iDeserializationEventHandler.notifyObjectCreated(clazz, object);
            }
        }
    }

    protected void logObjectMap() {
        int n = 1;
        for (int n2 : this.objmap.keySet()) {
            Object object;
            if (n2 != n) {
                logger.trace("! GAP !", new Object[0]);
            }
            if ((object = this.objmap.get(n2)) == null) {
                logger.trace("%d -> null !!", n2);
            } else {
                logger.trace("%d -> %s (%Xh)", n2, object.getClass().getName(), object.hashCode());
            }
            n = n2 + 1;
        }
    }

    static class CustomMethods {
        Method mCustomRead;
        Method mCustomInit;
        Method mCustomInitPostGraph;

        CustomMethods() {
        }
    }
}

