/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.reflect;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionHelper {
    private static final ILogger logger = GlobalLog.getLogger(ReflectionHelper.class);

    public static boolean hasNoArgConstructor(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return constructor != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static Object newInstance2(Constructor<?> constructor) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean bl2 = constructor.isAccessible();
        if (!bl2) {
            constructor.setAccessible(true);
        }
        try {
            Object obj = constructor.newInstance(new Object[0]);
            return obj;
        }
        finally {
            if (!bl2) {
                constructor.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invoke2(Method method, Object object, Object ... objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean bl2 = method.isAccessible();
        if (!bl2) {
            method.setAccessible(true);
        }
        try {
            Object object2 = method.invoke(object, objectArray);
            return object2;
        }
        finally {
            if (!bl2) {
                method.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set2(Field field, Object object, Object object2) throws IllegalAccessException, IllegalArgumentException {
        boolean bl2 = field.isAccessible();
        if (!bl2) {
            field.setAccessible(true);
        }
        try {
            field.set(object, object2);
        }
        finally {
            if (!bl2) {
                field.setAccessible(false);
            }
        }
    }

    public static Class<?> removeDimensions(Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static Class<?> reduceDimensions(Class<?> clazz) {
        Class<?> clazz2;
        while (clazz.isArray() && !(clazz2 = clazz.getComponentType()).isPrimitive()) {
            clazz = clazz2;
        }
        return clazz;
    }

    public static <T> T instantiateSafe(Class<? extends T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            logger.catching(reflectiveOperationException);
            return null;
        }
    }
}

