/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.primitives;

import java.math.BigInteger;

public class Longs {
    private static BigInteger _2p64 = BigInteger.ONE.shiftLeft(64);

    public static long fromInts(int n, int n2) {
        return (long)n2 << 32 | (long)n & 0xFFFFFFFFL;
    }

    public static int[] toInts(long l2) {
        return new int[]{(int)l2, (int)(l2 >> 32)};
    }

    public static String toUnsignedString(long l2) {
        long l3 = (l2 >>> 1) / 5L;
        long l4 = l2 - l3 * 10L;
        return l3 != 0L ? Long.toString(l3) + l4 : Long.toString(l4);
    }

    public static BigInteger toUnsignedBigInteger(long l2) {
        BigInteger bigInteger = BigInteger.valueOf(l2);
        if (l2 < 0L) {
            bigInteger = bigInteger.add(_2p64);
        }
        return bigInteger;
    }

    public static int compareUnsigned(long l2, long l3) {
        return Long.compare(l2 + Long.MIN_VALUE, l3 + Long.MIN_VALUE);
    }

    public static long maxUnsigned(long l2, long l3) {
        return Longs.compareUnsigned(l2, l3) >= 0 ? l2 : l3;
    }

    public static long minUnsigned(long l2, long l3) {
        return Longs.compareUnsigned(l2, l3) <= 0 ? l2 : l3;
    }

    public static long divUnsigned(long l2, long l3) {
        long l4;
        if (l3 < 0L) {
            if (Longs.compareUnsigned(l2, l3) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (l2 >= 0L) {
            return l2 / l3;
        }
        long l5 = l2 - (l4 = (l2 >>> 1) / l3 << 1) * l3;
        return l4 + (long)(Longs.compareUnsigned(l5, l3) >= 0 ? 1 : 0);
    }

    public static long remUnsigned(long l2, long l3) {
        long l4;
        if (l3 < 0L) {
            if (Longs.compareUnsigned(l2, l3) < 0) {
                return l2;
            }
            return l2 - l3;
        }
        if (l2 >= 0L) {
            return l2 % l3;
        }
        long l5 = (l2 >>> 1) / l3 << 1;
        return l4 - (Longs.compareUnsigned(l4 = l2 - l5 * l3, l3) >= 0 ? l3 : 0L);
    }
}

