/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.math;

import java.util.Collection;

public class MathUtil {
    public static boolean almostEquals(double d2, double d3) {
        return Math.abs(d2 - d3) <= 1.0E-7;
    }

    public static boolean almostEquals(double d2, double d3, double d4) {
        return Math.abs(d2 - d3) <= d4;
    }

    public static long makeMask(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Bitsize must be >= 0: " + n);
        }
        if (n > 64) {
            throw new IllegalArgumentException("Bitsize must be <= 64: " + n);
        }
        return n == 64 ? -1L : (1L << n) - 1L;
    }

    public static long makeInverseMask(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Bitsize must be >= 0: " + n);
        }
        if (n > 64) {
            throw new IllegalArgumentException("Bitsize must be <= 64: " + n);
        }
        return n == 64 ? 0L : (1L << n) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long makeOverflow(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Bitsize must be >= 0: " + n);
        }
        if (n > 64) {
            throw new IllegalArgumentException("Bitsize must be <= 64: " + n);
        }
        return n == 64 ? 0L : 1L << n;
    }

    public static boolean betweenExclusive(long l2, long l3, long l4) {
        return l2 > l3 && l2 < l4;
    }

    public static boolean betweenInclusive(long l2, long l3, long l4) {
        return l2 >= l3 && l2 <= l4;
    }

    public static int minPositive(int ... nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n < 0) {
                n = Math.max(n2, n);
                continue;
            }
            if (n2 <= 0) continue;
            n = Math.min(n2, n);
        }
        return n;
    }

    private static long signExtend(long l2, int n, int n2) {
        if (n2 != 32 && n2 != 64) {
            throw new IllegalArgumentException("unsupported size for sign extension: " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("bitsize must be <= " + n2 + " (was " + n + ")");
        }
        if (n < n2) {
            long l3 = (1L << n) - 1L;
            l2 = (l2 & 1L << n - 1) != 0L ? (l2 |= l3 ^ 0xFFFFFFFFFFFFFFFFL) : (l2 &= l3);
        }
        return l2;
    }

    public static long signExtend32(long l2, int n) {
        return MathUtil.signExtend(l2, n, 32);
    }

    public static int signExtend32(int n, int n2) {
        return (int)MathUtil.signExtend(n, n2, 32);
    }

    public static long signExtend(long l2, int n) {
        return MathUtil.signExtend(l2, n, 64);
    }

    private static long zeroExtend(long l2, int n, int n2) {
        if (n2 != 32 && n2 != 64) {
            throw new IllegalArgumentException("unsupported size for zero extension: " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("bitsize must be <= " + n2 + " (was " + n + ")");
        }
        if (n < n2) {
            l2 &= (1L << n) - 1L;
        }
        return l2;
    }

    public static long zeroExtend32(long l2, int n) {
        return MathUtil.zeroExtend(l2, n, 32);
    }

    public static long zeroExtend(long l2, int n) {
        return MathUtil.zeroExtend(l2, n, 64);
    }

    public static int msb(long l2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Bitsize must be >= 0: " + n);
        }
        if (n > 64) {
            throw new IllegalArgumentException("Bitsize must be <= 64: " + n);
        }
        return (int)(l2 >>> n - 1 & 1L);
    }

    public static int pow(int n, int n2) {
        if (n2 == 0) {
            return 1;
        }
        if (n2 == 1) {
            return n;
        }
        if (n2 < 0) {
            if (n == 0) {
                throw new IllegalArgumentException("Can not compute 0 pow x");
            }
            if (n == 1) {
                return 1;
            }
            return 0;
        }
        int n3 = n;
        for (int j = 1; j < n2; ++j) {
            n3 *= n;
        }
        return n3;
    }

    public static long unmaskedShiftLeft(long l2, int n) {
        if (n >= 64) {
            return 0L;
        }
        return l2 << n;
    }

    public static long unmaskedShiftRight(long l2, int n) {
        if (n >= 64) {
            return 0L;
        }
        return l2 >>> n;
    }

    public static long unmaskedArithShiftRight(long l2, int n) {
        if (n >= 64) {
            return l2 < 0L ? -1L : 0L;
        }
        return l2 >> n;
    }

    public static int moduloPositive(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The divisor must be positive");
        }
        int n3 = n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        return n3;
    }

    public static double avg(Collection<? extends Number> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        int n = 1;
        for (Number number : collection) {
            d2 += (number.doubleValue() - d2) / (double)n;
            ++n;
        }
        return d2;
    }

    public static double avg(byte[] byArray) {
        if (byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        for (int j = 0; j < byArray.length; ++j) {
            d2 += ((double)byArray[j] - d2) / (double)(j + 1);
        }
        return d2;
    }

    public static double avg(char[] cArray) {
        if (cArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        for (int j = 0; j < cArray.length; ++j) {
            d2 += ((double)cArray[j] - d2) / (double)(j + 1);
        }
        return d2;
    }

    public static double avg(short[] sArray) {
        if (sArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        for (int j = 0; j < sArray.length; ++j) {
            d2 += ((double)sArray[j] - d2) / (double)(j + 1);
        }
        return d2;
    }

    public static double avg(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        for (int j = 0; j < nArray.length; ++j) {
            d2 += ((double)nArray[j] - d2) / (double)(j + 1);
        }
        return d2;
    }

    public static double avg(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        for (int j = 0; j < lArray.length; ++j) {
            d2 += ((double)lArray[j] - d2) / (double)(j + 1);
        }
        return d2;
    }

    public static double avg(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        for (int j = 0; j < fArray.length; ++j) {
            d2 += ((double)fArray[j] - d2) / (double)(j + 1);
        }
        return d2;
    }

    public static double avg(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        for (int j = 0; j < dArray.length; ++j) {
            d2 += (dArray[j] - d2) / (double)(j + 1);
        }
        return d2;
    }

    public static boolean isPowerOfTwo(int n) {
        return n > 0 && (n & n - 1) == 0;
    }

    public static boolean isPowerOfTwo(long l2) {
        return l2 > 0L && (l2 & l2 - 1L) == 0L;
    }
}

