/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.encoding.IntegerLEB128;
import com.pnfsoftware.jeb.util.encoding.LongLEB128;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class LEDataInputStream
extends FilterInputStream
implements DataInput {
    private final byte[] tmp = new byte[8];

    public LEDataInputStream(InputStream inputStream) {
        super(new DataInputStream(inputStream));
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.in.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return ((DataInputStream)this.in).readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return ((DataInputStream)this.in).readByte();
    }

    @Override
    public char readChar() throws IOException {
        ((DataInputStream)this.in).readFully(this.tmp, 0, 2);
        return (char)((this.tmp[1] & 0xFF) << 8 | this.tmp[0] & 0xFF);
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        ((DataInputStream)this.in).readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        ((DataInputStream)this.in).readFully(byArray, n, n2);
    }

    @Override
    public int readInt() throws IOException {
        ((DataInputStream)this.in).readFully(this.tmp, 0, 4);
        return this.tmp[3] << 24 | (this.tmp[2] & 0xFF) << 16 | (this.tmp[1] & 0xFF) << 8 | this.tmp[0] & 0xFF;
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return ((DataInputStream)this.in).readLine();
    }

    @Override
    public long readLong() throws IOException {
        ((DataInputStream)this.in).readFully(this.tmp, 0, 8);
        return (long)this.tmp[7] << 56 | (long)(this.tmp[6] & 0xFF) << 48 | (long)(this.tmp[5] & 0xFF) << 40 | (long)(this.tmp[4] & 0xFF) << 32 | (long)(this.tmp[3] & 0xFF) << 24 | (long)(this.tmp[2] & 0xFF) << 16 | (long)(this.tmp[1] & 0xFF) << 8 | (long)(this.tmp[0] & 0xFF);
    }

    @Override
    public short readShort() throws IOException {
        ((DataInputStream)this.in).readFully(this.tmp, 0, 2);
        return (short)((this.tmp[1] & 0xFF) << 8 | this.tmp[0] & 0xFF);
    }

    @Override
    public String readUTF() throws IOException {
        return ((DataInputStream)this.in).readUTF();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return ((DataInputStream)this.in).readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        ((DataInputStream)this.in).readFully(this.tmp, 0, 2);
        return (this.tmp[1] & 0xFF) << 8 | this.tmp[0] & 0xFF;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.in.skip(n);
    }

    public int readIntULEB128() throws IOException {
        return IntegerLEB128.readULEB128(this.in);
    }

    public long readLongULEB128() throws IOException {
        return LongLEB128.readULEB128(this.in);
    }
}

