/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import java.nio.ByteOrder;

public class EndianUtil {
    public static void swap(byte[] byArray, int n, int n2) {
        int n3 = n;
        for (int j = n + n2 - 1; n3 < j; ++n3, --j) {
            byte by2 = byArray[n3];
            byArray[n3] = byArray[j];
            byArray[j] = by2;
        }
    }

    public static void swap(byte[] byArray) {
        EndianUtil.swap(byArray, 0, byArray.length);
    }

    public static void swapByGroup(byte[] byArray, int n) {
        for (int j = 0; j < byArray.length; j += n) {
            for (int i2 = 0; i2 < n / 2; ++i2) {
                byte by2 = byArray[j + i2];
                byArray[j + i2] = byArray[j + (n - (i2 + 1))];
                byArray[j + (n - (i2 + 1))] = by2;
            }
        }
    }

    public static short swapShort(short s2) {
        return (short)((s2 & 0xFF) << 8 | s2 >> 8 & 0xFF);
    }

    public static int swapInt(int n) {
        return (n & 0xFF) << 24 | (n >> 8 & 0xFF) << 16 | (n >> 16 & 0xFF) << 8 | n >> 24 & 0xFF;
    }

    public static long swapLong(long l2) {
        return (l2 & 0xFFL) << 56 | (l2 >> 8 & 0xFFL) << 48 | (l2 >> 16 & 0xFFL) << 40 | (l2 >> 24 & 0xFFL) << 32 | (l2 >> 32 & 0xFFL) << 24 | (l2 >> 40 & 0xFFL) << 16 | (l2 >> 48 & 0xFFL) << 8 | l2 >> 56 & 0xFFL;
    }

    public static byte[] shortToLEBytes(short s2) {
        byte[] byArray = new byte[]{(byte)s2, (byte)(s2 >> 8)};
        return byArray;
    }

    public static void shortToLEBytes(short s2, byte[] byArray) {
        EndianUtil.shortToLEBytes(s2, byArray, 0);
    }

    public static void shortToLEBytes(short s2, byte[] byArray, int n) {
        byArray[n] = (byte)s2;
        byArray[n + 1] = (byte)(s2 >> 8);
    }

    public static byte[] intToLEBytes(int n) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        return byArray;
    }

    public static void intToLEBytes(int n, byte[] byArray) {
        EndianUtil.intToLEBytes(n, byArray, 0);
    }

    public static void intToLEBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >> 8);
        byArray[n2 + 2] = (byte)(n >> 16);
        byArray[n2 + 3] = (byte)(n >> 24);
    }

    public static byte[] longToLEBytes(long l2) {
        byte[] byArray = new byte[8];
        EndianUtil.longToLEBytes(l2, byArray);
        return byArray;
    }

    public static void longToLEBytes(long l2, byte[] byArray) {
        EndianUtil.longToLEBytes(l2, byArray, 0);
    }

    public static void longToLEBytes(long l2, byte[] byArray, int n) {
        byArray[n] = (byte)l2;
        byArray[n + 1] = (byte)(l2 >> 8);
        byArray[n + 2] = (byte)(l2 >> 16);
        byArray[n + 3] = (byte)(l2 >> 24);
        byArray[n + 4] = (byte)(l2 >> 32);
        byArray[n + 5] = (byte)(l2 >> 40);
        byArray[n + 6] = (byte)(l2 >> 48);
        byArray[n + 7] = (byte)(l2 >> 56);
    }

    public static byte[] shortToBEBytes(short s2) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)s2;
        byArray[0] = (byte)(s2 >> 8);
        return byArray;
    }

    public static void shortToBEBytes(short s2, byte[] byArray) {
        EndianUtil.shortToBEBytes(s2, byArray, 0);
    }

    public static void shortToBEBytes(short s2, byte[] byArray, int n) {
        byArray[n + 1] = (byte)s2;
        byArray[n] = (byte)(s2 >> 8);
    }

    public static byte[] intToBEBytes(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)n;
        byArray[2] = (byte)(n >> 8);
        byArray[1] = (byte)(n >> 16);
        byArray[0] = (byte)(n >> 24);
        return byArray;
    }

    public static void intToBEBytes(int n, byte[] byArray) {
        EndianUtil.intToBEBytes(n, byArray, 0);
    }

    public static void intToBEBytes(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)n;
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2] = (byte)(n >> 24);
    }

    public static byte[] longToBEBytes(long l2) {
        byte[] byArray = new byte[8];
        EndianUtil.longToBEBytes(l2, byArray, 0);
        return byArray;
    }

    public static void longToBEBytes(long l2, byte[] byArray) {
        EndianUtil.longToBEBytes(l2, byArray, 0);
    }

    public static void longToBEBytes(long l2, byte[] byArray, int n) {
        byArray[n + 7] = (byte)l2;
        byArray[n + 6] = (byte)(l2 >> 8);
        byArray[n + 5] = (byte)(l2 >> 16);
        byArray[n + 4] = (byte)(l2 >> 24);
        byArray[n + 3] = (byte)(l2 >> 32);
        byArray[n + 2] = (byte)(l2 >> 40);
        byArray[n + 1] = (byte)(l2 >> 48);
        byArray[n] = (byte)(l2 >> 56);
    }

    public static short littleEndianBytesToShort(byte[] byArray) {
        return EndianUtil.littleEndianBytesToShort(byArray, 0);
    }

    public static short littleEndianBytesToShort(byte[] byArray, int n) {
        return (short)(byArray[n] & 0xFF | byArray[n + 1] << 8 & 0xFF00);
    }

    public static int littleEndianBytesToInt(byte[] byArray) {
        return EndianUtil.littleEndianBytesToInt(byArray, 0);
    }

    public static int littleEndianBytesToInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | byArray[n + 1] << 8 & 0xFF00 | byArray[n + 2] << 16 & 0xFF0000 | byArray[n + 3] << 24 & 0xFF000000;
    }

    public static long littleEndianBytesToLong(byte[] byArray) {
        long l2 = EndianUtil.littleEndianBytesToLong(byArray, 0);
        return l2;
    }

    public static long littleEndianBytesToLong(byte[] byArray, int n) {
        return (long)byArray[n] & 0xFFL | (long)byArray[n + 1] << 8 & 0xFF00L | (long)byArray[n + 2] << 16 & 0xFF0000L | (long)byArray[n + 3] << 24 & 0xFF000000L | (long)byArray[n + 4] << 32 & 0xFF00000000L | (long)byArray[n + 5] << 40 & 0xFF0000000000L | (long)byArray[n + 6] << 48 & 0xFF000000000000L | (long)byArray[n + 7] << 56 & 0xFF00000000000000L;
    }

    public static short bigEndianBytesToShort(byte[] byArray) {
        return EndianUtil.bigEndianBytesToShort(byArray, 0);
    }

    public static short bigEndianBytesToShort(byte[] byArray, int n) {
        return (short)(byArray[n + 1] & 0xFF | byArray[n] << 8 & 0xFF00);
    }

    public static int bigEndianBytesToInt(byte[] byArray) {
        return EndianUtil.bigEndianBytesToInt(byArray, 0);
    }

    public static int bigEndianBytesToInt(byte[] byArray, int n) {
        return byArray[n + 3] & 0xFF | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n] << 24 & 0xFF000000;
    }

    public static long bigEndianBytesToLong(byte[] byArray) {
        return EndianUtil.bigEndianBytesToLong(byArray, 0);
    }

    public static long bigEndianBytesToLong(byte[] byArray, int n) {
        return (long)byArray[n + 7] & 0xFFL | (long)byArray[n + 6] << 8 & 0xFF00L | (long)byArray[n + 5] << 16 & 0xFF0000L | (long)byArray[n + 4] << 24 & 0xFF000000L | (long)byArray[n + 3] << 32 & 0xFF00000000L | (long)byArray[n + 2] << 40 & 0xFF0000000000L | (long)byArray[n + 1] << 48 & 0xFF000000000000L | (long)byArray[n] << 56 & 0xFF00000000000000L;
    }

    public static void numberToBytes(ByteOrder byteOrder, long l2, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        if (byArray.length >= 8) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                EndianUtil.longToLEBytes(l2, byArray);
            } else {
                EndianUtil.longToBEBytes(l2, byArray);
            }
        } else if (byArray.length >= 4) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                EndianUtil.intToLEBytes((int)l2, byArray);
            } else {
                EndianUtil.intToBEBytes((int)l2, byArray);
            }
        } else if (byArray.length >= 2) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                EndianUtil.shortToLEBytes((short)l2, byArray);
            } else {
                EndianUtil.shortToBEBytes((short)l2, byArray);
            }
        } else {
            byArray[0] = (byte)l2;
        }
    }

    public static long bytesToNumberSigned(ByteOrder byteOrder, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("bytesToNumber with invalied parameters: byte[] is null or empty");
        }
        if (byArray.length >= 8) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return EndianUtil.littleEndianBytesToLong(byArray, 0);
            }
            return EndianUtil.bigEndianBytesToLong(byArray, 0);
        }
        if (byArray.length >= 4) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return EndianUtil.littleEndianBytesToInt(byArray, 0);
            }
            return EndianUtil.bigEndianBytesToInt(byArray, 0);
        }
        if (byArray.length >= 2) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return EndianUtil.littleEndianBytesToShort(byArray, 0);
            }
            return EndianUtil.bigEndianBytesToShort(byArray, 0);
        }
        return byArray[0];
    }

    public static long bytesToNumberUnsigned(ByteOrder byteOrder, byte[] byArray) {
        long l2 = EndianUtil.bytesToNumberSigned(byteOrder, byArray);
        if (byArray.length >= 8) {
            return l2;
        }
        if (byArray.length >= 4) {
            return l2 & 0xFFFFFFFFFFFFFFFFL;
        }
        if (byArray.length >= 2) {
            return l2 & 0xFFFFL;
        }
        return l2 & 0xFFL;
    }

    public static short bytesToShort(byte[] byArray, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return EndianUtil.littleEndianBytesToShort(byArray, n);
        }
        return EndianUtil.bigEndianBytesToShort(byArray, n);
    }

    public static int bytesToInt(byte[] byArray, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return EndianUtil.littleEndianBytesToInt(byArray, n);
        }
        return EndianUtil.bigEndianBytesToInt(byArray, n);
    }

    public static long bytesToLong(byte[] byArray, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return EndianUtil.littleEndianBytesToLong(byArray, n);
        }
        return EndianUtil.bigEndianBytesToLong(byArray, n);
    }
}

