/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.format.AlphanumCharComparator;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.NumberComparator;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    public static final String LINESEP;
    static Charset csASCII;
    static Charset csUTF8;
    static Charset csUTF16;
    static Charset csUTF16LE;
    static Charset csUTF16BE;
    static Charset csUTF32LE;
    static Charset csUTF32BE;
    private static Set<Character> unicodeWhiteSpaces;
    private static final Random prng;

    public static boolean hasLength(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static String replaceNewLines(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Replacement string cannot be null");
        }
        if (string2.indexOf(13) >= 0 || string2.indexOf(10) >= 0) {
            throw new IllegalArgumentException("The replacement string cannot contain new-line characters");
        }
        if (string == null) {
            return null;
        }
        if (string.indexOf(13) < 0 && string.indexOf(10) < 0) {
            return string;
        }
        return string.replace("\r\n", string2).replace("\r", string2).replace("\n", string2);
    }

    public static String safe(Object object) {
        return object != null ? object.toString() : "";
    }

    public static String safe(Object object, String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return object != null ? object.toString() : string;
    }

    public static String safe2(Object object, String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            return string;
        }
        String string2 = object.toString();
        if (string2.isEmpty()) {
            return string;
        }
        return string2;
    }

    public static String joinList(Iterable<?> iterable) {
        return "[" + Strings.join(", ", iterable) + "]";
    }

    @Deprecated
    public static String join(String string, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Object object : objectArray) {
            if (n >= 1) {
                stringBuilder.append(string);
            }
            stringBuilder.append(object == null ? "null" : object.toString());
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String joinv(String string, Object ... objectArray) {
        return Strings.joinv(string, "null", objectArray);
    }

    public static String joinv(String string, String string2, Object ... objectArray) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Object object : objectArray) {
            if (n >= 1) {
                stringBuilder.append(string);
            }
            stringBuilder.append(object == null ? string2 : object.toString());
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String join(String string, Iterable<?> iterable) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Object obj : iterable) {
            if (n >= 1) {
                stringBuilder.append(string);
            }
            stringBuilder.append(obj == null ? "null" : obj.toString());
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String[] stringArray, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = n; j < n2; ++j) {
            if (j > n) {
                stringBuilder.append(string);
            }
            stringBuilder.append(stringArray[j]);
        }
        return stringBuilder.toString();
    }

    public static String[] splitLines(String string, boolean bl2) {
        return string.split("(\r\n|\r|\n)", bl2 ? 0 : -1);
    }

    public static String[] splitLines(String string) {
        return Strings.splitLines(string, false);
    }

    public static String[] splitall(String string, String string2) {
        return string.split(string2, -1);
    }

    public static String firstLine(String string) {
        int n = Strings.indexOf2(string, '\r', '\n');
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static int search(String string, int n, String string2, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n > string.length()) {
            return -1;
        }
        if (string2.isEmpty()) {
            return n;
        }
        Pattern pattern = null;
        if (bl2) {
            try {
                pattern = Pattern.compile(string2, bl3 ? 0 : 2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (pattern != null) {
            Matcher matcher = pattern.matcher(string);
            if (!bl4) {
                if (matcher.find(n)) {
                    return matcher.start();
                }
                return -1;
            }
            int n2 = -1;
            while (matcher.find()) {
                int n3 = matcher.start();
                if (n > 0 && n3 >= n) break;
                n2 = n3;
            }
            return n2;
        }
        if (!bl4 && n + string2.length() > string.length()) {
            return -1;
        }
        if (bl4 && string2.length() >= n) {
            return -1;
        }
        if (bl3 && !bl4) {
            return string.indexOf(string2, n);
        }
        if (!bl3) {
            string2 = string2.toLowerCase();
        }
        char c = string2.charAt(0);
        if (!bl4) {
            for (int j = n; j <= string.length() - string2.length(); ++j) {
                char c2 = Character.toLowerCase(string.charAt(j));
                if (c2 != c || !string2.regionMatches(true, 0, string, j, string2.length())) continue;
                return j;
            }
            return -1;
        }
        if (n + string2.length() > string.length()) {
            n = string.length() - string2.length();
        }
        --n;
        if (bl3) {
            for (int j = n; j >= 0; --j) {
                char c3 = string.charAt(j);
                if (c3 != c || !string2.regionMatches(false, 0, string, j, string2.length())) continue;
                return j;
            }
            return -1;
        }
        for (int j = n; j >= 0; --j) {
            char c4 = Character.toLowerCase(string.charAt(j));
            if (c4 != c || !string2.regionMatches(true, 0, string, j, string2.length())) continue;
            return j;
        }
        return -1;
    }

    public static boolean isContainedIn(String string, String ... stringArray) {
        if (string != null) {
            for (String string2 : stringArray) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(String string, String ... stringArray) {
        if (string != null) {
            for (String string2 : stringArray) {
                if (!string.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean startsWith(String string, String ... stringArray) {
        if (string != null) {
            for (String string2 : stringArray) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean endsWith(String string, String ... stringArray) {
        if (string != null) {
            for (String string2 : stringArray) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(String string, String string2) {
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    public static String toString(Object object) {
        return Strings.toString(object, "null");
    }

    public static String toString(Object object, String string) {
        return object == null ? string : object.toString();
    }

    public static String generate(char c, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < n; ++j) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String spaces(int n) {
        if (n <= 0) {
            return "";
        }
        switch (n) {
            case 1: {
                return " ";
            }
            case 2: {
                return "  ";
            }
            case 3: {
                return "   ";
            }
            case 4: {
                return "    ";
            }
            case 5: {
                return "     ";
            }
            case 6: {
                return "      ";
            }
            case 7: {
                return "       ";
            }
            case 8: {
                return "        ";
            }
            case 9: {
                return "         ";
            }
            case 10: {
                return "          ";
            }
        }
        StringBuilder stringBuilder = new StringBuilder("           ");
        for (int j = 0; j < n - 11; ++j) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public static boolean isBlank(String string) {
        if (string != null) {
            for (int j = 0; j < string.length(); ++j) {
                if (Character.isWhitespace(string.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isBlank(CharSequence charSequence) {
        if (charSequence != null) {
            for (int j = 0; j < charSequence.length(); ++j) {
                if (Character.isWhitespace(charSequence.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static int countNonBlankCharacters(CharSequence charSequence) {
        int n = 0;
        if (charSequence != null) {
            for (int j = 0; j < charSequence.length(); ++j) {
                if (Character.isWhitespace(charSequence.charAt(j))) continue;
                ++n;
            }
        }
        return n;
    }

    public static int indexOf(CharSequence charSequence, char c) {
        for (int j = 0; j < charSequence.length(); ++j) {
            if (charSequence.charAt(j) != c) continue;
            return j;
        }
        return -1;
    }

    public static int indexOf2(CharSequence charSequence, char c, char c2) {
        for (int j = 0; j < charSequence.length(); ++j) {
            char c3 = charSequence.charAt(j);
            if (c3 != c && c3 != c2) continue;
            return j;
        }
        return -1;
    }

    public static boolean hasBlank(CharSequence charSequence) {
        if (charSequence != null) {
            for (int j = 0; j < charSequence.length(); ++j) {
                if (!Character.isWhitespace(charSequence.charAt(j))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespace(char c) {
        return unicodeWhiteSpaces.contains(Character.valueOf(c));
    }

    public static String replaceWhitespaces(String string, char c) {
        int n;
        boolean bl2 = false;
        for (n = 0; n < string.length(); ++n) {
            char c2 = string.charAt(n);
            if (!Strings.isWhitespace(c2)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n < string.length()) {
            char c3 = string.charAt(n);
            if (Strings.isWhitespace(c3)) {
                stringBuilder.append(c);
            } else {
                stringBuilder.append(c3);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String trimWhitespaces(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length() && unicodeWhiteSpaces.contains(Character.valueOf(string.charAt(n))); ++n) {
            ++n2;
        }
        n = string.length();
        for (int j = n - 1; j >= n2 && unicodeWhiteSpaces.contains(Character.valueOf(string.charAt(j))); --j) {
            --n;
        }
        return string.substring(n2, n);
    }

    public static String trim(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length() && string.charAt(n) <= ' '; ++n) {
            ++n2;
        }
        n = string.length();
        for (int j = n - 1; j >= n2 && string.charAt(j) <= ' '; --j) {
            --n;
        }
        return string.substring(n2, n);
    }

    public static String ltrim(String string) {
        int n = 0;
        for (int j = 0; j < string.length() && string.charAt(j) <= ' '; ++j) {
            ++n;
        }
        return string.substring(n);
    }

    public static String rtrim(String string) {
        int n = string.length();
        for (int j = n - 1; j >= 0 && string.charAt(j) <= ' '; --j) {
            --n;
        }
        return string.substring(0, n);
    }

    public static String ltrim(String string, char c) {
        int n = 0;
        for (int j = 0; j < string.length() && string.charAt(j) == c; ++j) {
            ++n;
        }
        return string.substring(n);
    }

    public static String rtrim(String string, char c) {
        int n = string.length();
        for (int j = n - 1; j >= 0 && string.charAt(j) == c; --j) {
            --n;
        }
        return string.substring(0, n);
    }

    public static int getAsciiLength(byte[] byArray, int n) {
        byte by2;
        int n2;
        for (n2 = 0; n2 < n && ((by2 = byArray[n2]) >= 32 && by2 < 127 || by2 == 13 || by2 == 10 || by2 == 9); ++n2) {
        }
        return n2;
    }

    public static int getAsciiLength(byte[] byArray) {
        return Strings.getAsciiLength(byArray, byArray.length);
    }

    public static Charset determinePotentialEncoding(byte[] byArray, int n, int n2) {
        Charset charset = null;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        byte[] byArray2 = new byte[4];
        while (byteBuffer.remaining() >= 4) {
            int n3;
            byArray2[0] = byteBuffer.get();
            byArray2[1] = byteBuffer.get();
            byArray2[2] = byteBuffer.get();
            byArray2[3] = byteBuffer.get();
            if (!(byArray2[0] != 0 ? (byArray2[1] == 0 && byArray2[2] != 0 && byArray2[3] == 0 ? (charset = Strings.setCs(csUTF16LE, charset)) == null : (byArray2[1] == 0 && byArray2[2] == 0 && byArray2[3] == 0 ? (charset = Strings.setCs(csUTF32LE, charset)) == null : (byArray2[1] != 0 && byArray2[2] != 0 && byArray2[3] != 0 ? (byArray2[0] >= 32 && byArray2[0] <= 126 && byArray2[1] >= 32 && byArray2[1] <= 126 && byArray2[2] >= 32 && byArray2[2] <= 126 && byArray2[3] >= 32 && byArray2[3] <= 126 ? (charset = Strings.setCs(csASCII, charset)) == null : (n3 = EndianUtil.littleEndianBytesToInt(byArray2)) != -1 && (charset = Strings.setCs(csUTF8, charset)) == null) : (byArray2[0] == -1 && byArray2[1] == -2 && byArray2[2] != 0 && byArray2[3] == 0 ? (charset = Strings.setCs(csUTF16, charset)) == null : byArray2[0] == -2 && byArray2[1] == -1 && byArray2[2] == 0 && byArray2[3] != 0 && (charset = Strings.setCs(csUTF16, charset)) == null)))) : (byArray2[1] != 0 && byArray2[2] == 0 && byArray2[3] != 0 ? (charset = Strings.setCs(csUTF16BE, charset)) == null : byArray2[1] == 0 && byArray2[2] == 0 && byArray2[3] != 0 && (charset = Strings.setCs(csUTF32BE, charset)) == null))) continue;
            break;
        }
        return charset;
    }

    private static Charset setCs(Charset charset, Charset charset2) {
        if (charset2 == null || charset2 == charset) {
            return charset;
        }
        return null;
    }

    public static boolean isNumber(String string) {
        for (int j = 0; j < string.length(); ++j) {
            if (Character.isDigit(string.charAt(j))) continue;
            return false;
        }
        return true;
    }

    public static String f(String string, Object ... objectArray) {
        return String.format(Locale.US, string, objectArray);
    }

    public static String replaceLast(String string, String string2, String string3) {
        if (Strings.isBlank(string) || Strings.isBlank(string2)) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n >= 0) {
            return string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static String substring(String string, int n, int n2) {
        if (n < 0) {
            n += string.length();
        }
        if (n2 < 0) {
            n2 += string.length();
        }
        return string.substring(n, n2);
    }

    public static String truncate(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String truncateWithSuffix(String string, int n, String string2) {
        if (string2 == null) {
            string2 = "";
        } else if (string2.length() > n) {
            throw new IllegalArgumentException();
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n - string2.length()) + string2;
    }

    public static String indentBlock(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (String string3 : Strings.splitLines(string, true)) {
            if (n >= 1) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string2 + string3);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String indentBlock(String string) {
        return Strings.indentBlock(string, "    ");
    }

    public static String urlencodeUTF8(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String urldecodeUTF8(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String[] parseUrlParameters(String string, String ... stringArray) {
        String[] stringArray2 = string.split("&");
        if (stringArray2.length != stringArray.length) {
            return null;
        }
        String[] stringArray3 = new String[stringArray2.length];
        int n = 0;
        for (String string2 : stringArray) {
            String[] stringArray4 = stringArray2[n].split("=");
            if (stringArray4.length != 2 || !string2.equals(stringArray4[0])) {
                return null;
            }
            stringArray3[n] = stringArray4[1];
            ++n;
        }
        return stringArray3;
    }

    public static String parseUrlParameter(String string, String string2) {
        return Strings.parseUrlParameters(string, string2)[0];
    }

    public static String encodeArray(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Object object : objectArray) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Strings.urlencodeUTF8(object.toString()));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String[] decodeArray(String string) {
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            stringArray2[n] = Strings.urldecodeUTF8(string2);
            ++n;
        }
        return stringArray2;
    }

    public static String encodeList(List<?> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Object obj : list) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Strings.urlencodeUTF8(obj.toString()));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static List<String> decodeList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            for (String string2 : string.split(",")) {
                arrayList.add(Strings.urldecodeUTF8(string2));
            }
        }
        return arrayList;
    }

    public static String encodeMap(Map<?, ?> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Object obj : map.keySet()) {
            if (n > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(Strings.urlencodeUTF8(obj.toString()) + "=" + Strings.urlencodeUTF8(map.get(obj).toString()));
            ++n;
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> decodeMap(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (string != null) {
            for (String string2 : string.split("&")) {
                String[] stringArray = string2.split("=");
                if (stringArray.length != 2) continue;
                linkedHashMap.put(Strings.urldecodeUTF8(stringArray[0]), Strings.urldecodeUTF8(stringArray[1]));
            }
        }
        return linkedHashMap;
    }

    public static byte[] encodeUTF8(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes(Charset.defaultCharset());
        }
    }

    public static String decodeUTF8(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2, Charset.defaultCharset());
        }
    }

    public static String decodeUTF8(byte[] byArray) {
        return Strings.decodeUTF8(byArray, 0, byArray.length);
    }

    public static byte[] encodeASCII(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes(Charset.defaultCharset());
        }
    }

    public static String decodeASCII(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2, Charset.defaultCharset());
        }
    }

    public static String decodeASCII(byte[] byArray) {
        return Strings.decodeASCII(byArray, 0, byArray.length);
    }

    public static byte[] encodeLocal(String string) {
        return string.getBytes(Charset.defaultCharset());
    }

    public static String decodeLocal(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, Charset.defaultCharset());
    }

    public static String decodeLocal(byte[] byArray) {
        return Strings.decodeLocal(byArray, 0, byArray.length);
    }

    public static Comparator<String> getDefaultComparator() {
        return new NumberComparator(new AlphanumCharComparator(true));
    }

    public static void makeNewLine(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n == 0) {
            return;
        }
        char c = stringBuilder.charAt(n - 1);
        if (c == '\r' || c == '\n') {
            return;
        }
        stringBuilder.append(LINESEP);
    }

    public static String randomUniqueId() {
        byte[] byArray = (prng.nextLong() + "-thxeg73z5tdhgs9c920klaph-" + System.nanoTime()).getBytes(csASCII);
        return Formatter.byteArrayToHexString(Hash.calculateSHA256(byArray), 0, 16).toLowerCase();
    }

    public static CharSequence pad(char c, int n) {
        if (n <= 0) {
            return "";
        }
        if (n == 1) {
            return String.valueOf(c);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < n; ++j) {
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    public static String camelCaseToString(String string, boolean bl2, boolean bl3) throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl4 = false;
        boolean bl5 = false;
        for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            if (j == 0 && !Character.isUpperCase(c) || Character.isWhitespace(c)) {
                throw new ParseException("Not a legal camel-case string", j);
            }
            if (Character.isUpperCase(c)) {
                if (j > 0 && !bl5) {
                    stringBuilder.append(' ');
                }
                boolean bl6 = false;
                if (bl3) {
                    if (bl5) {
                        if (j + 1 < string.length() && Character.isUpperCase(string.charAt(j + 1)) && (j + 2 == string.length() || Character.isUpperCase(string.charAt(j + 2)))) {
                            bl6 = true;
                        }
                    } else if (j + 1 < string.length() && Character.isUpperCase(string.charAt(j + 1)) && (j + 2 == string.length() || Character.isUpperCase(string.charAt(j + 2)))) {
                        bl5 = true;
                        bl6 = true;
                    }
                }
                stringBuilder.append(j == 0 || bl5 ? c : Character.toLowerCase(c));
                bl4 = false;
                bl5 = bl6;
                continue;
            }
            if (j > 0 && bl2 && Character.isDigit(c) && !bl4) {
                stringBuilder.append(' ');
                stringBuilder.append(c);
                bl4 = true;
                bl5 = false;
                continue;
            }
            stringBuilder.append(c);
            bl5 = false;
        }
        return stringBuilder.toString();
    }

    public static String camelCaseToString(String string) throws ParseException {
        return Strings.camelCaseToString(string, false, false);
    }

    public static boolean hasRtl(CharSequence charSequence) {
        for (int j = 0; j < charSequence.length(); ++j) {
            char c = charSequence.charAt(j);
            byte by2 = Character.getDirectionality(c);
            if (by2 != 1 && by2 != 2) continue;
            return true;
        }
        return false;
    }

    static {
        String string = System.getProperty("line.separator");
        if (string == null && (string = String.format("%n", new Object[0])) == null) {
            throw new RuntimeException("Cannot determine line separator for this platform");
        }
        LINESEP = string;
        csASCII = Charset.forName("ASCII");
        csUTF8 = Charset.forName("UTF-8");
        csUTF16 = Charset.forName("UTF-16");
        csUTF16LE = Charset.forName("UTF-16LE");
        csUTF16BE = Charset.forName("UTF-16BE");
        csUTF32LE = Charset.forName("UTF-32LE");
        csUTF32BE = Charset.forName("UTF-32BE");
        unicodeWhiteSpaces = new HashSet<Character>();
        unicodeWhiteSpaces.add(Character.valueOf('\t'));
        unicodeWhiteSpaces.add(Character.valueOf('\n'));
        unicodeWhiteSpaces.add(Character.valueOf('\u000b'));
        unicodeWhiteSpaces.add(Character.valueOf('\f'));
        unicodeWhiteSpaces.add(Character.valueOf('\r'));
        unicodeWhiteSpaces.add(Character.valueOf(' '));
        unicodeWhiteSpaces.add(Character.valueOf('\u0085'));
        unicodeWhiteSpaces.add(Character.valueOf('\u00a0'));
        unicodeWhiteSpaces.add(Character.valueOf('\u1680'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2000'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2001'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2002'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2003'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2004'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2005'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2006'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2007'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2008'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2009'));
        unicodeWhiteSpaces.add(Character.valueOf('\u200a'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2028'));
        unicodeWhiteSpaces.add(Character.valueOf('\u2029'));
        unicodeWhiteSpaces.add(Character.valueOf('\u202f'));
        unicodeWhiteSpaces.add(Character.valueOf('\u205f'));
        unicodeWhiteSpaces.add(Character.valueOf('\u3000'));
        prng = new Random();
    }
}

