/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.primitives.Longs;

public class NumberFormatter {
    Base base;
    boolean signedNumber;
    NotationType notationType;

    public NumberFormatter() {
        this.base = Base.HEXADECIMAL;
        this.signedNumber = false;
        this.notationType = NotationType._h_suffix;
    }

    public NumberFormatter(NumberFormatter numberFormatter) {
        this.base = numberFormatter.base;
        this.signedNumber = numberFormatter.signedNumber;
        this.notationType = numberFormatter.notationType;
    }

    public Base getBase() {
        return this.base;
    }

    public void setBase(Base base) {
        if (base == null) {
            throw new IllegalArgumentException("Need a non-null base");
        }
        this.base = base;
    }

    public Base rotateBase() {
        Base base = this.getBase().nextBase();
        this.setBase(base);
        return base;
    }

    public void setSignedNumber(boolean bl2) {
        this.signedNumber = bl2;
    }

    public boolean isSignedNumber() {
        return this.signedNumber;
    }

    public void setNotationType(NotationType notationType) {
        if (notationType == null) {
            throw new IllegalArgumentException("Need a non-null notation type");
        }
        this.notationType = notationType;
    }

    public NotationType getNotationType() {
        return this.notationType;
    }

    public String format(int n, long l2) {
        return this.format(n, l2, this.base, this.signedNumber);
    }

    public String format(int n, long l2, Base base, boolean bl2) {
        long l3;
        if (base == null) {
            base = this.base;
        }
        switch (n) {
            case 8: {
                l3 = (long)((byte)l2) & 0xFFL;
                break;
            }
            case 16: {
                l3 = (long)((short)l2) & 0xFFFFL;
                break;
            }
            case 32: {
                l3 = (long)((int)l2) & 0xFFFFFFFFL;
                break;
            }
            default: {
                n = 64;
                l3 = l2;
            }
        }
        if (base.isStandard()) {
            boolean bl3 = false;
            if (bl2) {
                boolean bl4;
                boolean bl5 = bl4 = (l2 >> n - 1 & 1L) == 1L;
                if (bl4) {
                    switch (n) {
                        case 8: {
                            l3 = -(l3 | 0xFFFFFFFFFFFFFF00L);
                            break;
                        }
                        case 16: {
                            l3 = -(l3 | 0xFFFFFFFFFFFF0000L);
                            break;
                        }
                        case 32: {
                            l3 = -(l3 | 0xFFFFFFFF00000000L);
                            break;
                        }
                        default: {
                            l3 = -l3;
                        }
                    }
                    bl3 = true;
                }
            }
            switch (base) {
                case HEXADECIMAL: {
                    if (bl3) {
                        return "-" + this.notationType.prefix() + Long.toHexString(l3).toUpperCase() + this.notationType.suffix();
                    }
                    return this.notationType.prefix() + Long.toHexString(l3).toUpperCase() + this.notationType.suffix();
                }
                case OCTAL: {
                    if (bl3) {
                        return "-0" + Long.toOctalString(l3);
                    }
                    return "0" + Long.toOctalString(l3);
                }
                case DECIMAL: {
                    if (bl3) {
                        return "-" + Longs.toUnsignedString(l3);
                    }
                    return Longs.toUnsignedString(l3);
                }
            }
            throw new RuntimeException();
        }
        switch (base) {
            case BINARY: {
                String string = Long.toBinaryString(l2);
                if (string.length() > n) {
                    string = string.substring(string.length() - n, string.length());
                }
                return "b'" + string;
            }
            case ASCII: {
                if (l2 != 0L && n % 8 == 0) {
                    byte[] byArray = new byte[8];
                    int n2 = 8;
                    do {
                        byte by2 = (byte)l2;
                        byArray[--n2] = by2;
                    } while ((l2 >>>= 8) != 0L);
                    return "'" + Formatter.escapeBytes(byArray, n2, 8 - n2) + "'";
                }
                return Long.toString(l3);
            }
        }
        return Long.toString(l3);
    }

    public static enum NotationType {
        _h_suffix("", "h"),
        _0x_prefix("0x", ""),
        _none("", "");

        private final String prefix;
        private final String suffix;

        private NotationType(String string2, String string3) {
            this.prefix = string2;
            this.suffix = string3;
        }

        public String prefix() {
            return this.prefix;
        }

        public String suffix() {
            return this.suffix;
        }
    }

    public static enum Base {
        BINARY(false),
        OCTAL(true),
        DECIMAL(true),
        HEXADECIMAL(true),
        ASCII(false);

        private final boolean std;

        private Base(boolean bl2) {
            this.std = bl2;
        }

        public boolean isStandard() {
            return this.std;
        }

        public Base nextBase() {
            switch (this) {
                case BINARY: {
                    return OCTAL;
                }
                case OCTAL: {
                    return DECIMAL;
                }
                case DECIMAL: {
                    return HEXADECIMAL;
                }
                case HEXADECIMAL: {
                    return ASCII;
                }
                case ASCII: {
                    return BINARY;
                }
            }
            throw new RuntimeException();
        }
    }
}

