/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding;

import com.pnfsoftware.jeb.util.format.Strings;

public class Conversion {
    public static int toInt(Object object) {
        return Conversion.toInt(object, 0);
    }

    public static int toInt(Object object, int n) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return Conversion.stringToInt((String)object, n);
        }
        return n;
    }

    public static long toLong(Object object) {
        return Conversion.toLong(object, 0L);
    }

    public static long toLong(Object object, long l2) {
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            return Conversion.stringToLong((String)object, l2);
        }
        return l2;
    }

    private static long stringToLongUnsafe(String string, int n) throws NumberFormatException {
        if (string.startsWith("0x")) {
            return Long.parseLong(string.substring(2), 16);
        }
        if (string.endsWith("h")) {
            return Long.parseLong(string.substring(0, string.length() - 1), 16);
        }
        if (string.length() >= 2 && string.startsWith("0")) {
            return Long.parseLong(string.substring(1), 8);
        }
        return Long.parseLong(string, n);
    }

    public static long stringToLong(String string, long l2, int n) {
        if (string == null) {
            return l2;
        }
        try {
            string = string.trim();
            return Conversion.stringToLongUnsafe(string, n);
        }
        catch (Exception exception) {
            try {
                if (Conversion.isNegativeHexLong(string)) {
                    String string2 = Conversion.getHexRaw(string);
                    long l3 = Long.parseLong(string2.substring(0, 1), 16);
                    return l3 << 60 | Long.parseLong(string2.substring(1), 16);
                }
                if (string.charAt(0) == '-') {
                    string = string.substring(1).trim();
                    return -1L * Conversion.stringToLongUnsafe(string, n);
                }
            }
            catch (Exception exception2) {
                return l2;
            }
            return l2;
        }
    }

    public static long stringToLong(String string, long l2) {
        return Conversion.stringToLong(string, l2, 10);
    }

    public static long stringToLong(String string) {
        return Conversion.stringToLong(string, 0L);
    }

    private static int stringToIntUnsafe(String string, int n) throws NumberFormatException {
        if (string.startsWith("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.endsWith("h")) {
            return Integer.parseInt(string.substring(0, string.length() - 1), 16);
        }
        if (string.length() >= 2 && string.startsWith("0")) {
            return Integer.parseInt(string.substring(1), 8);
        }
        return Integer.parseInt(string, n);
    }

    public static int stringToInt(String string, int n, int n2) {
        if (string == null) {
            return n;
        }
        string = string.trim();
        try {
            return Conversion.stringToIntUnsafe(string, n2);
        }
        catch (Exception exception) {
            try {
                if (Conversion.isNegativeHexInt(string)) {
                    String string2 = Conversion.getHexRaw(string);
                    int n3 = Integer.parseInt(string2.substring(0, 1), 16);
                    return n3 << 28 | Integer.parseInt(string2.substring(1), 16);
                }
                if (string.charAt(0) == '-') {
                    string = string.substring(1).trim();
                    return -1 * Conversion.stringToIntUnsafe(string, n2);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return n;
        }
    }

    public static int stringToInt(String string, int n) {
        return Conversion.stringToInt(string, n, 10);
    }

    public static int stringToInt(String string) {
        return Conversion.stringToInt(string, 0, 10);
    }

    private static boolean isNegativeHexLong(String string) {
        return Conversion.isNegativeHex(string, 16);
    }

    private static boolean isNegativeHexInt(String string) {
        return Conversion.isNegativeHex(string, 8);
    }

    private static boolean isNegativeHex(String string, int n) {
        String string2 = Conversion.getHexRaw(string);
        if (string2 == null || string2.length() == string.length() || Strings.isBlank(string2)) {
            return false;
        }
        return Conversion.isNegative(string2, n);
    }

    private static boolean isNegative(String string, int n) {
        string = string.toLowerCase();
        char c = string.charAt(0);
        return string.length() == n && (c == '8' || c == '9' || c >= 'a' && c <= 'f');
    }

    private static String getHexRaw(String string) {
        if ((string = string.toLowerCase()).startsWith("0x")) {
            string = string.substring(2);
        } else if (string.endsWith("h")) {
            string = string.substring(0, string.length() - 1);
        }
        for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            if (Character.isDigit(c) || c >= 'a' && c <= 'f') continue;
            return null;
        }
        return string;
    }

    public static int getHexPossibility(String string) {
        if (string.isEmpty()) {
            return 0;
        }
        int n = Integer.MAX_VALUE;
        for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            if (c >= '0' && c <= '9') {
                n = Math.min(1, n);
                continue;
            }
            if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                n = Math.min(2, n);
                continue;
            }
            return 0;
        }
        return n;
    }
}

