/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.concurrent.IMonitorInfoProvider;

public class ThreadUtil {
    public static Thread create(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    }

    public static Thread start(Runnable runnable) {
        return ThreadUtil.start(null, runnable);
    }

    public static Thread start(String string, Runnable runnable) {
        Thread thread = ThreadUtil.create(runnable);
        if (string != null) {
            thread.setName(string);
        }
        thread.start();
        return thread;
    }

    public static boolean stop(Thread thread) {
        if (thread == null) {
            return false;
        }
        if (!thread.isAlive()) {
            return true;
        }
        thread.interrupt();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !thread.isAlive();
    }

    public static boolean monitor(Thread thread, IMonitorInfoProvider iMonitorInfoProvider) {
        block7: {
            long l2;
            long l3;
            long l4 = System.currentTimeMillis();
            do {
                try {
                    l3 = iMonitorInfoProvider.getProbingPeriod();
                    if (l3 <= 0L) {
                        l3 = 100L;
                    }
                    thread.join(l3);
                }
                catch (InterruptedException interruptedException) {
                    break block7;
                }
                if (!thread.isAlive()) break block7;
            } while ((l3 = iMonitorInfoProvider.getTimeout()) <= 0L || (l2 = System.currentTimeMillis() - l4) < l3);
            iMonitorInfoProvider.onInterrupt();
            if (thread.isAlive()) {
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return !thread.isAlive();
    }
}

