/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.base.HtmlTypedContentProperties;
import com.pnfsoftware.jeb.util.base.ITypedContentProperties;
import com.pnfsoftware.jeb.util.format.Strings;
import java.nio.charset.Charset;

public class TypedContent {
    private byte[] bytes;
    private String mimeType;
    private String charsetName;
    private ITypedContentProperties properties;
    private String text;

    public static TypedContent html(String string, String string2) {
        return new TypedContent(string, "text/html", Strings.isBlank(string2) ? null : new HtmlTypedContentProperties(string2));
    }

    public static TypedContent html(String string) {
        return new TypedContent(string, "text/html");
    }

    public static TypedContent text(String string) {
        return new TypedContent(string, "text/plain");
    }

    public static TypedContent bytes(byte[] byArray) {
        return new TypedContent(byArray, "application/octet-stream");
    }

    public TypedContent(String string, String string2) {
        this(string, string2, null);
    }

    public TypedContent(String string, String string2, ITypedContentProperties iTypedContentProperties) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.text = string;
        this.mimeType = Strings.safe(string2, "text/plain");
        this.properties = iTypedContentProperties;
    }

    public TypedContent(byte[] byArray, String string) {
        this(byArray, string, null);
    }

    public TypedContent(byte[] byArray, String string, String string2) {
        this(byArray, string, string2, null);
    }

    public TypedContent(byte[] byArray, String string, String string2, ITypedContentProperties iTypedContentProperties) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.bytes = byArray;
        this.mimeType = Strings.safe(string, "application/octet-stream");
        this.charsetName = string2;
        this.properties = iTypedContentProperties;
    }

    public String getText() {
        if (this.text == null) {
            return new String(this.bytes, this.getCharset());
        }
        return this.text;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            return this.text.getBytes(this.getCharset());
        }
        return this.bytes;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    private Charset getCharset() {
        return this.charsetName == null ? Charset.defaultCharset() : Charset.forName(this.charsetName);
    }

    public ITypedContentProperties getProperties() {
        return this.properties;
    }

    public boolean isText() {
        return this.text != null;
    }

    public boolean isBinary() {
        return this.bytes != null;
    }
}

