/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import java.util.ArrayList;
import java.util.List;

public class CharSequenceList
implements CharSequence {
    private List<CharSequence> elts;
    private List<Integer> linePosition;

    public CharSequenceList(List<CharSequence> list) {
        this.elts = list;
        this.linePosition = new ArrayList<Integer>();
        int n = 0;
        for (int j = 0; j < list.size(); ++j) {
            this.linePosition.add(n);
            n += list.get(j).length() + 1;
        }
    }

    @Override
    public int length() {
        int n = this.linePosition.get(this.linePosition.size() - 1);
        return n + this.elts.get(this.elts.size() - 1).length() + 1;
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || n > this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = n;
        for (int j = 0; j < this.elts.size(); ++j) {
            if (n2 < this.elts.get(j).length()) {
                return this.elts.get(j).charAt(n2);
            }
            if (n2 == this.elts.get(j).length()) {
                return '\n';
            }
            n2 -= this.elts.get(j).length() + 1;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        int n3 = n;
        int n4 = n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < this.elts.size() && n4 >= 0; n4 -= this.elts.get(j).length() + 1, ++j) {
            if (n3 < 0) {
                if (n4 <= this.elts.get(j).length()) {
                    stringBuilder.append(this.elts.get(j).subSequence(0, n4));
                    break;
                }
                stringBuilder.append(this.elts.get(j).subSequence(0, this.elts.get(j).length())).append('\n');
            } else if (n3 < this.elts.get(j).length()) {
                if (n4 <= this.elts.get(j).length()) {
                    stringBuilder.append(this.elts.get(j).subSequence(n3, n4));
                    break;
                }
                stringBuilder.append(this.elts.get(j).subSequence(n3, this.elts.get(j).length())).append('\n');
            } else if (n3 == this.elts.get(j).length()) {
                stringBuilder.append('\n');
            }
            n3 -= this.elts.get(j).length() + 1;
        }
        return stringBuilder;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : this.elts) {
            stringBuilder.append(charSequence).append('\n');
        }
        return stringBuilder.toString();
    }

    public String toString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : this.elts) {
            stringBuilder.append(CharSequenceList.getLine(charSequence, n, n2)).append('\n');
        }
        return stringBuilder.toString();
    }

    public static CharSequence getLine(CharSequence charSequence, int n, int n2) {
        if (charSequence.length() > n) {
            return new StringBuilder(charSequence.subSequence(0, n - n2 - 5)).append("[...]").append(charSequence.subSequence(charSequence.length() - n2, charSequence.length()));
        }
        return charSequence;
    }
}

