/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.ihex;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.core.units.UnitNotification;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.codeobject.AbstractCodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.LoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SegmentInformation;
import com.pnfsoftware.jeb.corei.parsers.ihex.ej;
import com.pnfsoftware.jeb.corei.parsers.ihex.pX;
import com.pnfsoftware.jeb.util.collect.BytePipe;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@Ser
public class OI
extends AbstractCodeObjectUnit {
    private static final ILogger ae = GlobalLog.getLogger(OI.class);
    @SerId(value=1)
    ProcessorType eO;
    @SerId(value=2)
    byte[] Le;
    @SerId(value=3)
    int Qx;
    @SerId(value=4)
    Endianness lS;

    public OI(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(iInput, "ihex", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    public ProcessorType eO() {
        return this.eO;
    }

    public int Le() {
        return this.Qx;
    }

    @Override
    protected boolean processInternal() {
        block41: {
            String string = this.getPropertyManager().getString("Processor");
            this.eO = ProcessorType.fromArchName(string);
            this.lS = this.getPropertyManager().getBoolean("BigEndian") ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
            this.Qx = Conversion.stringToInt(this.getPropertyManager().getString("WantedWordsize"));
            long l2 = Conversion.stringToLong(this.getPropertyManager().getString("WantedImageBase"), -1L);
            if (this.eO != null && this.eO.isI386()) {
                this.lS = Endianness.LITTLE_ENDIAN;
            }
            try (InputStream inputStream = this.getInput().getStream();){
                byte[] byArray = IO.readInputStream(inputStream);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                pX pX2 = new pX(byteBuffer, true, true);
                BytePipe bytePipe = new BytePipe();
                long l3 = 0L;
                boolean bl2 = true;
                Long l4 = null;
                boolean bl3 = false;
                block21: while (pX2.eO()) {
                    ej ej2 = pX2.Le();
                    if (bl3) {
                        this.addNotification(new UnitNotification(NotificationType.CORRUPTION, "EOF record found, but more data follows"));
                        break;
                    }
                    switch (ej2.Le()) {
                        case 0: {
                            if (bl2) {
                                this.eO(bytePipe.available());
                                bl2 = false;
                                String string2 = String.format("seg%03d", this.getSegmentCount());
                                this.addSegment(new SegmentInformation(string2, bytePipe.available(), 0L, l3, 0L, 0));
                            }
                            bytePipe.append(ej2.Qx());
                            continue block21;
                        }
                        case 1: {
                            this.eO(bytePipe.available());
                            bl2 = false;
                            bl3 = true;
                            continue block21;
                        }
                        case 2: {
                            bl2 = true;
                            l3 = EndianUtil.bigEndianBytesToShort(ej2.Qx());
                            l3 <<= 4;
                            continue block21;
                        }
                        case 3: {
                            if (l4 != null) {
                                this.addNotification(new UnitNotification(NotificationType.WARNING, String.format("A start address was previously specified and was overwritten: %Xh", l4)));
                            }
                            long l5 = (long)EndianUtil.bigEndianBytesToShort(ej2.Qx()) & 0xFFFFL;
                            long l6 = (long)EndianUtil.bigEndianBytesToShort(ej2.Qx(), 2) & 0xFFFFL;
                            l4 = l5 * 16L + l6;
                            continue block21;
                        }
                        case 4: {
                            bl2 = true;
                            l3 = EndianUtil.bigEndianBytesToShort(ej2.Qx());
                            l3 <<= 16;
                            continue block21;
                        }
                        case 5: {
                            if (l4 != null) {
                                this.addNotification(new UnitNotification(NotificationType.WARNING, String.format("A start address was previously specified and was overwritten: %Xh", l4)));
                            }
                            l4 = (long)EndianUtil.bigEndianBytesToInt(ej2.Qx()) & 0xFFFFFFFFL;
                            continue block21;
                        }
                    }
                    this.addNotification(new UnitNotification(NotificationType.UNSUPPORTED_FEATURE, "Unknown record type: " + ej2.Le()));
                }
                this.Le = bytePipe.getAll();
                if (this.Qx == 0) {
                    int n = pX2.eO(0);
                    int n2 = pX2.eO(1);
                    int n3 = pX2.eO(2);
                    int n4 = pX2.eO(3);
                    int n5 = pX2.eO(4);
                    int n6 = pX2.eO(5);
                    if (n > 0 && n2 > 0) {
                        if (n3 == 0 && n4 == 0 && n5 == 0 && n6 == 0) {
                            this.Qx = 8;
                        } else if (n3 > 0 && n4 >= 0 && n5 == 0 && n6 == 0) {
                            this.Qx = 16;
                        } else if (n3 == 0 && n4 == 0 && n5 > 0 && n6 >= 0) {
                            this.Qx = 32;
                        }
                    }
                }
                int n = 0;
                LoaderInformation.Builder builder = new LoaderInformation.Builder();
                if (l4 != null) {
                    builder.setEntryPoint(l4);
                }
                builder.setWordSize(this.Qx);
                builder.setEndianness(this.lS);
                long l7 = this.Qx();
                if (l2 != -1L && l7 != l2) {
                    ae.warn("Image base was determined to be: 0x%X. It is overridden to be: 0x%X", l7, l2);
                    l7 = l2;
                }
                builder.setImageBase(l7);
                builder.setEntryPoint(0L);
                builder.setImageSize(this.lS() - l7);
                builder.setFlags(n);
                this.setLoaderInformation(builder.build());
                if (this.eO == null) {
                    this.logWarn(true, "The processor type was undetermined/not provided! Code of this ihex file will not be parsed.", new Object[0]);
                    break block41;
                }
                try {
                    IUnit iUnit;
                    String string3 = this.eO.toWellKnownUnitType();
                    if (string3 != null && (iUnit = this.getUnitProcessor().process(string3 + " image", this.getInput(), this, string3, true)) != null) {
                        this.addChildUnit(iUnit);
                    }
                }
                catch (Exception exception) {
                    ae.catching(exception);
                    this.addNotification(new UnitNotification(NotificationType.UNSUPPORTED_FEATURE, "The machine code was not disassembled"));
                }
            }
            catch (IOException iOException) {
                ae.catching(iOException);
                return false;
            }
        }
        return true;
    }

    private long Qx() {
        long l2 = 0L;
        for (ISegmentInformation iSegmentInformation : this.getSegments()) {
            if (l2 <= iSegmentInformation.getOffsetInMemory()) continue;
            l2 = iSegmentInformation.getOffsetInMemory();
        }
        return l2;
    }

    private long lS() {
        long l2 = 0L;
        for (ISegmentInformation iSegmentInformation : this.getSegments()) {
            if (l2 >= iSegmentInformation.getOffsetInMemory() + iSegmentInformation.getSizeInMemory()) continue;
            l2 = iSegmentInformation.getOffsetInMemory() + iSegmentInformation.getSizeInMemory();
        }
        return l2;
    }

    private void eO(int n) {
        if (this.getSegmentCount() >= 1) {
            SegmentInformation segmentInformation = (SegmentInformation)this.getSegment(this.getSegmentCount() - 1);
            long l2 = (long)n - segmentInformation.getOffsetInFile();
            segmentInformation.setSizeInFile(l2);
            segmentInformation.setSizeInMemory(l2);
        }
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder(super.getDescription());
        if (this.Qx == 8) {
            stringBuilder.append("\nI8HEX");
        } else if (this.Qx == 16) {
            stringBuilder.append("\nI16HEX");
        } else if (this.Qx == 32) {
            stringBuilder.append("\nI32HEX");
        }
        return stringBuilder.toString();
    }

    @Override
    protected IInput getMappableInput() {
        return new BytesInput(this.Le);
    }

    @Override
    protected boolean shouldAllocateFullImage() {
        return false;
    }

    @Override
    protected boolean applyRelocations(IVirtualMemory iVirtualMemory, long l2) {
        return true;
    }
}

