/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.html;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.html.pX;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;

public class HtmlIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(HtmlIdentifier.class);
    public static final String TYPE = "html";
    static final boolean allowXml = true;

    public HtmlIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Generic HTML/XML reader", "HTML, non-strict XML reformatter and beautifyer based on Jsoup", "PNF Software", Version.create(0, 1, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        byte by2;
        if (iInput == null) {
            return false;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        int n = HtmlIdentifier.skipSpaces(byArray, 0);
        if (n >= byArray.length) {
            return false;
        }
        if ((by2 = byArray[n++]) != 60) {
            return false;
        }
        if (HtmlIdentifier.checkCI(byArray, n, 63, 120, 109, 108)) {
            return true;
        }
        if (HtmlIdentifier.checkCI(byArray, n, 104, 116, 109, 108)) {
            return true;
        }
        if (!HtmlIdentifier.checkCI(byArray, n, 33, 100, 111, 99, 116, 121, 112, 101)) {
            return false;
        }
        int n2 = HtmlIdentifier.skipSpaces(byArray, n += 8);
        if (n2 == n || n2 >= byArray.length) {
            return false;
        }
        return HtmlIdentifier.checkCI(byArray, n2, 104, 116, 109, 108);
    }

    static int skipSpaces(byte[] byArray, int n) {
        byte by2;
        while (n < byArray.length && ((by2 = byArray[n]) == 32 || by2 == 9 || by2 == 12 || by2 == 13 || by2 == 10)) {
            ++n;
        }
        return n;
    }

    static boolean checkCI(byte[] byArray, int n, int ... nArray) {
        if (n + nArray.length > byArray.length) {
            return false;
        }
        for (int n2 : nArray) {
            if ((byArray[n] | 0x20) != n2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        pX pX2 = new pX(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return pX2;
    }
}

