/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.ethereum;

import com.pnfsoftware.jeb.core.AbstractEnginesPlugin;
import com.pnfsoftware.jeb.core.Artifact;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IOptionDefinition;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.OptionDefinition;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class LC
extends AbstractEnginesPlugin {
    private static final ILogger eO = GlobalLog.getLogger(LC.class);
    private IEnginesContext Le;

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Etherscan Contract Fetcher", "Load and process EVM bytecode of contracts from one of the Ethereum networks supported by Etherscan", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public void load(IEnginesContext iEnginesContext) {
        this.Le = iEnginesContext;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private String eO(IEnginesContext iEnginesContext, String string) {
        try {
            return iEnginesContext.getPropertyManager().getString(".etherscan." + string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean eO(IEnginesContext iEnginesContext, String string, String string2) {
        try {
            iEnginesContext.getPropertyManager().setString(".etherscan." + string, string2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public List<? extends IOptionDefinition> getExecutionOptionDefinitions() {
        return Arrays.asList(new OptionDefinition(null, "Provide the contract address:"), new OptionDefinition("ContractAddress", this.eO(this.Le, "ContractAddress"), "Contract address"), new OptionDefinition("Network", this.eO(this.Le, "Network"), "Network (optional)"));
    }

    @Override
    public void execute(IEnginesContext iEnginesContext, Map<String, String> map) {
        String string = null;
        String string2 = null;
        if (map != null) {
            string = map.get("ContractAddress");
            string2 = map.get("Network");
        }
        if (Strings.isBlank(string)) {
            eO.error("Please provide a contract address", new Object[0]);
            return;
        }
        if (Strings.isBlank(string2)) {
            string2 = "mainnet";
        }
        this.eO(iEnginesContext, "ContractAddress", string);
        this.eO(iEnginesContext, "Network", string2);
        this.eO(string2, string);
    }

    private boolean eO(String string, String string2) {
        try {
            OI oI = this.Le(string, string2);
            if (oI == null) {
                eO.error("Cannot retrieve contract", new Object[0]);
                return false;
            }
            eO.info("Fetched contract: %s", oI);
            String string3 = String.format("Contract_%s_%s", oI.eO, oI.Le);
            File file = oI.eO(string3);
            IRuntimeProject iRuntimeProject = this.Le.loadProject(oI.eO);
            Artifact artifact = new Artifact(file.getName(), new FileInput(file));
            iRuntimeProject.processArtifact(artifact);
            return true;
        }
        catch (Exception exception) {
            eO.catching(exception);
            return false;
        }
    }

    private OI Le(String string, String string2) throws IOException {
        int n;
        byte[] byArray;
        string = string.trim().toLowerCase();
        if ((string2 = string2.trim().toLowerCase()).startsWith("0x")) {
            string2 = string2.substring(2);
        }
        if ((byArray = Formatter.hexStringToByteArray(string2)).length != 20) {
            return null;
        }
        string2 = "0x" + Formatter.byteArrayToHexString(byArray);
        String string3 = String.format("https://%setherscan.io/address/%s", string.equals("mainnet") ? "" : "." + string, string2);
        String string4 = this.Le.getNetworkUtility().query(string3);
        eO.debug(string4, new Object[0]);
        byte[] byArray2 = null;
        int n2 = string4.indexOf("<div id=\"dividcode\">");
        if (n2 >= 0 && (n2 = string4.indexOf("0x", n2)) >= 0 && (n = string4.indexOf("<", n2)) >= 0) {
            String string5 = string4.substring(n2 + 2, n);
            byArray2 = Formatter.hexStringToByteArray(string5);
        }
        if (byArray2 == null) {
            return null;
        }
        return new OI(string, string2, byArray2);
    }

    static class OI {
        String eO;
        String Le;
        byte[] Qx;

        public OI(String string, String string2, byte[] byArray) {
            this.eO = string;
            this.Le = string2;
            this.Qx = byArray;
        }

        public File eO(String string) throws IOException {
            File file = new File(IO.getTempFolder(), string + ".evm-bytecode");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("0x%s\n", Formatter.byteArrayToHexString(this.Qx)));
            stringBuilder.append(String.format(";contract: %s on %s\n", this.Le, this.eO));
            IO.writeFile(file, stringBuilder.toString());
            return file;
        }

        public String toString() {
            return String.format("%s:%s:bytecode_len=%d", this.eO, this.Le, this.Qx.length);
        }
    }
}

