/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.output.table.ICellCoordinates;
import com.pnfsoftware.jeb.core.output.table.ITableDocumentPart;
import com.pnfsoftware.jeb.core.output.table.ITableRow;
import com.pnfsoftware.jeb.core.output.table.impl.AbstractTableDocument;
import com.pnfsoftware.jeb.core.output.table.impl.Cell;
import com.pnfsoftware.jeb.core.output.table.impl.CellCoordinates;
import com.pnfsoftware.jeb.core.output.table.impl.TableDocumentPart;
import com.pnfsoftware.jeb.core.output.table.impl.TableRow;
import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.core.units.codeobject.IELFProgramEntry;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SerDisabled
public class Uk
extends AbstractTableDocument {
    private TableDocumentPart eO;

    public Uk(IELFUnit iELFUnit) {
        ArrayList<TableRow> arrayList = new ArrayList<TableRow>();
        for (IELFProgramEntry iELFProgramEntry : iELFUnit.getProgramEntries()) {
            ArrayList<Cell> arrayList2 = new ArrayList<Cell>();
            arrayList2.add(new Cell(ELF.getPTString(iELFProgramEntry.getSegmentType(), iELFUnit.getHeader().getMachine())));
            arrayList2.add(new Cell(String.format("%Xh", iELFProgramEntry.getVirtualSize())));
            arrayList2.add(new Cell(String.format("%Xh", iELFProgramEntry.getVirtualAddress())));
            arrayList2.add(new Cell(String.format("%Xh", iELFProgramEntry.getSize())));
            arrayList2.add(new Cell(String.format("%Xh", iELFProgramEntry.getOffset())));
            arrayList2.add(new Cell(String.format("%Xh", iELFProgramEntry.getFlags())));
            arrayList.add(new TableRow(arrayList2));
        }
        this.eO = new TableDocumentPart(0, arrayList);
    }

    @Override
    public int getRowCount() {
        return this.eO.getRows().size();
    }

    @Override
    public List<String> getColumnLabels() {
        return Arrays.asList("Type", "Memory Size", "Address", "File Size", "Offset", "Flags");
    }

    @Override
    public ITableDocumentPart getTablePart(int n, int n2) {
        return this.getTable();
    }

    @Override
    public ITableDocumentPart getTable() {
        return this.eO;
    }

    @Override
    public String coordinatesToAddress(ICellCoordinates iCellCoordinates) {
        if (iCellCoordinates == null) {
            return null;
        }
        ITableRow iTableRow = this.eO.getRows().get(iCellCoordinates.getRowIndex());
        return this.eO(iTableRow);
    }

    @Override
    public ICellCoordinates addressToCoordinates(String string) {
        if (string == null) {
            return null;
        }
        for (int j = 0; j < this.getRowCount(); ++j) {
            ITableRow iTableRow = this.eO.getRows().get(j);
            if (!string.equals(this.eO(iTableRow))) continue;
            return new CellCoordinates(j, 0);
        }
        return super.addressToCoordinates(string);
    }

    private String eO(ITableRow iTableRow) {
        return iTableRow.getCells().get(0).getLabel() + "@" + iTableRow.getCells().get(2).getLabel();
    }
}

