/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.core.units.codeobject.IELFSectionEntry;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;

@Ser
public class NS
implements IELFSectionEntry {
    private static final ILogger qo = GlobalLog.getLogger(NS.class);
    @SerId(value=1)
    int eO;
    @SerId(value=2)
    int Le;
    @SerId(value=3)
    long Qx;
    @SerId(value=4)
    long lS;
    @SerId(value=5)
    long ae;
    @SerId(value=6)
    long TI;
    @SerId(value=7)
    int vT;
    @SerId(value=8)
    int KQ;
    @SerId(value=9)
    long LZ;
    @SerId(value=10)
    long XV;
    @SerId(value=11)
    String lo = "";

    @Override
    public String getName() {
        return this.lo;
    }

    @Override
    public int getType() {
        return this.Le;
    }

    @Override
    public long getFlags() {
        return this.Qx;
    }

    @Override
    public long getAddress() {
        return this.lS;
    }

    @Override
    public long getOffset() {
        return this.ae;
    }

    @Override
    public long getSize() {
        return this.TI;
    }

    @Override
    public int getExtraInfo() {
        return this.KQ;
    }

    public static NS eO(ByteBuffer byteBuffer, boolean bl2) {
        NS nS = new NS();
        if (!bl2) {
            if (byteBuffer.remaining() < 40) {
                throw new RuntimeException();
            }
            nS.eO = byteBuffer.getInt();
            nS.Le = byteBuffer.getInt();
            nS.Qx = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            nS.lS = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            nS.ae = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            nS.TI = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            nS.vT = byteBuffer.getInt();
            nS.KQ = byteBuffer.getInt();
            nS.LZ = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            nS.XV = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        } else {
            if (byteBuffer.remaining() < 64) {
                throw new RuntimeException();
            }
            nS.eO = byteBuffer.getInt();
            nS.Le = byteBuffer.getInt();
            nS.Qx = byteBuffer.getLong();
            nS.lS = byteBuffer.getLong();
            nS.ae = byteBuffer.getLong();
            nS.TI = byteBuffer.getLong();
            nS.vT = byteBuffer.getInt();
            nS.KQ = byteBuffer.getInt();
            nS.LZ = byteBuffer.getLong();
            nS.XV = byteBuffer.getLong();
        }
        return nS;
    }

    public void eO(String string) {
        this.lo = Strings.safe(string);
    }

    public String toString() {
        return String.format("[%s]%s|f=%s|o=%X,s=%X(mem@%X)|link=%X,info=%X,align=%X", this.lo, ELF.getSHTString(this.Le), ELF.getSHFStringFlags((int)this.Qx), this.ae, this.TI, this.lS, this.vT, this.KQ, this.LZ);
    }
}

