/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.dex;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.dex.wk;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jebglobal.pT;
import java.util.Arrays;

public class DexIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "dex";
    public static final String propnameVerifyVersion = "VerifyVersion";
    public static final String propnameVerifyHashes = "VerifyHashes";
    public static final String propnameVerifyAccessFlags = "VerifyAccessFlags";
    public static final String propnameDalvikParserMode = "DalvikParserMode";
    public static final String propnameParseExtendedOpcodes = "ParseExtendedOpcodes";
    public static final String propnameParseOptimizedOpcodes = "ParseOptimizedOpcodes";
    public static final String propnameAndroidJavadocRoot = "AndroidJavadocRoot";
    public static final String propnameWellKnownLibraryPackages = "WellKnownLibraryPackages";

    public DexIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("DEX parser", "Android DEX (bytecode) disassembler", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition(propnameVerifyVersion, PropertyTypeBoolean.create(false), "Fail parsing if the DEX version number is not in the range [35, 39]");
        this.pdm.addDefinition(propnameVerifyHashes, PropertyTypeBoolean.create(false), "Fail parsing if the DEX Adler checksum is not the expected one");
        this.pdm.addDefinition(propnameVerifyAccessFlags, PropertyTypeBoolean.create(false), "Fail parsing if the access flags of a class, method, or field appear to be illegal");
        this.pdm.addDefinition(propnameDalvikParserMode, PropertyTypeInteger.create(50), String.format("Dalvik parser mode:\n- %d: Legacy DEX, including odex and extended opcodes (0xFFxx) - designed for DEX <=37\n  If DEX version >= 38 is detected, the mode will be bumped to 100, 110, or more, automatically\n- %d: ART introduction\n- %d: DEX version 38 (+invoke-polymorphic, +invoke-custom, and variants)\n- %d: DEX version 39 (+const-method-handle, +const-method-type)\n- %d: Newest, including things that may not be supported in JEB yet", 0, 50, 100, 110, 1000));
        this.pdm.addDefinition(propnameParseExtendedOpcodes, PropertyTypeBoolean.create(true), "Support parsing for the extended opcodes");
        this.pdm.addDefinition(propnameParseOptimizedOpcodes, PropertyTypeBoolean.create(true), "Support parsing for the optimized opcodes");
        String string = "($ANDROID_HOME/docs|$ANDROID_SDK_HOME/docs|$ANDROID_SDK_ROOT/docs)/reference/;https://developer.android.com/reference/;($JAVA_HOME)/docs/api";
        this.pdm.addDefinition(propnameAndroidJavadocRoot, PropertyTypeString.create(string), "Location of Java/Android API documentation files; by default, local files stored in your Android SDK folder will be preferred over web-based API doc");
        String string2 = Strings.join(",", Arrays.asList("android", "androidx", "android_src", "com.google", "java", "javax", "org.acra", "org.json", "org.apache"));
        this.pdm.addDefinition(propnameWellKnownLibraryPackages, PropertyTypeString.create(string2), "CSL of well-known packages that may not be provided as fully-expanded in code hierarchy tree documents. Use * to prevent auto-expansion for all packages. In practice, the JEB UI client will not auto-expand those packages by default to avoid cluttering the code hierarchy fragment view.");
        pT.eO(this.pdm);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        if (!DexIdentifier.checkBytes(iInput, 0, 100, 101, 120)) {
            return false;
        }
        return DexIdentifier.checkBytes(iInput, 40, 120, 86, 52, 18) || DexIdentifier.checkBytes(iInput, 40, 18, 52, 86, 120);
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        wk wk2 = new wk(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return wk2;
    }
}

