/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.apk.decoder;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.apk.decoder.Io;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class ArscIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(ArscIdentifier.class);
    public static final String TYPE = "arsc";

    public ArscIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Android arsc decoder", "Decoder for Android binary resources (APK's resources.arsc)", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (iInput == null) {
            return false;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer.remaining() < 8) {
            return false;
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        int n = byteBuffer.getInt();
        return s2 == 2 && s3 == 12 && (long)n == iInput.getCurrentSize();
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        Io io = new Io(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return io;
    }
}

