/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.debuggers.linux;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerTargetEnumerator;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnitIdentifier;
import com.pnfsoftware.jebglobal.zi;

public class GdbDebuggerIdentifier
extends AbstractUnitIdentifier
implements IDebuggerUnitIdentifier {
    public static final String TYPE = "dbug_elf";
    public static final String propnameBlockingQueryTimeoutSeconds = "BlockingQueryTimeoutSeconds";

    public GdbDebuggerIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("GDB/LLDB client debugger unit", "GDB/LLDB client of a gdbserver or lldb-server instance", "PNF Software", Version.create(0, 1, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition(propnameBlockingQueryTimeoutSeconds, PropertyTypeInteger.create(0, Integer.MAX_VALUE, 15), "Maximum time in seconds to wait for a response from the debugger server");
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        return iUnitCreator instanceof INativeCodeUnit;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        if (!(iUnitCreator instanceof IUnit)) {
            throw new IllegalArgumentException();
        }
        IUnit iUnit = (IUnit)iUnitCreator;
        if (string.isEmpty()) {
            string = "debugger";
        }
        zi zi2 = new zi(TYPE, string, iUnitProcessor, iUnitCreator, this.pdm);
        zi2.process();
        iUnit.addChild(zi2, false);
        return zi2;
    }

    @Override
    public IDebuggerTargetEnumerator getTargetEnumerator() {
        return null;
    }
}

