/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.impl;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

@Ser
public class DataContainerUnit
extends ContainerUnit {
    private static final ILogger logger = GlobalLog.getLogger(DataContainerUnit.class);
    @SerTransient
    private Entry root;

    public DataContainerUnit(Entry entry, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(entry.name, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
        this.root = entry;
    }

    @Override
    public boolean process() {
        return this.process(false);
    }

    @Override
    public boolean process(boolean bl2) {
        if (this.isProcessed()) {
            return true;
        }
        DataContainerUnit.register(this, this.root.children.values());
        this.setProcessed(true);
        return true;
    }

    public static void register(IUnit iUnit, Collection<Entry> collection) {
        DataContainerUnit.register(iUnit, collection, false);
    }

    public static void register(IUnit iUnit, Collection<Entry> collection, boolean bl2) {
        for (Entry entry : collection) {
            IUnit iUnit2;
            if (entry.isFolder()) {
                iUnit2 = new DataContainerUnit(entry, iUnit.getUnitProcessor(), (IUnitCreator)iUnit, iUnit.getPropertyDefinitionManager());
                iUnit2.process();
            } else {
                iUnit2 = iUnit.getUnitProcessor().process(entry.name, new BytesInput(entry.data), iUnit, null, false, !bl2);
            }
            iUnit.addChild(iUnit2);
        }
    }

    @Ser
    public static class Entry {
        @SerId(value=1)
        private String name;
        @SerId(value=2)
        private byte[] data;
        @SerId(value=3)
        private Map<String, Entry> children;

        public static Entry create(String string, byte[] byArray) {
            if (string == null || byArray == null) {
                throw new IllegalArgumentException();
            }
            return new Entry(string, byArray);
        }

        public static Entry createFolder(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            return new Entry(string, null);
        }

        private Entry(String string, byte[] byArray) {
            this.name = string;
            this.data = byArray;
            if (byArray == null) {
                this.children = new LinkedHashMap<String, Entry>();
            }
        }

        public boolean isFolder() {
            return this.data == null;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getData() {
            return this.data;
        }

        public Map<String, Entry> getChildren() {
            return this.children;
        }

        public String toString() {
            if (this.isFolder()) {
                return String.format("file(%d)", this.data.length);
            }
            return String.format("folder(%d)", this.children.size());
        }
    }
}

