/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.units.codeobject.ProcessorFamily;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public enum ProcessorType {
    UNKNOWN,
    X86,
    X86_64,
    ARM,
    ARM64,
    MIPS,
    MIPS64,
    AVR,
    AVR32;


    public boolean isI386() {
        return this == X86 || this == X86_64;
    }

    public boolean isArm() {
        return this == ARM || this == ARM64;
    }

    public boolean isMIPS() {
        return this == MIPS || this == MIPS64;
    }

    public boolean is64Bit() {
        return this == X86_64 || this == ARM64 || this == MIPS64;
    }

    public ProcessorFamily getFamily() {
        switch (this) {
            case ARM: 
            case ARM64: {
                return ProcessorFamily.ARM;
            }
            case MIPS: 
            case MIPS64: {
                return ProcessorFamily.MIPS;
            }
            case X86: 
            case X86_64: {
                return ProcessorFamily.X86;
            }
        }
        return ProcessorFamily.UNKNOWN;
    }

    public String toWellKnownUnitType() {
        switch (this) {
            case ARM: {
                return "arm";
            }
            case ARM64: {
                return "arm64";
            }
            case MIPS: {
                return "mips";
            }
            case MIPS64: {
                return "mips64";
            }
            case X86: {
                return "x86";
            }
            case X86_64: {
                return "x86_64";
            }
            case AVR: {
                return "avr";
            }
            case AVR32: {
                return "avr";
            }
            case UNKNOWN: {
                return null;
            }
        }
        return null;
    }

    public static ProcessorType fromArchName(String string) {
        if (string == null) {
            return null;
        }
        string = Strings.trim(string).toLowerCase();
        switch (string.toLowerCase()) {
            case "arm": {
                return ARM;
            }
            case "aarch64": 
            case "arm64": {
                return ARM64;
            }
            case "i386": 
            case "x86": {
                return X86;
            }
            case "amd64": 
            case "x64": 
            case "x86-64": 
            case "x86_64": 
            case "i386:x86-64": {
                return X86_64;
            }
            case "mips": {
                return MIPS;
            }
            case "mips64": {
                return MIPS64;
            }
            case "avr": {
                return AVR;
            }
            case "avr32": {
                return AVR32;
            }
        }
        return null;
    }
}

