/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.codeobject.ICOFFHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ICOFFSectionHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ILoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.IPEOptionalHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.LoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.corei.parsers.winpe.OI;
import com.pnfsoftware.jeb.corei.parsers.winpe.Rf;
import com.pnfsoftware.jeb.corei.parsers.winpe.ej;
import com.pnfsoftware.jeb.corei.parsers.winpe.pX;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.List;

public class PEParser {
    private static final ILogger logger = GlobalLog.getLogger(PEParser.class);
    ej filehdr;
    pX opthdr;
    Rf[] sectab;
    private ILoaderInformation ldInfo = new LoaderInformation();
    private List<ISegmentInformation> segInfo = new ArrayList<ISegmentInformation>();
    private List<ISegmentInformation> secInfo = new ArrayList<ISegmentInformation>();
    private boolean is64Bit;
    private boolean isLowAlignment;

    public PEParser(IInput iInput) throws IOException {
        long l2 = 0L;
        try (Object object = iInput.getChannel();){
            int n;
            int n2;
            long l3 = object.size();
            if (l3 <= 64L) {
                throw new IOException();
            }
            if (ChannelUtil.getLEShort((SeekableByteChannel)object, 0L) != 23117) {
                throw new IOException();
            }
            int n3 = ChannelUtil.getLEInt((SeekableByteChannel)object, 60L);
            if (n3 < 0 || (long)(n3 + 4) > l3) {
                throw new IOException();
            }
            if (ChannelUtil.getLEInt((SeekableByteChannel)object, n3) != 17744) {
                throw new IOException();
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
            object.position(n3 + 4);
            if (object.read(byteBuffer) != 20) {
                throw new IOException();
            }
            byteBuffer.rewind();
            this.filehdr = ej.eO(byteBuffer);
            short s2 = ChannelUtil.getLEShort((SeekableByteChannel)object, n3 + 4 + 20);
            if (s2 == 523) {
                this.is64Bit = true;
            } else if (s2 != 267) {
                throw new IOException(String.format("Invalid optional header magic: %X", s2));
            }
            byteBuffer = ByteBuffer.allocate(512).order(ByteOrder.LITTLE_ENDIAN);
            object.position(n3 + 4 + 20);
            int n4 = object.read(byteBuffer);
            if (n4 < 69) {
                throw new IOException();
            }
            byteBuffer.rewind();
            byteBuffer.limit(n4);
            this.opthdr = pX.eO(byteBuffer, this.is64Bit);
            int n5 = this.opthdr.qo;
            int n6 = this.opthdr.lo;
            if (!this.isPowerOfTwo(n5) || !this.isPowerOfTwo(n6)) {
                throw new IOException(String.format("Invalid alignments, must be a power of 2 (file=%Xh, section=%Xh)", n5, n6));
            }
            if (n6 <= 4096) {
                this.isLowAlignment = true;
            }
            if (n5 > n6) {
                throw new IOException(String.format("Invalid alignments (file=%Xh, section=%Xh)", n5, n6));
            }
            this.sectab = new Rf[this.filehdr.Le];
            if (this.sectab.length > 0) {
                object.position(n3 + 4 + 20 + this.filehdr.TI);
                byteBuffer = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
                long l4 = -1L;
                for (n2 = 0; n2 < this.sectab.length; ++n2) {
                    String string;
                    int n7;
                    long l5;
                    long l6;
                    long l7;
                    Rf rf2;
                    byteBuffer.rewind();
                    if (object.read(byteBuffer) != 40) {
                        throw new IOException();
                    }
                    byteBuffer.rewind();
                    this.sectab[n2] = rf2 = Rf.eO(byteBuffer);
                    long l8 = rf2.ae;
                    long l9 = rf2.lS;
                    long l10 = rf2.Le;
                    if (!this.isLowAlignment) {
                        l7 = l8 & 0xFFFFFFFFFFFFFE00L;
                        l6 = (l8 + l9 + (long)n5 - 1L & (long)(~(n5 - 1))) - l7;
                        l6 = Math.min(l6, l9 + 4095L & 0xFFFFFFFFFFFFF000L);
                        if (l10 != 0L) {
                            l6 = Math.min(l6, l10 + 4095L & 0xFFFFFFFFFFFFF000L);
                        }
                    } else {
                        l7 = l8 & (long)(~(n5 - 1));
                        l6 = l9;
                        if (l10 != 0L) {
                            l6 = Math.min(l6, l10 + (long)n6 - 1L & (long)(~(n6 - 1)));
                        }
                    }
                    if (l6 > Integer.MAX_VALUE) {
                        throw new RuntimeException("Section is too large");
                    }
                    long l11 = l7 + l6;
                    if (l11 > l2) {
                        l2 = l11;
                    }
                    if ((l5 = rf2.Qx) % (long)n6 != 0L) {
                        throw new IOException("Invalid segment memory address");
                    }
                    if (l10 == 0L) {
                        l10 = l6;
                    }
                    if (l4 != -1L && l4 != l5) {
                        logger.warn("Illegal section, PE unlikely to load: expected RVA= %Xh, actual=%Xh", l4, l5);
                    }
                    long l12 = (l10 + (long)n6 - 1L) / (long)n6 * (long)n6;
                    l4 = l5 + l12;
                    try {
                        for (n7 = 0; n7 < rf2.eO.length && rf2.eO[n7] != 0; ++n7) {
                        }
                        string = Strings.decodeASCII(rf2.eO, 0, n7);
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                    n7 = this.sectionCharacteristicsToGenericFlags(rf2.XV);
                    this.segInfo.add(new SegmentInformation(string, l7, l6, l5, l10, n7));
                }
            }
            int n8 = (int)object.size();
            if (this.sectab.length >= 1) {
                n = (int)this.sectab[0].ae;
                for (n2 = 1; n == 0 && n2 < this.sectab.length; ++n2) {
                    n = (int)this.sectab[n2].ae;
                }
                if (n != 0 && n < n8) {
                    n8 = n;
                }
            }
            if ((n = (int)this.opthdr.OP) < n8) {
                n8 = n;
            }
            this.segInfo.add(0, new SegmentInformation("<hdr>", 0L, n8, 0L, n8, 2));
        }
        object = new LoaderInformation.Builder();
        int n = 0;
        if ((this.filehdr.vT & 0x2000) != 0) {
            n |= 4;
        }
        ((LoaderInformation.Builder)object).setFlags(n);
        ((LoaderInformation.Builder)object).setTargetProcessor(this.machineToProcessorType(this.filehdr.eO));
        ((LoaderInformation.Builder)object).setTargetSubsystem(this.subsystemToSubsystemType(this.opthdr.Vj));
        ((LoaderInformation.Builder)object).setEndianness(this.machineToEndianness(this.filehdr.eO));
        ((LoaderInformation.Builder)object).setWordSize(this.is64Bit ? 64 : 32);
        ((LoaderInformation.Builder)object).setCompilationTimestamp(this.filehdr.getTimestampMs());
        ((LoaderInformation.Builder)object).setImageBase(this.opthdr.XV);
        ((LoaderInformation.Builder)object).setImageSize(this.opthdr.hd);
        ((LoaderInformation.Builder)object).setEntryPoint(this.opthdr.vT);
        ((LoaderInformation.Builder)object).setOverlayOffset(l2);
        this.ldInfo = ((LoaderInformation.Builder)object).build();
        for (int j = 0; j < this.opthdr.BQ.length; ++j) {
            OI oI = this.opthdr.BQ[j];
            String string = j < OI.eO.length ? OI.eO[j] : "-";
            long l13 = 0L;
            if (oI.Qx != 0L) {
                l13 = this.convertRelativeAddressToFileOffset(oI.Qx);
            }
            this.secInfo.add(new SegmentInformation(string, l13, oI.lS, oI.Qx, oI.lS, 0));
        }
    }

    private boolean isPowerOfTwo(int n) {
        return n > 0 && (n & n - 1) == 0;
    }

    private int sectionCharacteristicsToGenericFlags(int n) {
        int n2 = 0;
        n2 |= (n & 0x40000000) != 0 ? 2 : 0;
        n2 |= (n & Integer.MIN_VALUE) != 0 ? 1 : 0;
        return n2 |= (n & 0x20000000) != 0 ? 4 : 0;
    }

    private ProcessorType machineToProcessorType(int n) {
        switch (n) {
            case 332: {
                return ProcessorType.X86;
            }
            case 34404: {
                return ProcessorType.X86_64;
            }
            case 448: 
            case 450: 
            case 452: {
                return ProcessorType.ARM;
            }
            case 43620: {
                return ProcessorType.ARM64;
            }
            case 354: 
            case 358: 
            case 360: 
            case 361: 
            case 870: {
                return ProcessorType.MIPS;
            }
            case 352: {
                return ProcessorType.MIPS;
            }
        }
        return null;
    }

    private Endianness machineToEndianness(int n) {
        switch (n) {
            case 352: {
                return Endianness.BIG_ENDIAN;
            }
        }
        return Endianness.LITTLE_ENDIAN;
    }

    private SubsystemType subsystemToSubsystemType(int n) {
        switch (n) {
            case 8: {
                return SubsystemType.WINDOWS_KERNEL;
            }
            case 2: 
            case 3: {
                return SubsystemType.WINDOWS_USER;
            }
        }
        return null;
    }

    public long add(long l2, long l3) {
        return this.sanitizeAddress(l2 + l3);
    }

    public long sanitizeAddress(long l2) {
        return this.is64Bit ? l2 : l2 & 0xFFFFFFFFL;
    }

    public boolean isAddressInside(long l2) {
        return l2 >= this.opthdr.XV && l2 < this.add(this.opthdr.XV, this.opthdr.hd);
    }

    public long convertFileOffsetToRelativeAddress(long l2) {
        for (Rf rf2 : this.sectab) {
            if (l2 < rf2.ae || l2 > rf2.ae + rf2.lS) continue;
            return rf2.Qx + (l2 - rf2.ae);
        }
        return -1L;
    }

    public long convertRelativeAddressToFileOffset(long l2) {
        for (Rf rf2 : this.sectab) {
            if (l2 < rf2.Qx || l2 >= rf2.Qx + rf2.Le) continue;
            return rf2.ae + (l2 - rf2.Qx);
        }
        return -1L;
    }

    public ICOFFHeader getCOFFHeader() {
        return this.filehdr;
    }

    public IPEOptionalHeader getPEOptionalHeader() {
        return this.opthdr;
    }

    public ICOFFSectionHeader[] getSectionHeaders() {
        return this.sectab;
    }

    public List<ISegmentInformation> getSegments() {
        return this.segInfo;
    }

    public int getSegmentCount() {
        return this.segInfo.size();
    }

    public ISegmentInformation getSegment(int n) {
        return this.segInfo.get(n);
    }
}

