/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.debug.impl;

import com.pnfsoftware.jeb.core.units.code.debug.DebuggerConnectorClass;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerMachineInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerProcessInformation;

public class DebuggerSetupInformation {
    private DebuggerConnectorClass connectorClass;
    private IDebuggerMachineInformation machine;
    private IDebuggerProcessInformation process;
    private String hostname;
    private int port;
    private boolean suspendThreads;
    private boolean useChidrenDebuggers;

    public static DebuggerSetupInformation create(IDebuggerMachineInformation iDebuggerMachineInformation, IDebuggerProcessInformation iDebuggerProcessInformation) {
        DebuggerSetupInformation debuggerSetupInformation = new DebuggerSetupInformation();
        debuggerSetupInformation.connectorClass = DebuggerConnectorClass.PROCESS;
        debuggerSetupInformation.machine = iDebuggerMachineInformation;
        debuggerSetupInformation.process = iDebuggerProcessInformation;
        return debuggerSetupInformation;
    }

    public static DebuggerSetupInformation create(String string, int n) {
        DebuggerSetupInformation debuggerSetupInformation = new DebuggerSetupInformation();
        debuggerSetupInformation.connectorClass = DebuggerConnectorClass.PORT;
        debuggerSetupInformation.hostname = string;
        debuggerSetupInformation.port = n;
        return debuggerSetupInformation;
    }

    private DebuggerSetupInformation() {
    }

    public DebuggerConnectorClass getConnectorClass() {
        return this.connectorClass;
    }

    public IDebuggerMachineInformation getMachine() {
        return this.machine;
    }

    public IDebuggerProcessInformation getProcess() {
        return this.process;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean doSuspendThreads() {
        return this.suspendThreads;
    }

    public void setSuspendThreads(boolean bl2) {
        this.suspendThreads = bl2;
    }

    public boolean shouldUseChildrenDebuggers() {
        return this.useChidrenDebuggers;
    }

    public void setUseChildrenDebuggers(boolean bl2) {
        this.useChidrenDebuggers = bl2;
    }

    public String toString() {
        String string = String.format("%s=", new Object[]{this.connectorClass});
        switch (this.connectorClass) {
            case PROCESS: {
                string = string + String.format("%s:%s", this.machine, this.process);
                break;
            }
            case PORT: {
                string = string + String.format("%s:%s", this.hostname, this.port);
                break;
            }
            default: {
                string = string + "?";
            }
        }
        string = string + String.format("(susp=%b,usechld=%b)", this.suspendThreads, this.useChidrenDebuggers);
        return string;
    }
}

