/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.IAliasType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IArrayType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.IEnumerationType;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrimitiveType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IReferenceType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureTypeField;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeLibrary;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.PrimitiveCategory;
import com.pnfsoftware.jeb.core.units.code.asm.type.PrototypeAttribute;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryService;
import com.pnfsoftware.jeb.util.base.ISimpleFilter;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jebglobal.EK;
import com.pnfsoftware.jebglobal.IJ;
import com.pnfsoftware.jebglobal.Sg;
import com.pnfsoftware.jebglobal.lj;
import com.pnfsoftware.jebglobal.tc;
import com.pnfsoftware.jebglobal.wV;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TypeUtil {
    public static final Set<String> keywords = new HashSet<String>(Arrays.asList("auto", "register"));
    public static final int TYPESOURCE_INUSE = 1;
    public static final int TYPESOURCE_TYPELIBS = 2;
    public static final int TYPESOURCE_ALL = 3;

    public static boolean isKeyword(String string) {
        return keywords.contains(string);
    }

    public static boolean isReservedLiteral(String string) {
        return TypeUtil.isKeyword(string) || string.equals("null") || string.equals("true") || string.equals("false");
    }

    private static boolean isValidName(String string, boolean bl2) {
        if (string.length() == 0 || TypeUtil.isReservedLiteral(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int j = 1; j < string.length(); ++j) {
            char c = string.charAt(j);
            if (Character.isJavaIdentifierPart(c) || bl2 && c == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPackageName(String string) {
        return TypeUtil.isValidName(string, false);
    }

    public static boolean isValidTypeName(String string) {
        return TypeUtil.isValidName(string, true);
    }

    public static boolean isValidFullyQualifiedName(String string, List<String> list, String[] stringArray) {
        String[] stringArray2 = string.split("::", -1);
        if (stringArray2.length == 0) {
            return false;
        }
        for (int j = 0; j < stringArray2.length - 1; ++j) {
            if (TypeUtil.isValidPackageName(stringArray2[j])) continue;
            return false;
        }
        if (!TypeUtil.isValidTypeName(stringArray2[stringArray2.length - 1])) {
            return false;
        }
        if (list != null) {
            list.clear();
            for (String string2 : stringArray2) {
                list.add(string2);
            }
        }
        if (stringArray != null) {
            stringArray[0] = list.get(list.size() - 1);
        }
        return true;
    }

    public static String processSignature(String string, int[] nArray) {
        int n;
        int n2;
        int n3 = -1;
        if (string.endsWith("]")) {
            for (n2 = string.length() - 2; n2 >= 0 && string.charAt(n2) != '['; --n2) {
            }
            if (n2 >= 0) {
                try {
                    n3 = Integer.parseInt(string.substring(n2 + 1, string.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n3 <= 0) {
                return null;
            }
            string = string.substring(0, n2);
        }
        n2 = 0;
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == '*'; --n) {
            ++n2;
        }
        string = string.substring(0, n + 1).trim();
        if (nArray != null) {
            nArray[0] = n2;
            nArray[1] = n3;
        }
        return string;
    }

    public static String normalizeSignature(boolean bl2, String string, List<String> list, int[] nArray) {
        String string2;
        if (!bl2) {
            string = TypeUtil.preNormalizeSignature(string);
        }
        if ((string2 = TypeUtil.processSignature(string, nArray)) == null) {
            return null;
        }
        if (!TypeUtil.isValidFullyQualifiedName(string2, list, null)) {
            return null;
        }
        return string;
    }

    public static String preNormalizeSignature(String string) {
        string = string.trim();
        if ((string = string.replace(".", "::").replace("/", "::")).startsWith("::")) {
            string = string.substring(2);
        }
        string = string.replaceAll("\\s+", " ");
        return string;
    }

    public static String buildFullyQualifiedTypeNameFromElements(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (String string : list) {
            if (n >= 1) {
                stringBuilder.append("::");
            }
            stringBuilder.append(string);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static INativeType buildQuickType(ITypeManager iTypeManager, String string) {
        int[] nArray;
        String string2 = TypeUtil.processSignature(string = TypeUtil.preNormalizeSignature(string), nArray = new int[2]);
        if (string2 == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!TypeUtil.isValidFullyQualifiedName(string2, arrayList, null)) {
            return null;
        }
        INativeType iNativeType = iTypeManager.getType(string2);
        if (iNativeType == null) {
            return null;
        }
        INativeType iNativeType2 = null;
        int n = nArray[0];
        iNativeType2 = n == 0 ? iNativeType : iTypeManager.createReference(iNativeType, n);
        if (nArray[1] >= 0) {
            iNativeType2 = iTypeManager.createArray(iNativeType2, nArray[1]);
        }
        return iNativeType2;
    }

    public static INativeType buildArrayType(ITypeManager iTypeManager, String string, int ... nArray) {
        INativeType iNativeType = iTypeManager.getType(string);
        if (iNativeType == null) {
            return null;
        }
        for (int j = nArray.length - 1; j >= 0; --j) {
            int n = nArray[j];
            if (n <= 0) {
                return null;
            }
            iNativeType = iTypeManager.createArray(iNativeType, n);
        }
        return iNativeType;
    }

    public static boolean isPrimitive(INativeType iNativeType) {
        return iNativeType instanceof IPrimitiveType;
    }

    public static boolean isReference(INativeType iNativeType) {
        return iNativeType instanceof IReferenceType;
    }

    public static boolean isPrototype(INativeType iNativeType) {
        return iNativeType instanceof IPrototypeItem;
    }

    public static boolean isSimple(INativeType iNativeType) {
        return TypeUtil.isPrimitive(iNativeType) || TypeUtil.isReference(iNativeType) || TypeUtil.isPrototype(iNativeType);
    }

    public static boolean isAlias(INativeType iNativeType) {
        return iNativeType instanceof IAliasType;
    }

    public static INativeType getNonAlias(INativeType iNativeType) {
        if (iNativeType instanceof IAliasType) {
            INativeType iNativeType2 = ((IAliasType)iNativeType).getAliasedType();
            return TypeUtil.getNonAlias(iNativeType2);
        }
        return iNativeType;
    }

    public static <T extends INativeType> T getNonAlias(INativeType iNativeType, Class<T> clazz) {
        if (iNativeType instanceof IAliasType) {
            INativeType iNativeType2 = ((IAliasType)iNativeType).getAliasedType();
            return TypeUtil.getNonAlias(iNativeType2, clazz);
        }
        return (T)iNativeType;
    }

    public static boolean isBitfieldCompatible(INativeType iNativeType) {
        return TypeUtil.getEquivalentBitfieldTypeSize(iNativeType) != 0;
    }

    public static boolean areBitfielTypesEquivalent(INativeType iNativeType, INativeType iNativeType2) {
        int n = TypeUtil.getEquivalentBitfieldTypeSize(iNativeType);
        return n != 0 && n == TypeUtil.getEquivalentBitfieldTypeSize(iNativeType2);
    }

    private static int getEquivalentBitfieldTypeSize(INativeType iNativeType) {
        if ((iNativeType = TypeUtil.getNonAlias(iNativeType)) instanceof IEnumerationType) {
            iNativeType = iNativeType.getTypeManager().getType("int");
        }
        if (iNativeType instanceof IPrimitiveType && ((IPrimitiveType)iNativeType).getCategory() == PrimitiveCategory.INTEGER) {
            return iNativeType.getSize();
        }
        return 0;
    }

    public static boolean isPointer(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IReferenceType;
    }

    public static boolean isFunctionPointer(INativeType iNativeType) {
        return TypeUtil.isFunctionPointer(iNativeType, null);
    }

    public static boolean isFunctionPointer(INativeType iNativeType, IPrototypeItem[] iPrototypeItemArray) {
        INativeType iNativeType2;
        INativeType iNativeType3 = TypeUtil.getNonAlias(iNativeType);
        if (iNativeType3 instanceof IReferenceType && (iNativeType2 = ((IReferenceType)iNativeType3).getPointedType()) instanceof IPrototypeItem) {
            if (iPrototypeItemArray != null) {
                iPrototypeItemArray[0] = (IPrototypeItem)iNativeType2;
            }
            return true;
        }
        return false;
    }

    public static boolean isVoid(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isVoid((IPrimitiveType)iNativeType2);
    }

    public static boolean isVoidPointer(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        if (iNativeType2 instanceof IReferenceType) {
            return TypeUtil.isVoid(((IReferenceType)iNativeType2).getPointedType());
        }
        return false;
    }

    public static boolean isCharacter(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isCharacter((IPrimitiveType)iNativeType2);
    }

    public static boolean isInteger(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isInteger((IPrimitiveType)iNativeType2);
    }

    public static boolean isSignedInteger(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isSignedInteger((IPrimitiveType)iNativeType2);
    }

    public static boolean isUnsignedInteger(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isUnsignedInteger((IPrimitiveType)iNativeType2);
    }

    public static boolean isFloat(INativeType iNativeType) {
        INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
        return iNativeType2 instanceof IPrimitiveType && iNativeType.getTypeManager().getPrimitives().isFloat((IPrimitiveType)iNativeType2);
    }

    public static List<INativeType> collectTypes(IPrototypeItem iPrototypeItem) {
        ArrayList<INativeType> arrayList = Lists.createArrayList();
        INativeType iNativeType = iPrototypeItem.getReturnType();
        Lists.addNonNulls(arrayList, iNativeType);
        for (INativeType iNativeType2 : iPrototypeItem.getParameterTypes()) {
            Lists.addNonNulls(arrayList, iNativeType2);
        }
        return arrayList;
    }

    public static List<INativeType> findType(Collection<? extends INativeType> collection, String string, boolean bl2) {
        ArrayList<INativeType> arrayList = new ArrayList<INativeType>();
        for (INativeType iNativeType : collection) {
            String string2 = iNativeType.getSignature(true);
            String string3 = iNativeType.getSignature(false);
            if (!string2.contains(string) && !string3.contains(string)) continue;
            arrayList.add(iNativeType);
            if (!bl2) continue;
            break;
        }
        return arrayList;
    }

    public static boolean structureInStructure(IStructureType iStructureType, INativeType iNativeType) {
        if (iNativeType instanceof IJ) {
            return TypeUtil.structureInStructure(iStructureType, ((IJ)iNativeType).TI());
        }
        if (iNativeType instanceof Sg) {
            return TypeUtil.structureInStructure(iStructureType, ((Sg)iNativeType).TI());
        }
        if (iNativeType instanceof lj) {
            if (iStructureType == iNativeType) {
                return true;
            }
            for (wV wV2 : ((lj)iNativeType).getFields()) {
                if (!TypeUtil.structureInStructure(iStructureType, wV2.eO())) continue;
                return true;
            }
        }
        return false;
    }

    public static INativeType getFirstSimpleType(INativeType iNativeType) {
        while (iNativeType != null) {
            if ((iNativeType = TypeUtil.getNonAlias(iNativeType)) instanceof IArrayType) {
                iNativeType = ((IArrayType)iNativeType).getElementType();
                continue;
            }
            if (iNativeType instanceof IStructureType) {
                if (((IStructureType)iNativeType).getFields().size() == 0) break;
                iNativeType = ((IStructureType)iNativeType).getField(0).getType();
                continue;
            }
            if (!(iNativeType instanceof IPrimitiveType) && !(iNativeType instanceof IEnumerationType) && !(iNativeType instanceof IReferenceType)) break;
            return iNativeType;
        }
        return null;
    }

    public static INativeType getBaseType(INativeType iNativeType) {
        INativeType iNativeType2 = null;
        if (iNativeType instanceof IArrayType) {
            iNativeType2 = ((IArrayType)iNativeType).getElementType();
        } else if (iNativeType instanceof IReferenceType) {
            iNativeType2 = ((IReferenceType)iNativeType).getMainType();
        } else if (iNativeType instanceof IPrimitiveType || iNativeType instanceof IPrototypeItem || iNativeType instanceof tc) {
            return iNativeType;
        }
        if (iNativeType2 == iNativeType) {
            return null;
        }
        return TypeUtil.getBaseType(iNativeType2);
    }

    public static IStructureTypeField getStructureField(INativeType iNativeType, String string) {
        if (!((iNativeType = TypeUtil.getNonAlias(iNativeType)) instanceof IStructureType)) {
            return null;
        }
        return ((IStructureType)iNativeType).getFieldByName(string);
    }

    public static IStructureTypeField getStructureField(INativeType iNativeType, int n) {
        if (!((iNativeType = TypeUtil.getNonAlias(iNativeType)) instanceof IStructureType)) {
            return null;
        }
        return ((IStructureType)iNativeType).getFieldAt(n);
    }

    public static IPrototypeItem buildQuickPrototype(ITypeManager iTypeManager, String string) {
        String string2;
        INativeType iNativeType;
        String[] stringArray;
        String string3 = string.trim();
        if (string3.endsWith(";")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (string3.isEmpty() || string3.charAt(string3.length() - 1) != ')') {
            return null;
        }
        int n = string3.indexOf(40);
        if (n < 0) {
            return null;
        }
        String string4 = string3.substring(0, n);
        String string5 = string3.substring(n + 1, string3.length() - 1).trim();
        int n2 = 0;
        ICallingConvention iCallingConvention = null;
        if (string4.startsWith("<")) {
            n2 = string4.indexOf(62);
            if (n2 < 0) {
                return null;
            }
            stringArray = string4.substring(1, n2);
            iCallingConvention = iTypeManager.getCallingConventionManager().getConvention((String)stringArray);
            ++n2;
        }
        if ((iNativeType = TypeUtil.buildQuickType(iTypeManager, string2 = Strings.join(" ", Arrays.asList(stringArray = string4.substring(n2).trim().split("\\s+", -1))))) == null) {
            return null;
        }
        ArrayList<INativeType> arrayList = new ArrayList<INativeType>();
        boolean bl2 = false;
        if (!string5.isEmpty()) {
            String[] stringArray2;
            for (String string6 : stringArray2 = string5.split(",", -1)) {
                INativeType iNativeType2;
                if (bl2) {
                    return null;
                }
                stringArray = string6.trim().split("\\s+");
                String string7 = Strings.join(" ", stringArray, 0, stringArray.length);
                if (string7.equals("...")) {
                    bl2 = true;
                }
                if ((iNativeType2 = TypeUtil.buildQuickType(iTypeManager, string7)) == null) {
                    return null;
                }
                arrayList.add(iNativeType2);
            }
        }
        return iTypeManager.createPrototype(iCallingConvention, iNativeType, arrayList, bl2 ? Arrays.asList(PrototypeAttribute.VarArg) : null);
    }

    public static List<INativeType> retrieveAvailableTypes(INativeCodeUnit<?> iNativeCodeUnit, int n) {
        return TypeUtil.retrieveAvailableTypes(iNativeCodeUnit, n, null);
    }

    public static List<INativeType> retrieveAvailableTypes(INativeCodeUnit<?> iNativeCodeUnit, int n, ISimpleFilter<INativeType> iSimpleFilter) {
        ArrayList<INativeType> arrayList = new ArrayList<INativeType>();
        if ((n & 1) != 0) {
            for (INativeType object : iNativeCodeUnit.getTypeManager().getTypes(iSimpleFilter)) {
                arrayList.add(object);
            }
        }
        if ((n & 2) != 0) {
            TypeLibraryService typeLibraryService = iNativeCodeUnit.getTypeLibraryService();
            for (ITypeLibrary iTypeLibrary : typeLibraryService.getLoadedTypeLibraries()) {
                for (INativeType iNativeType : iTypeLibrary.getTypes(iSimpleFilter)) {
                    arrayList.add(iNativeType);
                }
            }
        }
        return arrayList;
    }

    public static String generateRoutineSignature(String string, IPrototypeItem iPrototypeItem) {
        return ((EK)iPrototypeItem).eO(true, string);
    }
}

