/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParseException;
import com.pnfsoftware.jeb.core.units.code.asm.type.WellKnownCallingConventionNames;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.EK;
import com.pnfsoftware.jebglobal.Ik;
import com.pnfsoftware.jebglobal.Wo;
import com.pnfsoftware.jebglobal.XP;
import com.pnfsoftware.jebglobal.XQ;
import com.pnfsoftware.jebglobal.Xf;
import com.pnfsoftware.jebglobal.lc;
import com.pnfsoftware.jebglobal.sy;
import com.pnfsoftware.jebglobal.vs;
import java.util.ArrayList;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class TypeStringParser {
    private static final ILogger logger = GlobalLog.getLogger(TypeStringParser.class);
    private static final TypeStringParser verifier = new TypeStringParser();
    public static final int TYPE = 0;
    public static final int PROTO = 1;
    public static final int SIG = 2;
    private sy typeman;

    private TypeStringParser() {
    }

    public TypeStringParser(ITypeManager iTypeManager) {
        if (iTypeManager == null) {
            throw new IllegalArgumentException("Provide a type manager");
        }
        this.typeman = (sy)iTypeManager;
    }

    public INativeType parseType(String string) throws TypeStringParseException {
        XQ xQ2 = null;
        try {
            string = Strings.trimWhitespaces(string);
            if (!string.endsWith(";")) {
                string = string.endsWith(")") ? string + ";" : string + " _;";
            }
            xQ2 = this.parseForType(string);
        }
        catch (Exception exception) {
            throw new TypeStringParseException(exception);
        }
        if (xQ2 == null) {
            throw new TypeStringParseException();
        }
        return xQ2;
    }

    public IPrototypeItem parsePrototype(String string) throws TypeStringParseException {
        IPrototypeItem iPrototypeItem = null;
        String[] stringArray = new String[1];
        try {
            string = this.massageProtoString(string, stringArray);
            if (string != null) {
                iPrototypeItem = (IPrototypeItem)((Object)this.parseForType(string));
            }
        }
        catch (Exception exception) {
            throw new TypeStringParseException("Error parsing prototype: " + string, exception);
        }
        if (iPrototypeItem == null) {
            throw new TypeStringParseException("Error parsing prototype: " + string);
        }
        String string2 = stringArray[0];
        if (!Strings.isBlank(string2)) {
            WellKnownCallingConventionNames wellKnownCallingConventionNames = WellKnownCallingConventionNames.get(string2);
            if (wellKnownCallingConventionNames == null) {
                throw new TypeStringParseException("Unknown calling convention: " + string2);
            }
            string2 = wellKnownCallingConventionNames.toString();
            vs vs2 = this.typeman.Qx().eO(string2);
            if (vs2 == null) {
                throw new TypeStringParseException("Unsupported calling convention: " + string2);
            }
            ((EK)iPrototypeItem).eO(vs2);
        }
        return iPrototypeItem;
    }

    private String massageProtoString(String string, String[] stringArray) {
        String string2 = Strings.trimWhitespaces(string);
        if (string2.endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.isEmpty() || string2.charAt(string2.length() - 1) != ')') {
            return null;
        }
        int n = string2.indexOf(40);
        if (n < 0) {
            return null;
        }
        int n2 = string2.lastIndexOf(41);
        if (n2 < 0) {
            return null;
        }
        String string3 = string2.substring(n + 1, n2).trim();
        String string4 = string2.substring(0, n);
        String string5 = "";
        int n3 = 0;
        if (string4.startsWith("<")) {
            n3 = string4.indexOf(62);
            if (n3 < 0) {
                return null;
            }
            string5 = string4.substring(1, n3);
            if (stringArray != null) {
                stringArray[0] = string5;
                string5 = "";
            }
            ++n3;
        }
        String string6 = string4.substring(n3);
        return string6 + " " + string5 + " f(" + string3 + ");";
    }

    public IPrototypeItem parseSignature(String string, boolean bl2) throws TypeStringParseException {
        string = TypeStringParser.massageSingleDeclaration(string, bl2);
        lc lc2 = null;
        try {
            lc2 = this.parseSingleDeclaration(string);
        }
        catch (Exception exception) {
            throw new TypeStringParseException("Error parsing signature: " + string, exception);
        }
        if (lc2 == null) {
            throw new TypeStringParseException("Error parsing signature: " + string);
        }
        if (!(lc2.eO() instanceof EK)) {
            throw new TypeStringParseException();
        }
        return (EK)lc2.eO();
    }

    private XQ parseForType(String string) {
        return this.parseSingleDeclaration(string).eO();
    }

    private lc parseSingleDeclaration(String string) {
        Xf xf2 = new Xf((CharStream)CharStreams.fromString((String)string));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)xf2);
        XP xP = new XP((TokenStream)commonTokenStream);
        xP.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        XP.ZY zY2 = xP.KC();
        if (this.typeman == null) {
            return null;
        }
        Ik ik = new Ik(zY2, Wo.eO, this.typeman);
        return ik.lS().get(0);
    }

    public static void verify(String string, boolean bl2) throws TypeStringParseException {
        String string2 = TypeStringParser.massageSingleDeclaration(string, bl2);
        try {
            verifier.parseSingleDeclaration(string2);
        }
        catch (Exception exception) {
            throw new TypeStringParseException("Error parsing signature: " + string2, exception);
        }
    }

    public static String massageSingleDeclaration(String string, boolean bl2) throws TypeStringParseException {
        String string2 = Strings.trimWhitespaces(string);
        if (!string2.endsWith(";")) {
            string2 = string2 + ";";
        }
        if (bl2 && (string2 = TypeStringParser.removeCppTemplates(string2)) == null) {
            throw new TypeStringParseException("Illegal template in signature: " + string2);
        }
        return string2;
    }

    public static String removeCppTemplates(String string) {
        int n;
        int n2 = 0;
        ArrayList<Couple<Integer, Integer>> arrayList = new ArrayList<Couple<Integer, Integer>>();
        int n3 = 0;
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c == '<') {
                if (n2 == 0) {
                    n3 = n;
                }
                ++n2;
                continue;
            }
            if (c != '>') continue;
            if (--n2 < 0) {
                return null;
            }
            if (n2 != 0) continue;
            arrayList.add(new Couple<Integer, Integer>(n3, n + 1));
        }
        if (n2 != 0) {
            return null;
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            Couple couple = (Couple)arrayList.get(n);
            string = string.substring(0, (Integer)couple.getFirst()) + string.substring((Integer)couple.getSecond(), string.length());
        }
        return string;
    }
}

