/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor.memory;

import com.pnfsoftware.jeb.core.units.code.asm.processor.memory.IEncodedMemoryArea;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.math.MathUtil;

public class EncodedMemoryAreaUtil {
    public static int signExtendInt(byte[] byArray, IEncodedMemoryArea iEncodedMemoryArea) {
        int n = iEncodedMemoryArea.getLength();
        int n2 = EncodedMemoryAreaUtil.zeroExtend(byArray, iEncodedMemoryArea);
        return MathUtil.signExtend32(n2, n);
    }

    public static long signExtendLong(byte[] byArray, IEncodedMemoryArea iEncodedMemoryArea) {
        int n = iEncodedMemoryArea.getLength();
        long l2 = EncodedMemoryAreaUtil.zeroExtendLong(byArray, iEncodedMemoryArea);
        return MathUtil.signExtend(l2, n);
    }

    public static int zeroExtend(byte[] byArray, IEncodedMemoryArea iEncodedMemoryArea) {
        int n = 0;
        if (iEncodedMemoryArea == null) {
            return n;
        }
        return (int)iEncodedMemoryArea.decode(byArray);
    }

    public static long zeroExtendLong(byte[] byArray, IEncodedMemoryArea ... iEncodedMemoryAreaArray) {
        long l2 = 0L;
        if (iEncodedMemoryAreaArray == null || iEncodedMemoryAreaArray.length == 0) {
            return l2;
        }
        for (IEncodedMemoryArea iEncodedMemoryArea : iEncodedMemoryAreaArray) {
            l2 = l2 << iEncodedMemoryArea.getLength() | iEncodedMemoryArea.decode(byArray);
        }
        return l2;
    }

    public static int zeroExtend(byte[] byArray, IEncodedMemoryArea ... iEncodedMemoryAreaArray) {
        int n = 0;
        if (iEncodedMemoryAreaArray == null || iEncodedMemoryAreaArray.length == 0) {
            return n;
        }
        for (IEncodedMemoryArea iEncodedMemoryArea : iEncodedMemoryAreaArray) {
            n = n << iEncodedMemoryArea.getLength() | (int)iEncodedMemoryArea.decode(byArray);
        }
        return n;
    }

    public static long zeroExtend(byte[] byArray, int n, int n2) {
        long l2 = EncodedMemoryAreaUtil.getValue(byArray, n);
        return MathUtil.zeroExtend(l2, n2);
    }

    private static long getValue(byte[] byArray, int n) {
        return EncodedMemoryAreaUtil.getValue(byArray) >>> n;
    }

    private static long getValue(byte[] byArray) {
        if (byArray.length == 2) {
            return EndianUtil.bigEndianBytesToShort(byArray) & 0xFFFFFFFF;
        }
        if (byArray.length == 4) {
            return EndianUtil.bigEndianBytesToInt(byArray) & 0xFFFFFFFF;
        }
        if (byArray.length == 8) {
            return EndianUtil.bigEndianBytesToLong(byArray);
        }
        return 0L;
    }
}

