/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteOrder;
import java.util.Arrays;

@Ser
public class BytesBlock {
    @SerId(value=1)
    private byte[] code;
    @SerId(value=2)
    private boolean isBigEndian;
    @SerId(value=3)
    private int groupSize;

    public BytesBlock(byte[] byArray, Endianness endianness, int n) {
        if (n <= 0 || n % 2 != 0) {
            throw new IllegalArgumentException("Ilegal group size: " + n);
        }
        if (byArray.length % n != 0) {
            throw new IllegalArgumentException("Ilegal block size: " + n);
        }
        this.code = byArray;
        this.isBigEndian = endianness.isBig();
        this.groupSize = n;
    }

    public byte[] getCode() {
        return this.code;
    }

    public byte[] getCode(ByteOrder byteOrder) {
        boolean bl2;
        boolean bl3 = bl2 = byteOrder == ByteOrder.BIG_ENDIAN;
        if (bl2 == this.isBigEndian) {
            return this.code;
        }
        return this.swap();
    }

    public byte[] getBECode() {
        if (this.isBigEndian) {
            return this.code;
        }
        return this.swap();
    }

    public byte[] getLECode() {
        if (!this.isBigEndian) {
            return this.code;
        }
        return this.swap();
    }

    private byte[] swap() {
        byte[] byArray = new byte[this.code.length];
        ArrayUtil.copyBytes(byArray, 0, this.code, 0, this.code.length);
        EndianUtil.swapByGroup(byArray, this.groupSize);
        return byArray;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + Arrays.hashCode(this.code);
        n2 = 31 * n2 + this.groupSize;
        n2 = 31 * n2 + (this.isBigEndian ? 1231 : 1237);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BytesBlock bytesBlock = (BytesBlock)object;
        if (!Arrays.equals(this.code, bytesBlock.code)) {
            return false;
        }
        if (this.groupSize != bytesBlock.groupSize) {
            return false;
        }
        return this.isBigEndian == bytesBlock.isBigEndian;
    }
}

