/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.processor;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.EntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.IMachineContext;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.core.units.code.asm.simulator.ICodeResolver;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorVariant;
import com.pnfsoftware.jeb.util.concurrent.ACLock;
import com.pnfsoftware.jeb.util.concurrent.SafeLockImpl;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

@Ser
public abstract class AbstractProcessor<InsnType extends IInstruction>
implements IProcessor<InsnType> {
    @SerId(value=1)
    private SafeLockImpl lock = new SafeLockImpl();
    @SerId(value=2)
    private int parseCacheLength;
    @SerId(value=3)
    private Endianness endianness;
    @SerId(value=4)
    private int instructionAlignmentMask;
    @SerId(value=5)
    protected Collection<Integer> supportedModes = new HashSet<Integer>();
    @SerId(value=6)
    protected int defaultMode;
    @SerId(value=7)
    protected int mode;
    @SerId(value=8)
    protected Collection<ProcessorVariant> supportedVariants = new ArrayList<ProcessorVariant>();
    @SerId(value=9)
    protected ProcessorVariant variant;
    @SerId(value=10)
    private int parseBufferBefore = 0;

    public AbstractProcessor(int n, int n2, Endianness endianness, int n3) {
        this.parseCacheLength = n;
        this.setDefaultMode(n2);
        this.setEndianness(endianness);
        this.setInstructionAlignment(n3);
    }

    public AbstractProcessor(int n, int n2, IUnitCreator iUnitCreator, int n3) {
        this(n, n2, iUnitCreator, n3, 0);
    }

    public AbstractProcessor(int n, int n2, IUnitCreator iUnitCreator, int n3, int n4) {
        this.parseCacheLength = n;
        this.parseBufferBefore = n4;
        this.setDefaultMode(n2);
        IUnitCreator iUnitCreator2 = iUnitCreator;
        while (iUnitCreator2 != null) {
            if (iUnitCreator instanceof ICodeObjectUnit) {
                this.setEndianness(((ICodeObjectUnit)iUnitCreator2).getLoaderInformation().getEndianness());
                break;
            }
            if (iUnitCreator instanceof INativeCodeUnit) {
                this.setEndianness(((INativeCodeUnit)iUnitCreator2).getEndianness());
                break;
            }
            if (iUnitCreator2 instanceof IUnit) {
                iUnitCreator2 = ((IUnit)iUnitCreator2).getParent();
                continue;
            }
            iUnitCreator2 = null;
        }
        if (this.getEndianness() == null) {
            this.setEndianness(Endianness.LITTLE_ENDIAN);
        }
        this.setInstructionAlignment(n3);
    }

    @Override
    public String getRegisterName(long l2) {
        return null;
    }

    @Override
    public InsnType parseAt(IVirtualMemory iVirtualMemory, long l2) throws ProcessorException {
        try (ACLock aCLock = this.lock.ro();){
            if ((l2 & (long)this.instructionAlignmentMask) != 0L) {
                throw new ProcessorException("Instruction is not aligned");
            }
            int n = this.parseBufferBefore;
            byte[] byArray = new byte[this.parseCacheLength + n];
            int n2 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l2 - (long)n, byArray.length, byArray, 0, 5);
            if (n2 <= 0 && this.parseBufferBefore != 0) {
                n = 0;
                byArray = new byte[this.parseCacheLength];
                n2 = VirtualMemoryUtil.readBytesSafe(iVirtualMemory, l2, byArray.length, byArray, 0, 5);
            }
            if (n2 <= 0) {
                throw new ProcessorException(String.format("Cannot read instruction bytes at address %Xh", l2));
            }
            InsnType InsnType = this.parseAtInternal(byArray, n, n2);
            return InsnType;
        }
    }

    @Override
    public final InsnType parseAt(byte[] byArray, int n, int n2) throws ProcessorException {
        try (ACLock aCLock = this.lock.ro();){
            InsnType InsnType = this.parseAtInternal(byArray, n, n2);
            return InsnType;
        }
    }

    protected abstract InsnType parseAtInternal(byte[] var1, int var2, int var3) throws ProcessorException;

    @Override
    public InsnType parseWithContext(IMachineContext iMachineContext) throws ProcessorException {
        try (ACLock aCLock = this.lock.ro();){
            InsnType InsnType = this.parseWithContextInternal(iMachineContext);
            return InsnType;
        }
    }

    protected InsnType parseWithContextInternal(IMachineContext iMachineContext) throws ProcessorException {
        throw new UnsupportedOperationException("This method is not implemented yet");
    }

    @Override
    public ProcessorType getType() {
        return ProcessorType.UNKNOWN;
    }

    @Override
    public boolean isRISC() {
        return false;
    }

    @Override
    public Collection<ProcessorVariant> getSupportedVariants() {
        return this.supportedVariants;
    }

    @Override
    public ProcessorVariant getVariant() {
        return this.variant;
    }

    @Override
    public void setVariant(ProcessorVariant processorVariant) throws ProcessorException {
        try (ACLock aCLock = this.lock.rw();){
            if (processorVariant != null && !this.supportedVariants.contains(processorVariant)) {
                throw new ProcessorException("Unsupported variant: " + processorVariant);
            }
            this.variant = processorVariant;
        }
    }

    @Override
    public Collection<Integer> getSupportedModes() {
        return this.supportedModes;
    }

    @Override
    public final int getDefaultMode() {
        return this.defaultMode;
    }

    protected final void setDefaultMode(int n) {
        if (n == -1) {
            throw new IllegalArgumentException("Invalid processor mode");
        }
        if (n == 0) {
            throw new IllegalArgumentException("The default processor mode cannot be unknown");
        }
        try (ACLock aCLock = this.lock.rw();){
            if (!this.supportedModes.contains(n)) {
                this.supportedModes.add(n);
            }
            this.defaultMode = n;
            if (this.mode == 0) {
                try {
                    this.setMode(n);
                }
                catch (ProcessorException processorException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public int setMode(int n) throws ProcessorException {
        if (n == -1) {
            throw new IllegalArgumentException("Invalid processor mode");
        }
        try (ACLock aCLock = this.lock.rw();){
            int n2 = this.mode;
            if (n == 0) {
                this.mode = this.defaultMode;
            } else {
                if (!this.supportedModes.contains(n)) {
                    throw new ProcessorException("Unsupported mode: " + n);
                }
                this.mode = n;
            }
            int n3 = n2;
            return n3;
        }
    }

    @Override
    public final int getMode() {
        return this.mode;
    }

    @Override
    public final Endianness getEndianness() {
        return this.endianness;
    }

    @Override
    public final void setEndianness(Endianness endianness) {
        if (endianness == null) {
            throw new NullPointerException("Endianness cannot be null");
        }
        try (ACLock aCLock = this.lock.rw();){
            this.endianness = endianness;
        }
    }

    @Override
    public final int getInstructionAlignment() {
        return this.instructionAlignmentMask + 1;
    }

    @Override
    public final void setInstructionAlignment(int n) {
        try (ACLock aCLock = this.lock.rw();){
            if (n <= 0 || (n & n - 1) != 0) {
                throw new IllegalArgumentException("Invalid instruction alignment: " + n);
            }
            this.instructionAlignmentMask = n - 1;
        }
    }

    @Override
    public ICodeResolver<InsnType> getResolver() {
        return null;
    }

    @Override
    public EntryPointDescription createEntryPoint(long l2) {
        return this.createEntryPoint(l2, 0);
    }

    @Override
    public EntryPointDescription createEntryPoint(long l2, int n) {
        return new EntryPointDescription(l2, n);
    }
}

