/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IMasterOptimizerInstrumenter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerClassId;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerEntry;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.hw;
import com.pnfsoftware.jebglobal.qT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class AbstractMasterOptimizer<T>
implements IMasterOptimizer<T> {
    private static final StructuredLogger logger = qT.eO(AbstractMasterOptimizer.class);
    public static final int MODE_NORMAL = 0;
    public static final int MODE_AGGRESSIVE = 10;
    protected T t;
    protected int currentMode;
    protected SortedMap<Integer, List<OptimizerEntry<T>>> optGrpMap = new TreeMap<Integer, List<OptimizerEntry<T>>>();
    protected List<OptimizerEntry<T>> optList = new ArrayList<OptimizerEntry<T>>();
    protected int grp1NMaxRunCount;
    protected List<IMasterOptimizerInstrumenter<T>> instrumenters = new ArrayList<IMasterOptimizerInstrumenter<T>>();

    public AbstractMasterOptimizer(T t, int n) {
        this.setTarget(t);
        this.grp1NMaxRunCount = n;
    }

    @Override
    public T getTarget() {
        return this.t;
    }

    @Override
    public void setTarget(T t) {
        this.t = t;
    }

    @Override
    public int setMode(int n) {
        int n2 = this.currentMode;
        this.currentMode = n;
        return n2;
    }

    @Override
    public int getMode() {
        return this.currentMode;
    }

    @Override
    public OptimizerEntry<T> registerOptimizer(IOptimizer<T> iOptimizer) {
        return this.registerOptimizer(1, iOptimizer, iOptimizer.getDefaultPriority());
    }

    @Override
    public OptimizerEntry<T> registerOptimizer(int n, IOptimizer<T> iOptimizer) {
        return this.registerOptimizer(n, iOptimizer, iOptimizer.getDefaultPriority());
    }

    @Override
    public OptimizerEntry<T> registerOptimizer(int n, IOptimizer<T> iOptimizer, double d2) {
        if (n < -2) {
            throw new IllegalArgumentException("Illegal group id: " + n);
        }
        if (iOptimizer.getType() == OptimizerType.ON_DEMAND) {
            n = -2;
        }
        ArrayList<OptimizerEntry<T>> arrayList = null;
        for (int j = -2; j <= n; ++j) {
            arrayList = (ArrayList<OptimizerEntry<T>>)this.optGrpMap.get(j);
            if (arrayList != null) continue;
            arrayList = new ArrayList<OptimizerEntry<T>>();
            this.optGrpMap.put(j, arrayList);
        }
        OptimizerEntry<T> optimizerEntry = new OptimizerEntry<T>(n, iOptimizer, d2, n != -2);
        arrayList.add(optimizerEntry);
        Collections.sort(arrayList, new Comparator<OptimizerEntry<T>>(){

            @Override
            public int compare(OptimizerEntry<T> optimizerEntry, OptimizerEntry<T> optimizerEntry2) {
                return Double.compare(optimizerEntry2.priority, optimizerEntry.priority);
            }
        });
        this.optList.add(optimizerEntry);
        return optimizerEntry;
    }

    @Override
    public boolean unregisterOptimizer(OptimizerEntry<T> optimizerEntry) {
        if (!this.optList.remove(optimizerEntry)) {
            return false;
        }
        int n = optimizerEntry.getGroup();
        List list = (List)this.optGrpMap.get(n);
        if (list == null) {
            return false;
        }
        return list.remove(optimizerEntry);
    }

    @Override
    public List<OptimizerEntry<T>> getRegisteredOptimizers() {
        return new ArrayList<OptimizerEntry<T>>(this.optList);
    }

    @Override
    public List<OptimizerEntry<T>> getRegisteredOptimizers(int n) {
        ArrayList<OptimizerEntry<T>> arrayList = new ArrayList<OptimizerEntry<T>>();
        List list = (List)this.optGrpMap.get(n);
        if (list != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public OptimizerEntry<T> getOptimizer(Class<? extends IOptimizer<T>> clazz) {
        for (OptimizerEntry<T> optimizerEntry : this.getRegisteredOptimizers()) {
            if (!clazz.isInstance(optimizerEntry.getOptimizer())) continue;
            return optimizerEntry;
        }
        return null;
    }

    public IOptimizer<T> getOptimizerObject(Class<? extends IOptimizer<T>> clazz) {
        OptimizerEntry<T> optimizerEntry = this.getOptimizer(clazz);
        return optimizerEntry == null ? null : optimizerEntry.getOptimizer();
    }

    @Override
    public int perform() {
        return this.perform(0);
    }

    public int perform(int n) {
        int n2;
        int n3 = 0;
        logger.i("%s===> Optimizing(%d)", Strings.generate(' ', 4 * n), n);
        T t = this.getTarget();
        this.preAllOptimizationsCallback(t);
        List list = (List)this.optGrpMap.get(0);
        if (list != null) {
            n3 += this.performMultiple(list, n);
        }
        int n4 = n2 = this.grp1NMaxRunCount >= 0 ? this.grp1NMaxRunCount : Integer.MAX_VALUE;
        int n5 = 1;
        while (n4-- > 0 && (list = (List)this.optGrpMap.get(n5)) != null) {
            int n6 = this.performMultiple(list, n);
            n3 += n6;
            if (n6 > 0) {
                n5 = 1;
                continue;
            }
            ++n5;
        }
        if (n4 < 0) {
            logger.debug("opti runcount: exhausted", new Object[0]);
            this.reportMaxOptiRunCountReached(t);
        }
        if ((list = (List)this.optGrpMap.get(-1)) != null) {
            this.performMultiple(list, n);
        }
        this.postAllOptimizationsCallback(t);
        return n3;
    }

    private void reportMaxOptiRunCountReached(T t) {
    }

    public int performMultiple(List<OptimizerEntry<T>> list) {
        return this.performMultiple(list, 0);
    }

    private int performMultiple(List<OptimizerEntry<T>> list, int n) {
        int n2 = 0;
        for (OptimizerEntry<T> optimizerEntry : list) {
            n2 += this.performSingle(optimizerEntry, n);
        }
        return n2;
    }

    public int performSingle(OptimizerEntry<T> optimizerEntry) {
        return this.performSingle(optimizerEntry, 0);
    }

    private int performSingle(OptimizerEntry<T> optimizerEntry, int n) {
        if (!optimizerEntry.isEnabled()) {
            return 0;
        }
        IOptimizer<T> iOptimizer = optimizerEntry.getOptimizer();
        if (iOptimizer.getRequiredModeThreshold() > this.getMode()) {
            return 0;
        }
        T t = this.getTarget();
        T t2 = iOptimizer.setTarget(t);
        this.preOptimizationCallback(t, optimizerEntry);
        long l2 = System.nanoTime();
        int n2 = iOptimizer.perform();
        if (n2 > 0 && n == 0) {
            List list;
            int n3 = iOptimizer.getPostProcessingAction();
            if (n3 == 1) {
                this.perform(n + 1);
            } else if (n3 == 2 && (list = OptUtil.getOptimizersByClassId(this, OptimizerClassId.DEAD_CODE_REMOVAL)) != null) {
                this.performMultiple(list, n + 1);
            }
        }
        long l3 = (System.nanoTime() - l2) / 1000000L;
        this.postOptimizationCallback(t, optimizerEntry, n2, l3);
        if (t != t2) {
            iOptimizer.setTarget(t2);
        }
        ++optimizerEntry.stat.runcnt;
        optimizerEntry.stat.optcnt += n2;
        optimizerEntry.stat.runtimeMs += l3;
        hw.eO();
        return n2;
    }

    protected void preAllOptimizationsCallback(T t) {
        for (IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter : this.instrumenters) {
            iMasterOptimizerInstrumenter.preAllOptimizationsCallback(t);
        }
    }

    protected void preOptimizationCallback(T t, OptimizerEntry<T> optimizerEntry) {
        for (IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter : this.instrumenters) {
            iMasterOptimizerInstrumenter.preOptimizationCallback(t, optimizerEntry);
        }
    }

    protected void postAllOptimizationsCallback(T t) {
        for (IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter : this.instrumenters) {
            iMasterOptimizerInstrumenter.postAllOptimizationsCallback(t);
        }
    }

    protected void postOptimizationCallback(T t, OptimizerEntry<T> optimizerEntry, int n, long l2) {
        for (IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter : this.instrumenters) {
            iMasterOptimizerInstrumenter.postOptimizationCallback(t, optimizerEntry, n, l2);
        }
    }

    @Override
    public void registerInstrumenter(IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter) {
        this.instrumenters.add(iMasterOptimizerInstrumenter);
    }

    @Override
    public boolean unregisterInstrumenter(IMasterOptimizerInstrumenter<T> iMasterOptimizerInstrumenter) {
        return this.instrumenters.remove(iMasterOptimizerInstrumenter);
    }
}

