/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.INode;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.Leaf;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.Node;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.comp.O;
import java.util.Map;

public class EExpressionGenerator {
    IERoutineContext ctx;
    INode template;
    Map<Integer, Object> map;

    public EExpressionGenerator(IERoutineContext iERoutineContext, INode iNode) {
        if (iERoutineContext == null || iNode == null) {
            throw new IllegalArgumentException();
        }
        this.ctx = iERoutineContext;
        this.template = iNode;
    }

    public IEGeneric generate(Map<Integer, Object> map) {
        try {
            this.map = map;
            IEGeneric iEGeneric = this.generate(this.template);
            return iEGeneric;
        }
        finally {
            this.map = null;
        }
    }

    private IEGeneric generate(INode iNode) {
        if (iNode instanceof Node) {
            int n;
            Node node = (Node)iNode;
            O o = node.operator;
            if (o == null && (o = (O)((Object)this.map.get(n = 1000 + node.opgrp.id))) == null) {
                return null;
            }
            switch (o) {
                case SLICE: {
                    IEGeneric iEGeneric = this.generate(node.opnds[0]);
                    int n2 = ((Leaf)node.opnds[1]).value.intValue();
                    int n3 = ((Leaf)node.opnds[2]).value.intValue();
                    return iEGeneric.slice(n2, n3);
                }
                case SLICE_FIRSTBIT: {
                    IEGeneric iEGeneric = this.generate(node.opnds[0]);
                    return iEGeneric.lsb();
                }
                case SLICE_LASTBIT: {
                    IEGeneric iEGeneric = this.generate(node.opnds[0]);
                    return iEGeneric.msb();
                }
                case SLICE_FIRST32: {
                    IEGeneric iEGeneric = this.generate(node.opnds[0]);
                    return iEGeneric.part(32);
                }
                case SLICE_HALF1: {
                    IEGeneric iEGeneric = this.generate(node.opnds[0]);
                    return iEGeneric.part(iEGeneric.getBitsize() / 2);
                }
                case SLICE_HALF2: {
                    IEGeneric iEGeneric = this.generate(node.opnds[0]);
                    return iEGeneric.slice(iEGeneric.getBitsize() / 2, iEGeneric.getBitsize());
                }
                case COMPOSE_2: {
                    IEGeneric iEGeneric = this.generate(node.opnds[0]);
                    IEGeneric iEGeneric2 = this.generate(node.opnds[1]);
                    return this.ctx.createCompose(iEGeneric, iEGeneric2);
                }
                case COMPOSE_2EQ: {
                    IEGeneric iEGeneric = this.generate(node.opnds[0]);
                    IEGeneric iEGeneric3 = this.generate(node.opnds[1]);
                    if (iEGeneric.getBitsize() != iEGeneric3.getBitsize()) {
                        throw new RuntimeException();
                    }
                    return this.ctx.createCompose(iEGeneric, iEGeneric3);
                }
                case COND: {
                    IEGeneric iEGeneric = this.generate(node.opnds[0]);
                    IEGeneric iEGeneric4 = this.generate(node.opnds[1]);
                    IEGeneric iEGeneric5 = this.generate(node.opnds[2]);
                    return this.ctx.createCond(iEGeneric, iEGeneric4, iEGeneric5);
                }
            }
            OperationType operationType = o.getOperationType();
            if (operationType == null) {
                return null;
            }
            IEGeneric[] iEGenericArray = new IEGeneric[3];
            int n4 = 0;
            for (INode iNode2 : node.opnds) {
                if (n4 >= iEGenericArray.length) {
                    return null;
                }
                IEGeneric iEGeneric = this.generate(iNode2);
                if (iEGeneric == null) {
                    return null;
                }
                iEGenericArray[n4] = iEGeneric;
                ++n4;
            }
            return this.ctx.createOperation(operationType, iEGenericArray[0], iEGenericArray[1]);
        }
        Leaf leaf = (Leaf)iNode;
        IEGeneric iEGeneric = (IEGeneric)this.map.get(leaf.id);
        if (iEGeneric == null) {
            throw new RuntimeException(String.format("Expression not found (leaf_id=%d). Are you using LC() in a substituter? \"Very sad!\" (c) DJT", leaf.id));
        }
        if (leaf.flags == 16 && !(iEGeneric instanceof IEImm)) {
            int n = iEGeneric.getBitsize();
            if (leaf.optionalBitsize != 0 || n == 0) {
                throw new RuntimeException("Illegal bitsize values");
            }
            iEGeneric = this.ctx.createImm(leaf.value.longValue(), n);
        }
        return iEGeneric;
    }
}

