/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.DecompilerUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IEConverter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IVisitResults;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.EvaluationException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EVisitResults;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECompose;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECond;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEJump;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEJumpFar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEMem;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IENop;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESlice;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEUntranslatedInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVisitor;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IdRanges;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jebglobal.It;
import com.pnfsoftware.jebglobal.Yk;
import com.pnfsoftware.jebglobal.jB;
import com.pnfsoftware.jebglobal.kz;
import com.pnfsoftware.jebglobal.qT;
import com.pnfsoftware.jebglobal.tA;
import com.pnfsoftware.jebglobal.xi;
import com.pnfsoftware.jebglobal.yq;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EUtil {
    private static final StructuredLogger logger = qT.eO(EUtil.class);

    public static void loglist(List<? extends IEStatement> list) {
        int n = 0;
        for (IEStatement iEStatement : list) {
            logger.i("%04X : %s", n, iEStatement.format(null));
            ++n;
        }
    }

    public static String formatIRCFGWithContext(int n, CFG<IEStatement> cFG, IERoutineContext iERoutineContext) {
        return DecompilerUtil.formatIRCFGWithContext(n, cFG, iERoutineContext);
    }

    public static IEImm createImm(long l2, int n) {
        return jB.eO(l2, n);
    }

    public static IEImm createImm(byte[] byArray, int n) {
        return jB.eO(byArray, n);
    }

    public static IEGeneric compose(IEGeneric ... iEGenericArray) {
        if (iEGenericArray.length == 1) {
            return iEGenericArray[0];
        }
        return new yq(tA.eO(iEGenericArray));
    }

    public static IEGeneric compose(Collection<IEGeneric> collection) {
        return EUtil.compose(collection.toArray(new IEGeneric[collection.size()]));
    }

    public static IEGeneric checkTrue(IEGeneric iEGeneric) {
        if (iEGeneric.getBitsize() == 1) {
            return iEGeneric;
        }
        return new Yk(OperationType.LOG_NEQ, (kz)iEGeneric, jB.eO(0L, iEGeneric.getBitsize()));
    }

    public static IEGeneric checkFalse(IEGeneric iEGeneric) {
        if (iEGeneric.getBitsize() == 1) {
            return new Yk(OperationType.LOG_NOT, (kz)iEGeneric);
        }
        return new Yk(OperationType.LOG_EQ, (kz)iEGeneric, jB.eO(0L, iEGeneric.getBitsize()));
    }

    public static boolean isOperation(IEGeneric iEGeneric, OperationType operationType) {
        return iEGeneric instanceof IEOperation && ((IEOperation)iEGeneric).getOperationType() == operationType;
    }

    public static boolean isOperation(IEGeneric iEGeneric, OperationType ... operationTypeArray) {
        return EUtil.getOperation(iEGeneric, operationTypeArray) != null;
    }

    public static boolean isLogicalOperation(IEGeneric iEGeneric) {
        if (!(iEGeneric instanceof IEOperation)) {
            return false;
        }
        return EUtil.isStrictLogicalOperation((IEOperation)iEGeneric) || EUtil.isComparableOperation((IEOperation)iEGeneric);
    }

    public static boolean isComparableOperation(IEGeneric iEGeneric) {
        if (!(iEGeneric instanceof IEOperation)) {
            return false;
        }
        return EUtil.isComparableOperation((IEOperation)iEGeneric);
    }

    public static boolean isComparableOperation(IEOperation iEOperation) {
        return EUtil.isComparableOperation(iEOperation, true);
    }

    public static boolean isComparableSignedOperation(IEOperation iEOperation) {
        return EUtil.isComparableOperation(iEOperation, false);
    }

    public static boolean isComparableOperation(IEOperation iEOperation, boolean bl2) {
        OperationType operationType = iEOperation.getOperationType();
        switch (operationType) {
            case LOG_EQ: 
            case LOG_NEQ: 
            case GE_S: 
            case GT_S: 
            case LE_S: 
            case LT_S: {
                return true;
            }
            case GE_U: 
            case GT_U: 
            case LE_U: 
            case LT_U: {
                return bl2;
            }
        }
        return false;
    }

    public static boolean isStrictLogicalOperation(IEGeneric iEGeneric) {
        if (!(iEGeneric instanceof IEOperation)) {
            return false;
        }
        return EUtil.isStrictLogicalOperation((IEOperation)iEGeneric);
    }

    public static boolean isStrictLogicalOperation(IEOperation iEOperation) {
        OperationType operationType = iEOperation.getOperationType();
        return operationType == OperationType.LOG_AND || operationType == OperationType.LOG_NOT || operationType == OperationType.LOG_OR;
    }

    public static OperationType getOperation(IEGeneric iEGeneric, OperationType ... operationTypeArray) {
        return iEGeneric instanceof IEOperation ? EUtil.getOperation((IEOperation)iEGeneric, operationTypeArray) : null;
    }

    public static OperationType getOperation(IEOperation iEOperation, OperationType ... operationTypeArray) {
        OperationType operationType = iEOperation.getOperationType();
        for (OperationType operationType2 : operationTypeArray) {
            if (operationType2 != operationType) continue;
            return operationType;
        }
        return null;
    }

    public static boolean isOperationSize(IEGeneric iEGeneric, int n) {
        return iEGeneric instanceof IEOperation && ((IEOperation)iEGeneric).getBitsize() == n;
    }

    public static OperationType getReverseOperation(OperationType operationType) {
        if (operationType == null) {
            return null;
        }
        switch (operationType) {
            case LOG_EQ: {
                return OperationType.LOG_NEQ;
            }
            case LOG_NEQ: {
                return OperationType.LOG_EQ;
            }
            case GE_S: {
                return OperationType.LT_S;
            }
            case GE_U: {
                return OperationType.LT_U;
            }
            case GT_S: {
                return OperationType.LE_S;
            }
            case GT_U: {
                return OperationType.LE_U;
            }
            case LE_S: {
                return OperationType.GT_S;
            }
            case LE_U: {
                return OperationType.GT_U;
            }
            case LT_S: {
                return OperationType.GE_S;
            }
            case LT_U: {
                return OperationType.GE_U;
            }
        }
        return null;
    }

    public static OperationType getMirrorOperation(OperationType operationType) {
        if (operationType == null) {
            return null;
        }
        switch (operationType) {
            case GE_S: {
                return OperationType.LE_S;
            }
            case GE_U: {
                return OperationType.LE_U;
            }
            case GT_S: {
                return OperationType.LT_S;
            }
            case GT_U: {
                return OperationType.LT_U;
            }
            case LE_S: {
                return OperationType.GE_S;
            }
            case LE_U: {
                return OperationType.GE_U;
            }
            case LT_S: {
                return OperationType.GT_S;
            }
            case LT_U: {
                return OperationType.GT_U;
            }
            case LOG_EQ: {
                return OperationType.LOG_EQ;
            }
            case LOG_NEQ: {
                return OperationType.LOG_NEQ;
            }
        }
        return null;
    }

    public static boolean isZero(IEGeneric iEGeneric) {
        return EUtil.isImmValue(iEGeneric, BigInteger.ZERO) || iEGeneric instanceof IESlice && EUtil.isImmValue(((IESlice)iEGeneric).getWholeExpression(), BigInteger.ZERO);
    }

    public static boolean isOne(IEGeneric iEGeneric) {
        return EUtil.isImmValue(iEGeneric, BigInteger.ONE);
    }

    public static boolean isImmSize(IEGeneric iEGeneric, int n) {
        return iEGeneric instanceof IEImm && ((IEImm)iEGeneric).getBitsize() == n;
    }

    public static boolean isImmValue(IEGeneric iEGeneric, long l2) {
        return EUtil.isImmValue(iEGeneric, BigInteger.valueOf(l2));
    }

    public static boolean isImmValue(IEGeneric iEGeneric, BigInteger bigInteger) {
        return iEGeneric instanceof IEImm && ((IEImm)iEGeneric).getValue().equals(bigInteger);
    }

    public static boolean isImmZero(IEGeneric iEGeneric) {
        return iEGeneric instanceof jB && ((jB)iEGeneric)._signum() == 0;
    }

    public static boolean isCondEAssign(IEGeneric iEGeneric) {
        return iEGeneric instanceof IEAssign && ((IEAssign)iEGeneric).getSrcOperand() instanceof IECond;
    }

    public static boolean isJump(IEGeneric iEGeneric) {
        return iEGeneric instanceof IEJump;
    }

    public static boolean isUnconditionalJump(IEGeneric iEGeneric) {
        return iEGeneric instanceof IEJump && ((IEJump)iEGeneric).getCondition() == null;
    }

    public static boolean isCondEJump(IEGeneric iEGeneric) {
        return iEGeneric instanceof IEJump && ((IEJump)iEGeneric).getCondition() != null;
    }

    public static void makeUncond(IEJump iEJump) {
        if (EUtil.containsUndeterminedInvocations(iEJump.getCondition())) {
            throw new RuntimeException("Tried to remove a EJump condition containing undetermined calls");
        }
        iEJump.setCondition(null);
    }

    public static boolean isAssignedIn(BasicBlock<IEStatement> basicBlock, IEGeneric iEGeneric) {
        boolean bl2 = false;
        for (IEStatement iEStatement : basicBlock) {
            if (!(iEStatement instanceof IEAssign) || !iEGeneric.equals(((IEAssign)iEStatement).getLeftOperand())) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public static void addIfVar(List<IEVar> list, IEGeneric iEGeneric) {
        if (iEGeneric instanceof IEVar) {
            list.add((IEVar)iEGeneric);
        }
    }

    public static boolean isRegister(IEGeneric iEGeneric, int n) {
        return iEGeneric instanceof IEVar && ((IEVar)iEGeneric).getId() == n;
    }

    public static List<IEGeneric> getSubExpressions(IEGeneric iEGeneric) {
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.getSubExpressions(arrayList);
        return arrayList;
    }

    public static int countSubExpressions(IEGeneric iEGeneric) {
        return EUtil.getSubExpressions(iEGeneric).size();
    }

    public static int sameBitsize(IEGeneric ... iEGenericArray) {
        int n = 0;
        for (IEGeneric iEGeneric : iEGenericArray) {
            if (iEGeneric == null) {
                return 0;
            }
            if (n == 0) {
                n = iEGeneric.getBitsize();
                continue;
            }
            if (n == iEGeneric.getBitsize()) continue;
            return 0;
        }
        return n;
    }

    public static int sameBitsizeAllowNulls(IEGeneric ... iEGenericArray) {
        int n = 0;
        for (IEGeneric iEGeneric : iEGenericArray) {
            if (iEGeneric == null) continue;
            if (n == 0) {
                n = iEGeneric.getBitsize();
                continue;
            }
            if (n == iEGeneric.getBitsize()) continue;
            return 0;
        }
        return n;
    }

    public static int countVariableUse(IEGeneric iEGeneric) {
        IdRanges idRanges = new IdRanges();
        iEGeneric.getUsed(idRanges);
        return idRanges.size();
    }

    public static int countVariablePresence(IEGeneric iEGeneric, IEVar iEVar) {
        if (iEGeneric == iEVar) {
            return 1;
        }
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.getSubExpressions(arrayList);
        int n = 0;
        for (IEGeneric iEGeneric2 : arrayList) {
            n += EUtil.countVariablePresence(iEGeneric2, iEVar);
        }
        return n;
    }

    public static void countExpressionsPresence(IEGeneric iEGeneric, List<IEGeneric> list, int[] nArray) {
        for (int j = 0; j < list.size(); ++j) {
            if (!list.get(j).equals(iEGeneric)) continue;
            int n = j;
            nArray[n] = nArray[n] + 1;
        }
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.getSubExpressions(arrayList);
        for (IEGeneric iEGeneric2 : arrayList) {
            EUtil.countExpressionsPresence(iEGeneric2, list, nArray);
        }
    }

    public static Set<Integer> getUsedVarIds(IEGeneric iEGeneric) {
        IdRanges idRanges = new IdRanges();
        iEGeneric.getUsed(idRanges);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        idRanges.collectVarIds(hashSet);
        return hashSet;
    }

    public static Set<IEVar> collectVars(IEGeneric iEGeneric) {
        HashSet<IEVar> hashSet = new HashSet<IEVar>();
        EUtil.collectVars(iEGeneric, hashSet);
        return hashSet;
    }

    public static void collectVars(IEGeneric iEGeneric, Set<IEVar> set) {
        if (iEGeneric instanceof IEVar) {
            set.add((IEVar)iEGeneric);
            return;
        }
        ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
        iEGeneric.getSubExpressions(arrayList);
        for (IEGeneric iEGeneric2 : arrayList) {
            EUtil.collectVars(iEGeneric2, set);
        }
    }

    public static boolean hasExplicitlyUsedVar(IEGeneric iEGeneric, IEVar iEVar) {
        IdRanges idRanges = new IdRanges();
        iEGeneric.getExplicitlyUsed(idRanges);
        return idRanges.containsVarPart(iEVar);
    }

    public static boolean isTrampoline(BasicBlock<IEStatement> basicBlock) {
        if (basicBlock.outsize() != 1) {
            return false;
        }
        for (int j = 0; j < basicBlock.size() - 1; ++j) {
            if (basicBlock.get(j) instanceof IENop) continue;
            return false;
        }
        AddressableInstruction<IEStatement> addressableInstruction = basicBlock.getLast2();
        return addressableInstruction.getBreakingFlow().isBroken() || addressableInstruction.getInstruction() instanceof IENop;
    }

    public static IEGeneric reversePredicate(IEGeneric iEGeneric) {
        return new Yk(OperationType.LOG_NOT, (kz)iEGeneric);
    }

    public static boolean containsUndeterminedInvocations(IEGeneric iEGeneric) {
        return !iEGeneric.visitDepthPre(new IEVisitor(){

            @Override
            public void process(IEGeneric iEGeneric, IEGeneric iEGeneric2, IVisitResults<IEGeneric> iVisitResults) {
                if (iEGeneric instanceof IECall || iEGeneric instanceof IEJumpFar) {
                    iVisitResults.interrupt(false);
                }
            }
        });
    }

    public static IEOperation buildStrictLogicalOperation(IEOperation iEOperation) {
        if (!EUtil.isStrictLogicalOperation(iEOperation)) {
            return iEOperation;
        }
        return EUtil.buildLogicalOperation(iEOperation);
    }

    public static IEOperation buildLogicalOperation(IEOperation iEOperation) {
        boolean bl2 = false;
        IEGeneric iEGeneric = iEOperation.getOperand1();
        IEGeneric iEGeneric2 = iEOperation.getOperand2();
        if (!EUtil.isLogicalOperation(iEGeneric)) {
            iEGeneric = EUtil.ne(iEGeneric, jB.eO(0L, iEGeneric.getBitsize()));
            bl2 = true;
        }
        if (iEGeneric2 != null && !EUtil.isLogicalOperation(iEGeneric2)) {
            iEGeneric2 = EUtil.ne(iEGeneric2, jB.eO(0L, iEGeneric2.getBitsize()));
            bl2 = true;
        }
        if (bl2) {
            return new Yk(iEOperation.getOperationType(), (kz)iEGeneric, (kz)iEGeneric2);
        }
        return iEOperation;
    }

    public static IECond buildStrictLogicalECond(IECond iECond) {
        IEGeneric iEGeneric = iECond.getPredicate();
        if (!EUtil.isLogicalOperation(iEGeneric)) {
            return new It((kz)((Object)EUtil.ne(iEGeneric, jB.eO(0L, iEGeneric.getBitsize()))), (kz)iECond.getExpressionTrue(), (kz)iECond.getExpressionFalse());
        }
        return iECond;
    }

    public static IEOperation ltS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.LT_S, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation leS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.LE_S, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation gtS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.GT_S, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation geS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.GE_S, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation ltU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.LT_U, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation leU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.LE_U, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation gtU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.GT_U, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation geU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.GE_U, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation eq(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.LOG_EQ, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation ne(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.LOG_NEQ, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation andL(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.LOG_AND, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation orL(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.LOG_OR, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEGeneric notL(IEGeneric iEGeneric) {
        if (iEGeneric instanceof IEOperation && ((IEOperation)iEGeneric).getOperationType() == OperationType.LOG_NOT) {
            return ((IEOperation)iEGeneric).getOperand1();
        }
        return new Yk(OperationType.LOG_NOT, tA.eO(iEGeneric));
    }

    public static IEOperation andB(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.AND, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation orB(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.OR, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation xorB(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.XOR, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEGeneric notB(IEGeneric iEGeneric) {
        if (iEGeneric instanceof IEOperation && ((IEOperation)iEGeneric).getOperationType() == OperationType.NOT) {
            return ((IEOperation)iEGeneric).getOperand1();
        }
        return new Yk(OperationType.NOT, tA.eO(iEGeneric));
    }

    public static IEOperation add(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.ADD, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation add(IEGeneric iEGeneric, IEGeneric iEGeneric2, IEGeneric iEGeneric3) {
        return EUtil.add(EUtil.add(tA.eO(iEGeneric), tA.eO(iEGeneric2)), iEGeneric3);
    }

    public static IEOperation sub(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.SUB, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation mul(IEGeneric iEGeneric, IEGeneric iEGeneric2, boolean bl2) {
        return bl2 ? EUtil.mulS(iEGeneric, iEGeneric2) : EUtil.mulU(iEGeneric, iEGeneric2);
    }

    public static IEOperation mulS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.MUL_S, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation mulU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.MUL_U, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation div(IEGeneric iEGeneric, IEGeneric iEGeneric2, boolean bl2) {
        return bl2 ? EUtil.divS(iEGeneric, iEGeneric2) : EUtil.divU(iEGeneric, iEGeneric2);
    }

    public static IEOperation divS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.DIV_S, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation divU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.DIV_U, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation remS(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.REM_S, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation remU(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.REM_U, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation shl(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.SHL, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation shr(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.SHR, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation sar(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.SAR, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEOperation pow(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return new Yk(OperationType.POW, tA.eO(iEGeneric), tA.eO(iEGeneric2));
    }

    public static IEGeneric extend(IEGeneric iEGeneric, int n, boolean bl2) {
        if (iEGeneric == null) {
            return null;
        }
        return bl2 ? iEGeneric.signExtend(n) : iEGeneric.zeroExtend(n);
    }

    public static IEGeneric safeExtend(IEGeneric iEGeneric, int n, boolean bl2) {
        if (iEGeneric == null) {
            return null;
        }
        if (n < iEGeneric.getBitsize()) {
            return iEGeneric.part(n);
        }
        return bl2 ? iEGeneric.signExtend(n) : iEGeneric.zeroExtend(n);
    }

    public static boolean isNotPredicate(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        if (iEGeneric instanceof IEOperation && iEGeneric2 instanceof IEOperation) {
            IEOperation iEOperation = (IEOperation)iEGeneric;
            IEOperation iEOperation2 = (IEOperation)iEGeneric2;
            OperationType operationType = iEOperation.getOperationType();
            OperationType operationType2 = EUtil.getReverseOperation(operationType);
            if (operationType2 == null) {
                return false;
            }
            if (operationType2 == iEOperation2.getOperationType() && iEOperation.getOperand1().equals(iEOperation2.getOperand1()) && iEOperation.getOperand2().equals(iEOperation2.getOperand2())) {
                return true;
            }
            if ((operationType2 = EUtil.getMirrorOperation(operationType2)) != null && operationType2 == iEOperation2.getOperationType() && iEOperation.getOperand1().equals(iEOperation2.getOperand2()) && iEOperation.getOperand2().equals(iEOperation2.getOperand1())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isFirstBit(IESlice iESlice) {
        return iESlice.getBitsize() == 1 && iESlice.getBitStart() == 0;
    }

    public static boolean isLastBit(IESlice iESlice) {
        return iESlice.getBitsize() == 1 && iESlice.getBitEnd() == iESlice.getWholeExpression().getBitsize();
    }

    public static boolean isNBit(IESlice iESlice, int n) {
        return iESlice.getBitsize() == 1 && iESlice.getBitStart() == n;
    }

    private static int getExponentSize(int n) {
        switch (n) {
            case 16: {
                return 5;
            }
            case 32: {
                return 8;
            }
            case 64: {
                return 11;
            }
            case 128: {
                return 15;
            }
            case 256: {
                return 19;
            }
        }
        throw new RuntimeException("Illegal Bitsize for float: " + n);
    }

    public static IEGeneric isNaN(IEGeneric iEGeneric) {
        int n = EUtil.getExponentSize(iEGeneric.getBitsize());
        int n2 = iEGeneric.getBitsize() - n - 1;
        return EUtil.andL(EUtil.eq(iEGeneric.slice(n2, n2 + n), jB.eO(MathUtil.makeMask(n), n)), EUtil.ne(iEGeneric.part(n2), jB.eO(0L, n2)));
    }

    public static IEGeneric ltFloat(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.andL(EUtil.andL(EUtil.notL(EUtil.isNaN(iEGeneric)), EUtil.notL(EUtil.isNaN(iEGeneric2))), EUtil.ltS(iEGeneric, iEGeneric2));
    }

    public static IEGeneric gtFloat(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.andL(EUtil.andL(EUtil.notL(EUtil.isNaN(iEGeneric)), EUtil.notL(EUtil.isNaN(iEGeneric2))), EUtil.gtS(iEGeneric, iEGeneric2));
    }

    public static IEGeneric eqFloat(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        return EUtil.andL(EUtil.andL(EUtil.notL(EUtil.isNaN(iEGeneric)), EUtil.notL(EUtil.isNaN(iEGeneric2))), EUtil.eq(iEGeneric.part(iEGeneric.getBitsize() - 1), iEGeneric2.part(iEGeneric2.getBitsize() - 1)));
    }

    public static IEImm one(int n) {
        return jB.eO(1L, n);
    }

    public static IEImm zero(int n) {
        return jB.eO(0L, n);
    }

    public static IEImm ones(int n) {
        return jB.eO(-1L, n);
    }

    public static IEOperation makeCast(IEGeneric iEGeneric, int n, boolean bl2) {
        return Yk.eO((kz)iEGeneric, n, bl2);
    }

    public static boolean looksLikeSignExtension(IECompose iECompose) {
        return EUtil.getSignExtensionBase(iECompose) != null;
    }

    public static IEGeneric getSignExtensionBase(IEGeneric iEGeneric) {
        return iEGeneric instanceof IECompose ? EUtil.getSignExtensionBase((IECompose)iEGeneric) : null;
    }

    public static IEGeneric getSignExtensionBase(IECompose iECompose) {
        List<IEGeneric> list = iECompose.getParts();
        return list.size() == 2 ? EUtil.getSignExtensionBase(list.get(0), list.get(1)) : null;
    }

    public static IEGeneric getSignExtensionBase(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        if (iEGeneric2 instanceof IECond) {
            IEGeneric iEGeneric3 = ((IECond)iEGeneric2).getPredicate();
            IEGeneric iEGeneric4 = ((IECond)iEGeneric2).getExpressionTrue();
            IEGeneric iEGeneric5 = ((IECond)iEGeneric2).getExpressionFalse();
            if (EUtil.isImmValue(iEGeneric4, -1L) && EUtil.isImmValue(iEGeneric5, 0L) && iEGeneric3 instanceof IESlice && EUtil.isNBit((IESlice)iEGeneric3, iEGeneric.getBitsize() - 1) && EUtil.isWholeExpressionOf((IESlice)iEGeneric3, iEGeneric)) {
                return iEGeneric;
            }
        }
        return null;
    }

    private static boolean isWholeExpressionOf(IESlice iESlice, IEGeneric iEGeneric) {
        if (iESlice.getWholeExpression().equals(iEGeneric)) {
            return true;
        }
        if (iEGeneric instanceof IESlice) {
            IESlice iESlice2 = (IESlice)iEGeneric;
            return iESlice2.getBitStart() == 0 && iESlice.getWholeExpression().equals(iESlice2.getWholeExpression());
        }
        return false;
    }

    public static boolean isZeroExtend(IECompose iECompose) {
        return iECompose.getPartsCount() == 2 && EUtil.isZero(iECompose.getPart(1));
    }

    public static IEGeneric buildCarryFlag(IEGeneric iEGeneric, IEGeneric iEGeneric2, IEGeneric iEGeneric3, boolean bl2, boolean bl3) {
        if (bl3) {
            if (bl2) {
                return new Yk(OperationType.CARRY, tA.eO(iEGeneric), tA.eO(iEGeneric2));
            }
            return EUtil.ltU(iEGeneric, iEGeneric2);
        }
        IEOperation iEOperation = EUtil.xorB(EUtil.xorB(iEGeneric.duplicate(), iEGeneric2.duplicate()), iEGeneric3.duplicate());
        IEOperation iEOperation2 = EUtil.xorB(iEGeneric.duplicate(), iEGeneric3.duplicate());
        IEGeneric iEGeneric4 = bl2 ? EUtil.notB(EUtil.xorB(iEGeneric.duplicate(), iEGeneric2.duplicate())) : EUtil.xorB(iEGeneric.duplicate(), iEGeneric2.duplicate());
        IEOperation iEOperation3 = EUtil.xorB(iEOperation, EUtil.andB(iEOperation2, iEGeneric4));
        return iEOperation3.msb();
    }

    public static IEGeneric buildOverflowFlag(IEGeneric iEGeneric, IEGeneric iEGeneric2, IEGeneric iEGeneric3, boolean bl2) {
        IEOperation iEOperation = EUtil.xorB(iEGeneric.duplicate(), iEGeneric3.duplicate());
        IEGeneric iEGeneric4 = bl2 ? EUtil.notB(EUtil.xorB(iEGeneric.duplicate(), iEGeneric2.duplicate())) : EUtil.xorB(iEGeneric.duplicate(), iEGeneric2.duplicate());
        IEOperation iEOperation2 = EUtil.andB(iEOperation, iEGeneric4);
        return iEOperation2.msb();
    }

    public static boolean areAlmostImmediates(Collection<IEGeneric> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        for (IEGeneric iEGeneric : collection) {
            if (EUtil.isAlmostImmediate(iEGeneric)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlmostImmediate(IEGeneric iEGeneric) {
        return jB.eO(iEGeneric) || EUtil.isEComposeImm(iEGeneric) || EUtil.isESliceImm(iEGeneric);
    }

    private static boolean isESliceImm(IEGeneric iEGeneric) {
        return iEGeneric instanceof xi && EUtil.isAlmostImmediate(((xi)iEGeneric).eO());
    }

    private static boolean isEComposeImm(IEGeneric iEGeneric) {
        return iEGeneric instanceof yq && EUtil.areAlmostImmediates(((yq)iEGeneric).getParts());
    }

    public static IEImm evaluate_preVerified(IEGeneric iEGeneric, IEState iEState) {
        try {
            return iEGeneric.evaluate(iEState);
        }
        catch (Exception exception) {
            throw new EvaluationException("Unexpected evaluate() error", exception);
        }
    }

    public static IEImm evaluate_preVerified(IEGeneric iEGeneric) {
        return EUtil.evaluate_preVerified(iEGeneric, null);
    }

    public static long evaluateUnsignedLong_preVerified(IEGeneric iEGeneric, IEState iEState) {
        try {
            return iEGeneric.evaluate(iEState).getValueAsUnsignedLong();
        }
        catch (Exception exception) {
            throw new EvaluationException("Unexpected evaluate() error", exception);
        }
    }

    public static long evaluateUnsignedLong_preVerified(IEGeneric iEGeneric) {
        return EUtil.evaluateUnsignedLong_preVerified(iEGeneric, null);
    }

    public static long evaluateAddress_preVerified(IEGeneric iEGeneric, IEState iEState) {
        try {
            return iEGeneric.evaluate(iEState).getValueAsAddress();
        }
        catch (Exception exception) {
            throw new EvaluationException("Unexpected evaluate() error", exception);
        }
    }

    public static long evaluateAddress_preVerified(IEGeneric iEGeneric) {
        return EUtil.evaluateAddress_preVerified(iEGeneric, null);
    }

    public static IEGeneric replaceSubExpressionRecursive(IEGeneric iEGeneric, IEGeneric iEGeneric2, IEGeneric iEGeneric3) {
        return EUtil.replaceSubExpressionRecursive(iEGeneric, iEGeneric2, iEGeneric3, null);
    }

    public static IEGeneric replaceSubExpressionRecursive(IEGeneric iEGeneric, final IEGeneric iEGeneric2, final IEGeneric iEGeneric3, EVisitResults eVisitResults) {
        if (iEGeneric.equals(iEGeneric2)) {
            return iEGeneric3;
        }
        if (eVisitResults == null) {
            eVisitResults = new EVisitResults();
        }
        iEGeneric.visitDepthPost(new IEVisitor(){

            @Override
            public void process(IEGeneric iEGeneric, IEGeneric iEGeneric22, IVisitResults<IEGeneric> iVisitResults) {
                if (iEGeneric2.equals(iEGeneric)) {
                    iEGeneric22.replaceSubExpression(iEGeneric, iEGeneric3.duplicate());
                    iVisitResults.setVisitResult(false);
                }
            }
        }, null, eVisitResults);
        return iEGeneric;
    }

    public static boolean resolveExpressionsBackward(Object object, IEConverter<?> iEConverter, List<IEStatement> list, IEGeneric ... iEGenericArray) {
        if (list.size() == 0) {
            return true;
        }
        if (iEGenericArray == null) {
            return false;
        }
        for (int j = 0; j < iEGenericArray.length; ++j) {
            int n = list.size() - 1;
            if (list.get(n) instanceof IEJump || list.get(n) instanceof IEJumpFar) {
                // empty if block
            }
            for (int i2 = --n; i2 >= 0; --i2) {
                IEStatement iEStatement = list.get(i2);
                if (iEStatement instanceof IENop) continue;
                if (iEStatement instanceof IEUntranslatedInstruction) {
                    if (!EUtil.isExpressionModified(iEStatement, iEGenericArray[j], true)) continue;
                    logger.i("Lost target on %s", object);
                    return false;
                }
                if (!(iEStatement instanceof IEAssign)) {
                    return false;
                }
                IEAssign iEAssign = (IEAssign)iEStatement;
                if (!(iEAssign.getLeftOperand() instanceof IEVar)) {
                    iEGenericArray[j] = EUtil.replaceSubExpressionRecursive(iEGenericArray[j], iEAssign.getLeftOperand(), iEAssign.getRightOperand().duplicate());
                    if (!EUtil.isExpressionModified(iEStatement, iEGenericArray[j], false)) continue;
                    logger.i("Lost target on %s", object);
                    return false;
                }
                IEGeneric iEGeneric = iEAssign.getRightOperand();
                if (iEGenericArray[j].equals(iEAssign.getLeftOperand())) {
                    iEGenericArray[j] = iEGeneric;
                    continue;
                }
                if (iEConverter.getStackPointer().equals(iEAssign.getLeftOperand())) {
                    IdRanges idRanges = new IdRanges();
                    iEGenericArray[j].getUsed(idRanges);
                    List<IEVar> list2 = idRanges.getVars();
                    for (IEVar iEVar : list2) {
                        if (!iEConverter.getStackPointer().equals(iEVar)) continue;
                        logger.i("Lost SP tracking on %s", object);
                        return false;
                    }
                }
                iEGenericArray[j].replaceVar((IEVar)iEAssign.getLeftOperand(), iEGeneric.duplicate());
            }
        }
        return true;
    }

    public static boolean isExpressionModified(IEStatement iEStatement, IEGeneric iEGeneric, boolean bl2) {
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            iEStatement.getDefUse(arrayList, arrayList2, null);
            if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                return false;
            }
            IdRanges idRanges = new IdRanges();
            iEGeneric.getUsed(idRanges);
            List<IEVar> list = idRanges.getVars();
            for (IEVar iEVar : list) {
                if (arrayList.contains(iEVar.getId())) {
                    return true;
                }
                if (!bl2 || !arrayList2.contains(iEVar.getId())) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            logger.catchingSilent(exception);
            return true;
        }
    }

    public static boolean isMatchDuaryOperation(IEGeneric iEGeneric, OperationType operationType, IEGeneric iEGeneric2, IEGeneric iEGeneric3) {
        kz kz2;
        kz kz3;
        return iEGeneric instanceof Yk && ((Yk)iEGeneric).getOperationType() == operationType && ((kz3 = ((Yk)iEGeneric).eO()) == null && iEGeneric2 == null || kz3 != null && kz3.equals(iEGeneric2)) && ((kz2 = ((Yk)iEGeneric).Qx()) == null && iEGeneric3 == null || kz2 != null && kz2.equals(iEGeneric3));
    }

    public static boolean isPCAssign(IEStatement iEStatement) {
        IEAssign iEAssign;
        if (iEStatement instanceof IEAssign && (iEAssign = (IEAssign)iEStatement).getDstOperand() instanceof IEVar) {
            IEVar iEVar = (IEVar)iEAssign.getDstOperand();
            return iEVar.getId() == iEStatement.getContext().getProgramCounterId();
        }
        return false;
    }

    public static IEMem getAssigningToMemory(IEStatement iEStatement) {
        if (iEStatement instanceof IEAssign && ((IEAssign)iEStatement).getDstOperand() instanceof IEMem) {
            return (IEMem)((IEAssign)iEStatement).getDstOperand();
        }
        return null;
    }

    public static IEMem getAssigningFromMemory(IEStatement iEStatement) {
        if (iEStatement instanceof IEAssign && ((IEAssign)iEStatement).getSrcOperand() instanceof IEMem) {
            return (IEMem)((IEAssign)iEStatement).getSrcOperand();
        }
        return null;
    }
}

