/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICBreak;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICCompound;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICContinue;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICControlBreaker;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICForLoopStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICGoto;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICIfStm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICJumpFar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICReturn;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICWhileLoopStm;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CFG {
    private Map<ICStatement, List<ICStatement>> outEdges = new HashMap<ICStatement, List<ICStatement>>();
    private ICStatement entryPoint;

    public static CFG buildCFG(ICMethod iCMethod) {
        CFG cFG = new CFG();
        CFG.buildCFGRecursive(cFG, iCMethod.getBody(), null, null);
        cFG.entryPoint = iCMethod.getBody().isEmpty() ? null : iCMethod.getBody().get(0);
        return cFG;
    }

    /*
     * Could not resolve type clashes
     */
    private static void buildCFGRecursive(CFG cFG, ICBlock iCBlock, ICStatement iCStatement, ICStatement iCStatement2) {
        for (int j = 0; j < iCBlock.size(); ++j) {
            Object object;
            ICStatement iCStatement3 = iCBlock.get(j);
            ICStatement iCStatement4 = iCStatement2;
            ICStatement iCStatement5 = null;
            iCStatement5 = j < iCBlock.size() - 1 ? iCBlock.get(j + 1) : cFG.getFallThroughTarget(iCStatement);
            cFG.setFallThrough(iCStatement3, iCStatement5, false);
            if (iCStatement3 instanceof ICGoto) {
                cFG.setFallThrough(iCStatement3, ((ICGoto)iCStatement3).getLabel());
            } else if (iCStatement3 instanceof ICWhileLoopStm || iCStatement3 instanceof ICForLoopStm) {
                iCStatement4 = iCStatement3;
                object = ((ICCompound)iCStatement3).getBlocks().get(0);
                cFG.addConditionalTarget(iCStatement3, (ICStatement)object);
                if (object.isEmpty()) {
                    cFG.setFallThrough((ICStatement)object, iCStatement3);
                } else {
                    cFG.setFallThrough(object.getLast(), iCStatement3);
                }
            } else if (iCStatement3 instanceof ICIfStm) {
                object = ((ICIfStm)iCStatement3).getBlocks();
                for (int i2 = 0; i2 < ((ICIfStm)iCStatement3).size(); ++i2) {
                    cFG.addConditionalTarget(iCStatement3, (ICStatement)object.get(i2));
                }
            } else if (iCStatement3 instanceof ICReturn || iCStatement3 instanceof ICJumpFar) {
                cFG.setFallThrough(iCStatement3, null);
            } else if (iCStatement3 instanceof ICControlBreaker) {
                if (((ICControlBreaker)iCStatement3).getLabel() != null) {
                    cFG.setFallThrough(iCStatement3, ((ICControlBreaker)iCStatement3).getLabel());
                } else if (iCStatement3 instanceof ICBreak) {
                    cFG.setFallThrough(iCStatement3, cFG.getFallThroughTarget(iCStatement4));
                } else if (iCStatement3 instanceof ICContinue) {
                    cFG.setFallThrough(iCStatement3, iCStatement4);
                }
            } else if (iCStatement3 instanceof ICBlock) {
                cFG.setFallThrough(iCStatement3, ((ICBlock)iCStatement3).get(0));
            }
            if (!(iCStatement3 instanceof ICCompound)) continue;
            for (ICBlock iCBlock2 : ((ICCompound)iCStatement3).getBlocks()) {
                if (!iCBlock2.isEmpty()) {
                    cFG.setFallThrough(iCBlock2, iCBlock2.get(0));
                }
                CFG.buildCFGRecursive(cFG, iCBlock2, iCStatement3, iCStatement4);
            }
        }
    }

    public ICStatement getConditionalTarget(ICStatement iCStatement) {
        return this.outEdges.get(iCStatement) != null && this.outEdges.get(iCStatement).size() > 1 ? this.outEdges.get(iCStatement).get(1) : null;
    }

    public ICStatement getConditionalTarget(ICStatement iCStatement, int n) {
        return this.outEdges.get(iCStatement) != null && this.outEdges.get(iCStatement).size() > n + 1 ? this.outEdges.get(iCStatement).get(n + 1) : null;
    }

    public ICStatement getFallThroughTarget(ICStatement iCStatement) {
        return this.outEdges.get(iCStatement) != null ? this.outEdges.get(iCStatement).get(0) : null;
    }

    private boolean setFallThrough(ICStatement iCStatement, ICStatement iCStatement2) {
        return this.setFallThrough(iCStatement, iCStatement2, true);
    }

    private boolean setFallThrough(ICStatement iCStatement, ICStatement iCStatement2, boolean bl2) {
        List<ICStatement> list = this.outEdges.get(iCStatement);
        if (list == null) {
            list = new ArrayList<ICStatement>();
            this.outEdges.put(iCStatement, list);
        }
        if (bl2 && list.size() >= 1) {
            list.set(0, iCStatement2);
            return true;
        }
        if (list.isEmpty()) {
            list.add(iCStatement2);
            return true;
        }
        return false;
    }

    private boolean addConditionalTarget(ICStatement iCStatement, ICStatement iCStatement2) {
        List<ICStatement> list = this.outEdges.get(iCStatement);
        if (list == null) {
            list = new ArrayList<ICStatement>();
            this.outEdges.put(iCStatement, list);
        }
        list.add(iCStatement2);
        return true;
    }

    public ICStatement getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(ICStatement iCStatement) {
        this.entryPoint = iCStatement;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ICStatement iCStatement : this.outEdges.keySet()) {
            stringBuilder.append("--edge--");
            stringBuilder.append(Strings.LINESEP);
            stringBuilder.append("> from:");
            stringBuilder.append(iCStatement.getClass().getSimpleName().toString());
            stringBuilder.append(Strings.LINESEP);
            stringBuilder.append(iCStatement);
            stringBuilder.append(Strings.LINESEP);
            for (ICStatement iCStatement2 : this.outEdges.get(iCStatement)) {
                if (iCStatement2 == null) {
                    stringBuilder.append("> to:EXIT");
                    stringBuilder.append(Strings.LINESEP);
                    continue;
                }
                stringBuilder.append("> to:");
                stringBuilder.append(iCStatement2.getClass().getSimpleName().toString());
                stringBuilder.append(Strings.LINESEP);
                stringBuilder.append(iCStatement2);
                stringBuilder.append(Strings.LINESEP);
            }
        }
        return stringBuilder.toString();
    }
}

