/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.code.CodeDocument;
import com.pnfsoftware.jeb.core.output.code.CodeLine;
import com.pnfsoftware.jeb.core.output.code.coordinates.CodeCoordinatesUtil;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.NativeCoordinates;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.COutputSink;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.CF;
import com.pnfsoftware.jebglobal.Ek;
import com.pnfsoftware.jebglobal.Lf;
import com.pnfsoftware.jebglobal.Qk;
import com.pnfsoftware.jebglobal.Qn;
import com.pnfsoftware.jebglobal.Yo;
import com.pnfsoftware.jebglobal.Zp;
import com.pnfsoftware.jebglobal.qT;
import java.util.Map;

public class CDocument
extends CodeDocument {
    private static final StructuredLogger logger = qT.eO(CDocument.class);
    public static final String propnameSpaceOutCompounds = "SpaceOutCompounds";
    public static final String propnameMergeAdjacentDefinitions = "MergeAdjacentDefinitions";
    boolean optionSpaceOutCompounds = false;
    boolean optionMergeAdjacentDefinitions = false;
    private boolean disposed;
    private Yo<?> codeunit;
    private IPropertyManager pm;
    private Qn<?> decomp;
    private CF source;
    private IEventListener unitListener;
    private IEventListener pmListener;
    private COutputSink singlePart;

    public static IPropertyDefinitionManager buildPDM(IPropertyDefinitionManager iPropertyDefinitionManager) {
        PropertyDefinitionManager propertyDefinitionManager = UnitUtil.createTextPDM(iPropertyDefinitionManager);
        propertyDefinitionManager.addDefinition(propnameSpaceOutCompounds, PropertyTypeBoolean.create(true), "Insert blank lines between compounds");
        propertyDefinitionManager.addDefinition(propnameMergeAdjacentDefinitions, PropertyTypeBoolean.create(true), "Merge same type definitions on a single line (eg, int i = 0, j = 1;)");
        return propertyDefinitionManager;
    }

    public CDocument(INativeSourceUnit iNativeSourceUnit) {
        this.source = (CF)iNativeSourceUnit;
        this.decomp = (Qn)iNativeSourceUnit.getParent();
        this.codeunit = (Yo)this.decomp.getParent();
        this.setupOptions(false);
        this.unitListener = new IEventListener(){

            @Override
            public void onEvent(IEvent iEvent) {
                JebEvent jebEvent = (JebEvent)iEvent;
                if (jebEvent.getType() == J.UnitChange) {
                    CDocument.this.notifyListeners(jebEvent);
                }
            }
        };
        iNativeSourceUnit.addListener(this.unitListener);
        this.pm = this.decomp.getPropertyManager();
        this.pmListener = new IEventListener(){

            @Override
            public void onEvent(IEvent iEvent) {
                if (iEvent instanceof JebEvent && iEvent.getType() == J.PropertyChange && iEvent.getData() instanceof PropertyChangeNotification) {
                    PropertyChangeNotification propertyChangeNotification = (PropertyChangeNotification)iEvent.getData();
                    logger.i("Property changes: %s", propertyChangeNotification);
                    CDocument.this.setupOptions(true);
                }
            }
        };
        this.pm.addListener(this.pmListener);
    }

    private void setupOptions(boolean bl2) {
        PropertyManager propertyManager = UnitUtil.createTextPM(this.decomp);
        this.optionSpaceOutCompounds = propertyManager.getBoolean(propnameSpaceOutCompounds);
        this.optionMergeAdjacentDefinitions = propertyManager.getBoolean(propnameMergeAdjacentDefinitions);
        if (bl2) {
            this.notifyListeners(new JebEvent(J.UnitChange));
        }
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            super.dispose();
            this.source.removeListener(this.unitListener);
            this.source.getPropertyManager().removeListener(this.pmListener);
            this.disposed = true;
        }
    }

    @Override
    public long getAnchorCount() {
        return 1L;
    }

    @Override
    public COutputSink getDocumentPart(long l2, int n, int n2) {
        COutputSink cOutputSink = new COutputSink(0L, this, this.decomp);
        cOutputSink.registerAnchor("single_anchor");
        Lf lf2 = this.source.Le();
        if (!(lf2 instanceof Qk || lf2 instanceof Zp || lf2 instanceof Ek)) {
            throw new RuntimeException(String.format("The generation of a top-level %s node is not supported yet", new Object[]{lf2.getElementType()}));
        }
        cOutputSink.setDynamicContentManager(this.decomp.eO());
        cOutputSink.setSourceCustomizer(this.decomp.ae());
        lf2.generate(cOutputSink);
        cOutputSink.validate();
        this.singlePart = cOutputSink;
        return cOutputSink;
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        ICodeCoordinates iCodeCoordinates = this.coordinatesToCodeCoordinates(iCoordinates);
        if (iCodeCoordinates == null) {
            return null;
        }
        return this.codeunit.eO(iCodeCoordinates, addressConversionPrecision);
    }

    private ICodeCoordinates coordinatesToCodeCoordinates(ICoordinates iCoordinates) {
        ICodeCoordinates iCodeCoordinates;
        ICodeCoordinates iCodeCoordinates2;
        if (iCoordinates == null) {
            return null;
        }
        int n = iCoordinates.getLineDelta();
        if (this.singlePart == null || n < 0 || n >= this.singlePart.getLines().size()) {
            return null;
        }
        CodeLine codeLine = this.singlePart.getLines().get(n);
        ICodeCoordinates iCodeCoordinates3 = codeLine.getCoordinates(iCoordinates.getColumnOffset());
        ICodeCoordinates iCodeCoordinates4 = codeLine.getLineCoordinates();
        if (iCodeCoordinates3 instanceof InstructionCoordinates && ((InstructionCoordinates)(iCodeCoordinates2 = (InstructionCoordinates)iCodeCoordinates3)).getMethodId() < 0) {
            iCodeCoordinates3 = null;
        }
        if ((iCodeCoordinates2 = iCodeCoordinates3) == null) {
            iCodeCoordinates2 = iCodeCoordinates4;
        }
        if (iCodeCoordinates2 == null) {
            return null;
        }
        if (iCodeCoordinates4 instanceof NativeCoordinates && iCodeCoordinates3 instanceof NativeCoordinates) {
            iCodeCoordinates = (NativeCoordinates)iCodeCoordinates4;
            NativeCoordinates nativeCoordinates = (NativeCoordinates)iCodeCoordinates3;
            if (((NativeCoordinates)iCodeCoordinates).getAddress() > nativeCoordinates.getAddress() && nativeCoordinates.getAddress() > 0L) {
                iCodeCoordinates2 = iCodeCoordinates4;
            }
        }
        if (iCodeCoordinates2 instanceof InstructionCoordinates && ((InstructionCoordinates)(iCodeCoordinates = (InstructionCoordinates)iCodeCoordinates2)).getOffset() < 0) {
            iCodeCoordinates2 = new MethodCoordinates(((InstructionCoordinates)iCodeCoordinates).getMethodId());
        }
        return iCodeCoordinates2;
    }

    @Override
    public ICoordinates addressToCoordinates(String string) {
        ICodeCoordinates iCodeCoordinates = this.codeunit.getCodeCoordinatesFromAddress(string);
        if (iCodeCoordinates == null) {
            return null;
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (CodeLine codeLine : this.singlePart.getLines()) {
            ICodeCoordinates iCodeCoordinates2 = codeLine.getLineCoordinates();
            if (iCodeCoordinates.equals(iCodeCoordinates2)) {
                return new Coordinates(0L, n4, 0);
            }
            int n5 = CodeCoordinatesUtil.distance(iCodeCoordinates, iCodeCoordinates2);
            if (n5 < n) {
                n = n5;
                n2 = n4;
                n3 = 0;
            }
            Map<Integer, ICodeCoordinates> map = codeLine.getCoordinates();
            for (Integer n6 : map.keySet()) {
                iCodeCoordinates2 = map.get(n6);
                if (iCodeCoordinates.equals(iCodeCoordinates2)) {
                    return new Coordinates(0L, n4, n6);
                }
                n5 = CodeCoordinatesUtil.distance(iCodeCoordinates, iCodeCoordinates2);
                if (n5 >= n) continue;
                n = n5;
                n2 = n4;
                n3 = n6;
            }
            ++n4;
        }
        if (n < Integer.MAX_VALUE) {
            logger.i("address-to-coordinates() conversion failed, closest coordinates are at distance %d", n);
            return new Coordinates(0L, n2, n3);
        }
        return null;
    }
}

