/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IVariableInformationProvider;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.Tracker;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DFA<InsnType extends IInstruction> {
    private static final ILogger logger = GlobalLog.getLogger(DFA.class);
    CFG<InsnType> cfg;
    boolean done;
    IVariableInformationProvider varInfoProvider;

    DFA(CFG<InsnType> cFG) {
        this.cfg = cFG;
    }

    public void perform(boolean bl2, boolean bl3, IVariableInformationProvider iVariableInformationProvider) {
        if (this.done && !bl2) {
            return;
        }
        this.varInfoProvider = iVariableInformationProvider;
        this.invalidate();
        this.storeRegistersUsage();
        this.calculateLiveRegisters();
        this.calculateDefUseChains();
        Set<Integer> set = null;
        if (bl3) {
            set = this.cfg.getEntryBlock().getTrackerLiveRegisters().getInputs().keySet();
        }
        this.calculateReachingRegisters(set);
        this.calculateUseDefChains();
        for (BasicBlock basicBlock : this.cfg.bblist) {
            basicBlock.datamap = new HashMap<String, Object>();
        }
        this.done = true;
    }

    public void invalidate() {
        this.done = false;
        for (BasicBlock basicBlock : this.cfg.bblist) {
            basicBlock.insn_def = null;
            basicBlock.insn_use = null;
            basicBlock.trkLive = null;
            basicBlock.trkReaching = null;
            basicBlock.trkAvailable = null;
            basicBlock.listDuChains = null;
            basicBlock.listUdChains = null;
            basicBlock.listFullDuChains = null;
            basicBlock.listFullUdChains = null;
            basicBlock.datamap = null;
        }
    }

    public boolean isValid() {
        for (BasicBlock basicBlock : this.cfg.bblist) {
            if (basicBlock.insn_def != null && basicBlock.insn_use != null && basicBlock.trkLive != null && basicBlock.trkReaching != null && basicBlock.listDuChains != null && basicBlock.listUdChains != null && basicBlock.listFullDuChains != null && basicBlock.listFullUdChains != null && basicBlock.datamap != null) continue;
            return false;
        }
        return true;
    }

    private void storeRegistersUsage() {
        for (BasicBlock basicBlock : this.cfg.bblist) {
            basicBlock.insn_def = new ArrayList<List<Integer>>();
            basicBlock.insn_use = new ArrayList<List<Integer>>();
            for (IInstruction iInstruction : basicBlock) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                iInstruction.getDefUse(arrayList, arrayList2, null);
                basicBlock.insn_def.add(arrayList);
                basicBlock.insn_use.add(arrayList2);
            }
        }
    }

    private void calculateLiveRegisters() {
        Iterator iterator;
        Tracker tracker;
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        for (BasicBlock basicBlock : this.cfg.bblist) {
            tracker = new Tracker(basicBlock, true, false);
            if (basicBlock.alloutsize() == 0) {
                tracker.initOutlist();
                arrayDeque.push(tracker);
            }
            basicBlock.trkLive = tracker;
        }
        if (arrayDeque.isEmpty()) {
            iterator = this.cfg.bblist.get((int)0).trkLive;
            ((Tracker)((Object)iterator)).initOutlist();
            arrayDeque.push(iterator);
        }
        while (!arrayDeque.isEmpty()) {
            while (!arrayDeque.isEmpty()) {
                iterator = (Tracker)arrayDeque.pop();
                ((Tracker)((Object)iterator)).applyTransferFunctionLiveRegisters();
            }
            for (BasicBlock basicBlock : this.cfg.bblist) {
                tracker = basicBlock.trkLive;
                HashMap<Integer, Set<Long>> hashMap = new HashMap<Integer, Set<Long>>();
                for (BasicBlock basicBlock2 : tracker.bb.getAllOutputBlocks()) {
                    Tracker.addToList(hashMap, basicBlock2.trkLive.inlist);
                }
                if (tracker.outlist != null && Tracker.compareLists(hashMap, tracker.outlist)) continue;
                tracker.outlist = hashMap;
                arrayDeque.push(tracker);
            }
        }
        for (BasicBlock basicBlock : this.cfg.bblist) {
            tracker = basicBlock.trkLive;
            if (tracker.outlist != null) continue;
            tracker.initOutlist();
        }
    }

    private void calculateDefUseChains() {
        for (int j = 0; j < this.cfg.bblist.size(); ++j) {
            BasicBlock basicBlock = this.cfg.bblist.get(j);
            basicBlock.allocDuChains();
            for (int i2 = 0; i2 < basicBlock.size(); ++i2) {
                ArrayList arrayList = new ArrayList(basicBlock.insn_def.get(i2));
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    int n = (Integer)object.next();
                    hashMap.put(n, new HashSet());
                    hashMap2.put(n, new HashSet());
                }
                for (int i3 = i2 + 1; i3 < basicBlock.size(); ++i3) {
                    for (int n : basicBlock.insn_use.get(i3)) {
                        if (!arrayList.contains(n)) continue;
                        ((Set)hashMap.get(n)).add(i3);
                        ((Set)hashMap2.get(n)).add(basicBlock.getAddressOfInstruction(i3));
                    }
                    for (int n : basicBlock.insn_def.get(i3)) {
                        if (!arrayList.contains(n)) continue;
                        arrayList.remove((Object)n);
                    }
                }
                object = basicBlock.trkLive;
                for (int n : ((Tracker)object).outlist.keySet()) {
                    if (!arrayList.contains(n)) continue;
                    ((Set)hashMap.get(n)).add(-1);
                    ((Set)hashMap2.get(n)).addAll((Collection)((Tracker)object).outlist.get(n));
                }
                basicBlock.listDuChains.set(i2, hashMap);
                basicBlock.listFullDuChains.set(i2, hashMap2);
            }
        }
    }

    private void calculateReachingRegisters(Collection<Integer> collection) {
        Object object;
        Tracker tracker;
        BasicBlock<InsnType> basicBlock = this.cfg.getEntryBlock();
        ArrayDeque arrayDeque = new ArrayDeque();
        for (BasicBlock basicBlock2 : this.cfg.bblist) {
            tracker = new Tracker(basicBlock2, false, true);
            if (basicBlock2 == basicBlock) {
                tracker.initInlist();
                arrayDeque.push(tracker);
                if (collection != null) {
                    object = collection.iterator();
                    while (object.hasNext()) {
                        int n = (Integer)object.next();
                        HashSet<Long> hashSet = new HashSet<Long>();
                        hashSet.add(-1L);
                        tracker.inlist.put(n, hashSet);
                    }
                }
            }
            basicBlock2.trkReaching = tracker;
        }
        while (!arrayDeque.isEmpty()) {
            while (!arrayDeque.isEmpty()) {
                Iterator iterator = (Tracker)arrayDeque.pop();
                ((Tracker)((Object)iterator)).applyTransferFunctionReachingRegisters(this.varInfoProvider);
            }
            for (BasicBlock basicBlock2 : this.cfg.bblist) {
                tracker = basicBlock2.trkReaching;
                object = new HashMap();
                for (BasicBlock basicBlock3 : tracker.bb.getAllInputBlocks()) {
                    Tracker.addToList((Map<Integer, Set<Long>>)object, basicBlock3.trkReaching.outlist);
                }
                if (tracker.bb == basicBlock && collection != null) {
                    Iterator<Object> iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        HashSet<Long> hashSet = (HashSet<Long>)object.get(n);
                        if (hashSet == null) {
                            hashSet = new HashSet<Long>();
                            object.put(n, hashSet);
                        }
                        hashSet.add(-1L);
                    }
                }
                if (tracker.inlist != null && Tracker.compareLists((Map<Integer, Set<Long>>)object, tracker.inlist)) continue;
                tracker.inlist = object;
                arrayDeque.push(tracker);
            }
        }
        for (BasicBlock basicBlock2 : this.cfg.bblist) {
            tracker = basicBlock2.trkReaching;
            if (tracker.inlist != null) continue;
            tracker.initInlist();
        }
    }

    private void calculateAvailableRegisters() {
        Object object;
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        int n = 0;
        for (BasicBlock basicBlock : this.cfg.bblist) {
            object = new Tracker(basicBlock, false, true);
            if (n++ == 0) {
                ((Tracker)object).initInlist();
                arrayDeque.push(object);
            }
            basicBlock.trkAvailable = object;
        }
        while (!arrayDeque.isEmpty()) {
            while (!arrayDeque.isEmpty()) {
                Iterator iterator = (Tracker)arrayDeque.pop();
                ((Tracker)((Object)iterator)).applyTransferFunctionAvailableRegisters();
            }
            for (BasicBlock basicBlock : this.cfg.bblist) {
                object = new HashMap();
                n = 0;
                for (BasicBlock basicBlock2 : basicBlock.getAllInputBlocks()) {
                    if (n++ == 0) {
                        Tracker.addToList((Map<Integer, Set<Long>>)object, basicBlock2.trkAvailable.outlist);
                        continue;
                    }
                    Tracker.addCommonsToList((Map<Integer, Set<Long>>)object, basicBlock2.trkAvailable.outlist);
                }
                Tracker tracker = basicBlock.trkAvailable;
                if (tracker.inlist != null && Tracker.compareLists((Map<Integer, Set<Long>>)object, tracker.inlist)) continue;
                tracker.inlist = object;
                arrayDeque.push(tracker);
            }
        }
        for (BasicBlock basicBlock : this.cfg.bblist) {
            object = basicBlock.trkAvailable;
            if (((Tracker)object).inlist != null) continue;
            ((Tracker)object).initInlist();
        }
    }

    private void calculateUseDefChains() {
        for (BasicBlock basicBlock : this.cfg.bblist) {
            basicBlock.allocUdChains();
            for (int j = 0; j < basicBlock.size(); ++j) {
                ArrayList arrayList = new ArrayList(basicBlock.insn_use.get(j));
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    int n = (Integer)object.next();
                    hashMap.put(n, new HashSet());
                    hashMap2.put(n, new HashSet());
                }
                block3: for (int i2 = j - 1; i2 >= 0; --i2) {
                    for (int n : basicBlock.insn_def.get(i2)) {
                        if (!arrayList.contains(n)) continue;
                        ((Set)hashMap.get(n)).add(i2);
                        ((Set)hashMap2.get(n)).add(basicBlock.getAddressOfInstruction(i2));
                        arrayList.remove((Object)n);
                        if (!arrayList.isEmpty()) continue;
                        break block3;
                    }
                }
                object = basicBlock.trkReaching;
                for (int n : ((Tracker)object).inlist.keySet()) {
                    if (!arrayList.contains(n)) continue;
                    ((Set)hashMap.get(n)).add(-1);
                    ((Set)hashMap2.get(n)).addAll((Collection)((Tracker)object).inlist.get(n));
                }
                basicBlock.listUdChains.set(j, hashMap);
                basicBlock.listFullUdChains.set(j, hashMap2);
            }
        }
    }
}

