/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IFormattingContextFactory;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IVariable;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.IVariableProvider;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.VarLocations;
import com.pnfsoftware.jeb.util.collect.BitMap;
import com.pnfsoftware.jeb.util.collect.KeyOrder;
import com.pnfsoftware.jeb.util.collect.MultiMap;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CFGFormatter<InsnType extends IInstruction> {
    private static final ILogger logger = GlobalLog.getLogger(CFGFormatter.class);
    private CFG<InsnType> cfg;
    private IVariableProvider varprv;
    private boolean formatFineGrained;

    public CFGFormatter(CFG<InsnType> cFG) {
        this(cFG, null, false);
    }

    public CFGFormatter(CFG<InsnType> cFG, IVariableProvider iVariableProvider, boolean bl2) {
        this.cfg = cFG;
        this.varprv = iVariableProvider;
        this.formatFineGrained = bl2;
    }

    public CFG<InsnType> getCfg() {
        return this.cfg;
    }

    public String formatSimple() {
        return this.format(true, 0, false, null);
    }

    public String formatWithSimpleChains() {
        return this.format(true, 1, true, null);
    }

    public String format(boolean bl2, int n, boolean bl3, IFormattingContextFactory<InsnType> iFormattingContextFactory) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = this.cfg.getEntryAddress();
        if (bl3) {
            Iterator<BasicBlock<InsnType>> iterator = this.cfg.getEntryBlock();
            BasicBlock<InsnType> basicBlock = this.formatChain(((BasicBlock)((Object)iterator)).getTrackerLiveRegisters().getInputs());
            stringBuilder.append(String.format(">> IN(@%X): %s\n", l2, basicBlock));
        }
        for (BasicBlock<InsnType> basicBlock : this.cfg) {
            int n2 = 0;
            for (AddressableInstruction addressableInstruction : basicBlock.addressableInstructions()) {
                String string;
                String string2;
                Object InsnType = addressableInstruction.getInstruction();
                long l3 = addressableInstruction.getOffset();
                if (bl2) {
                    char c = n2 >= 1 ? (char)':' : (basicBlock.getFirstAddress() == l2 ? (char)'>' : (basicBlock.irrinsize() == 0 ? (char)'+' : '*'));
                    stringBuilder.append(String.format("%04X/%X%c  ", l3, InsnType.getSize(), Character.valueOf(c)));
                }
                Object object = iFormattingContextFactory == null ? Long.valueOf(l3) : iFormattingContextFactory.createFormattingContext(InsnType);
                stringBuilder.append(String.format("%-100s  ", InsnType.format(object)));
                if (n == 1) {
                    string2 = this.formatChain(basicBlock.listDuChains.get(n2));
                    string = this.formatChain(basicBlock.listUdChains.get(n2));
                    stringBuilder.append(String.format("du: %-30s | ud: %s", string2, string));
                } else if (n == 2) {
                    string2 = this.formatChain(basicBlock.listFullDuChains.get(n2));
                    string = this.formatChain(basicBlock.listFullUdChains.get(n2));
                    stringBuilder.append(String.format("DU: %-30s | UD: %s", string2, string));
                }
                string2 = this.extraInstructionDetails(l3, InsnType);
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                stringBuilder.append('\n');
                ++n2;
            }
        }
        if (bl3) {
            for (BasicBlock<InsnType> basicBlock : this.cfg.getExitBlocks()) {
                String string = this.formatChain(basicBlock.getTrackerReachingRegisters().getOutputs());
                stringBuilder.append(String.format("<< OUT(@%X): %s\n", basicBlock.getEndAddress(), string));
            }
        }
        return stringBuilder.toString();
    }

    private <T extends Number> String formatChain(Map<Integer, Set<T>> map) {
        ArrayList<Number> arrayList;
        Object object62;
        if (this.varprv == null) {
            return this.formatChainLegacy(map);
        }
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        Object object2 = map.keySet().iterator();
        while (object2.hasNext()) {
            int n = object2.next();
            Object object3 = this.varprv.getContaining(n);
            if (object3 == null) {
                throw new RuntimeException("Cannot retrieve variable containing vbit " + n);
            }
            object62 = (VarLocations)treeMap.get(object3.getId());
            if (object62 == null) {
                object62 = new VarLocations((IVariable)object3);
                treeMap.put(object3.getId(), object62);
            }
            for (Iterator iterator : map.get(n)) {
                ((VarLocations)object62).record(iterator, n);
            }
        }
        object2 = new MultiMap(KeyOrder.INSERTION);
        if (!this.formatFineGrained) {
            for (Object object3 : treeMap.values()) {
                ((MultiMap)object2).createKey(((VarLocations)object3).var.getName());
                ((MultiMap)object2).putMulti(((VarLocations)object3).var.getName(), ((VarLocations)object3).touched.keySet());
            }
        } else {
            for (Object object3 : treeMap.values()) {
                object62 = new ArrayList();
                arrayList = new MultiMap();
                for (Object object4 : ((VarLocations)object3).touched.keySet()) {
                    BitMap object5 = ((VarLocations)object3).touched.get(object4);
                    if (object5.isFull()) {
                        object62.add(object4);
                        continue;
                    }
                    ((MultiMap)((Object)arrayList)).put(object5, object4);
                }
                ((MultiMap)object2).createKey(((VarLocations)object3).var.getName());
                ((MultiMap)object2).putMulti(((VarLocations)object3).var.getName(), object62);
                for (Object object4 : ((MultiMap)((Object)arrayList)).keySet()) {
                    ((MultiMap)object2).putMulti(((VarLocations)object3).var.getName() + ((BitMap)object4).formatAsRanges(), ((MultiMap)((Object)arrayList)).get(object4));
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object62 : ((MultiMap)object2).keySet()) {
            stringBuilder.append(String.format("%s={", object62));
            arrayList = new ArrayList<Number>(((MultiMap)object2).get(object62));
            Collections.sort(arrayList, new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    return Long.compare(((Number)t).longValue(), ((Number)t2).longValue());
                }
            });
            int n = 0;
            for (Number number : arrayList) {
                if (n >= 1) {
                    stringBuilder.append(",");
                }
                if (number instanceof Integer) {
                    stringBuilder.append(String.format("%X", number.intValue()));
                } else if (number instanceof Long) {
                    if (number.longValue() == -1L) {
                        stringBuilder.append("@init");
                    } else {
                        stringBuilder.append(String.format("@%X", number.longValue()));
                    }
                }
                ++n;
            }
            stringBuilder.append("} ");
        }
        return stringBuilder.toString();
    }

    private <T extends Number> String formatChainLegacy(Map<Integer, Set<T>> map) {
        TreeMap<Integer, Set<T>> treeMap = new TreeMap<Integer, Set<T>>(map);
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : treeMap.keySet()) {
            stringBuilder.append("(").append(n >= 0 ? Integer.toHexString(n) : "-" + Integer.toHexString(-n)).append(")={");
            ArrayList arrayList = new ArrayList(treeMap.get(n));
            Collections.sort(arrayList, new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    return Long.compare(((Number)t).longValue(), ((Number)t2).longValue());
                }
            });
            int n2 = 0;
            for (Number number : arrayList) {
                if (n2 >= 1) {
                    stringBuilder.append(",");
                }
                if (number instanceof Integer) {
                    stringBuilder.append(Integer.toHexString(number.intValue()).toUpperCase());
                } else if (number instanceof Long) {
                    if (number.longValue() == -1L) {
                        stringBuilder.append("@init");
                    } else {
                        stringBuilder.append("@").append(Long.toHexString(number.longValue()).toUpperCase());
                    }
                }
                ++n2;
            }
            stringBuilder.append("} ");
        }
        return stringBuilder.toString();
    }

    protected String extraInstructionDetails(long l2, InsnType InsnType) {
        return "";
    }
}

