/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.AddressableInstruction;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.Tracker;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Ser
public class BasicBlock<InsnType extends IInstruction>
implements IBasicBlock<InsnType>,
Iterable<InsnType> {
    private static final ILogger logger = GlobalLog.getLogger(BasicBlock.class);
    @SerId(value=1)
    long base;
    @SerId(value=2)
    List<InsnType> insns = new ArrayList<InsnType>();
    @SerTransient
    List<Long> dst_offsets = new ArrayList<Long>();
    @SerTransient
    List<Long> irrdst_offsets = new ArrayList<Long>();
    @SerId(value=3)
    List<BasicBlock<InsnType>> src = new ArrayList<BasicBlock<InsnType>>();
    @SerId(value=4)
    List<BasicBlock<InsnType>> dst = new ArrayList<BasicBlock<InsnType>>();
    @SerId(value=5)
    List<BasicBlock<InsnType>> irrsrc = new ArrayList<BasicBlock<InsnType>>();
    @SerId(value=6)
    List<BasicBlock<InsnType>> irrdst = new ArrayList<BasicBlock<InsnType>>();
    @SerId(value=7)
    boolean unknownDst = false;
    @SerTransient
    List<List<Integer>> insn_def;
    @SerTransient
    List<List<Integer>> insn_use;
    @SerTransient
    Tracker<InsnType> trkLive;
    @SerTransient
    Tracker<InsnType> trkReaching;
    @SerTransient
    Tracker<InsnType> trkAvailable;
    @SerTransient
    List<Map<Integer, Set<Integer>>> listDuChains;
    @SerTransient
    List<Map<Integer, Set<Integer>>> listUdChains;
    @SerTransient
    List<Map<Integer, Set<Long>>> listFullDuChains;
    @SerTransient
    List<Map<Integer, Set<Long>>> listFullUdChains;
    @SerTransient
    Map<String, Object> datamap;

    public BasicBlock(long l2) {
        this.base = l2;
    }

    public BasicBlock(long l2, List<InsnType> list, List<Long> list2, List<Long> list3, boolean bl2) {
        this.base = l2;
        this.insns = list;
        this.dst_offsets = list2;
        this.irrdst_offsets = list3;
        this.unknownDst = bl2;
    }

    public BasicBlock<InsnType> shallowCopy(boolean bl2) {
        BasicBlock<InsnType> basicBlock = new BasicBlock<InsnType>(this.base);
        basicBlock.insns.addAll(this.insns);
        if (bl2) {
            basicBlock.src.addAll(this.src);
            basicBlock.dst.addAll(this.dst);
            basicBlock.irrsrc.addAll(this.irrsrc);
            basicBlock.irrdst.addAll(this.irrdst);
        }
        basicBlock.dst_offsets = this.dst_offsets == null ? null : new ArrayList<Long>(this.dst_offsets);
        basicBlock.irrdst_offsets = this.irrdst_offsets == null ? null : new ArrayList<Long>(this.irrdst_offsets);
        basicBlock.unknownDst = this.unknownDst;
        return basicBlock;
    }

    @Override
    public long getFirstAddress() {
        return this.base;
    }

    @Override
    public long getLastAddress() {
        long l2 = this.base;
        for (int j = 0; j < this.insns.size() - 1; ++j) {
            l2 += (long)((IInstruction)this.insns.get(j)).getSize();
        }
        return l2;
    }

    @Override
    public long getEndAddress() {
        long l2 = this.base;
        for (IInstruction iInstruction : this.insns) {
            l2 += (long)iInstruction.getSize();
        }
        return l2;
    }

    @Override
    public long getAddressOfInstruction(int n) {
        if (n < 0 || n >= this.insns.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long l2 = this.base;
        for (int j = 0; j < n; ++j) {
            l2 += (long)((IInstruction)this.insns.get(j)).getSize();
        }
        return l2;
    }

    @Override
    public int getIndexOfInstruction(long l2) {
        long l3 = this.base;
        for (int j = 0; j < this.insns.size(); ++j) {
            if (l3 == l2) {
                return j;
            }
            l3 += (long)((IInstruction)this.insns.get(j)).getSize();
        }
        throw new RuntimeException();
    }

    @Override
    public boolean canThrow() {
        for (IInstruction iInstruction : this.insns) {
            if (!iInstruction.canThrow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.insns.size();
    }

    @Override
    public boolean isEmpty() {
        return this.insns.isEmpty();
    }

    @Override
    public InsnType get(int n) {
        return (InsnType)((IInstruction)this.insns.get(n));
    }

    public AddressableInstruction<InsnType> get2(int n) {
        if (n < 0 || n >= this.insns.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long l2 = this.base;
        IInstruction iInstruction = (IInstruction)this.insns.get(0);
        for (int j = 0; j < n; ++j) {
            l2 += (long)iInstruction.getSize();
            iInstruction = (IInstruction)this.insns.get(j + 1);
        }
        return new AddressableInstruction<IInstruction>(l2, iInstruction);
    }

    @Override
    public InsnType getLast() {
        return this.get(this.insns.size() - 1);
    }

    @Override
    public InsnType getInstruction(int n) {
        return (InsnType)((IInstruction)this.insns.get(n));
    }

    public AddressableInstruction<InsnType> getLast2() {
        return this.get2(this.insns.size() - 1);
    }

    public InsnType getInstruction(long l2) {
        if (l2 >= this.base) {
            long l3 = this.base;
            for (IInstruction iInstruction : this.insns) {
                if (l2 == l3) {
                    return (InsnType)iInstruction;
                }
                l3 += (long)iInstruction.getSize();
            }
        }
        return null;
    }

    @Override
    public List<InsnType> getInstructions() {
        return new ArrayList<InsnType>(this.insns);
    }

    public AddressableInstruction<InsnType> getBranchingInstruction2(boolean bl2, boolean bl3) {
        long l2 = this.base;
        for (int j = 0; j < this.insns.size(); ++j) {
            IInstruction iInstruction = (IInstruction)this.insns.get(j);
            if (bl2 && iInstruction.getBreakingFlow(l2).isBroken()) {
                return new AddressableInstruction<IInstruction>(l2, iInstruction);
            }
            if (bl3 && iInstruction.getRoutineCall(l2).isBroken()) {
                return new AddressableInstruction<IInstruction>(l2, iInstruction);
            }
            l2 += (long)iInstruction.getSize();
        }
        return null;
    }

    public AddressableInstruction<InsnType> getBranchingInstruction2() {
        return this.getBranchingInstruction2(true, true);
    }

    public boolean remove(int n) {
        this.insns.remove(n);
        this.listDuChains.remove(n);
        this.listUdChains.remove(n);
        this.listFullDuChains.remove(n);
        this.listFullUdChains.remove(n);
        Assert.a(this.listDuChains.size() == this.insns.size());
        Assert.a(this.listUdChains.size() == this.insns.size());
        Assert.a(this.listFullDuChains.size() == this.insns.size());
        Assert.a(this.listFullUdChains.size() == this.insns.size());
        if (!this.insns.isEmpty()) {
            return false;
        }
        if (this.outsize() != 1) {
            throw new RuntimeException(String.format("Removed last instruction of block, outdegree should be 1 but was not (%d)", this.outsize()));
        }
        return true;
    }

    public void add(InsnType InsnType) {
        this.insns.add(InsnType);
    }

    public InsnType set(int n, InsnType InsnType) {
        if (((IInstruction)this.insns.get(n)).getSize() != InsnType.getSize()) {
            throw new IllegalArgumentException("Replacement of instruction with different sizes");
        }
        return (InsnType)((IInstruction)this.insns.set(n, InsnType));
    }

    @Override
    public int insize() {
        return this.src.size();
    }

    @Override
    public int irrinsize() {
        return this.irrsrc.size();
    }

    @Override
    public int allinsize() {
        return this.src.size() + this.irrsrc.size();
    }

    @Override
    public BasicBlock<InsnType> getInputBlock(int n) {
        return this.src.get(n);
    }

    @Override
    public List<BasicBlock<InsnType>> getInputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.src);
    }

    @Override
    public BasicBlock<InsnType> getIrregularInputBlock(int n) {
        return this.irrsrc.get(n);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularInputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.irrsrc);
    }

    @Override
    public List<BasicBlock<InsnType>> getAllInputBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>(this.src);
        arrayList.addAll(this.irrsrc);
        return arrayList;
    }

    @Override
    public int outsize() {
        return this.dst.size();
    }

    @Override
    public int irroutsize() {
        return this.irrdst.size();
    }

    @Override
    public int alloutsize() {
        return this.dst.size() + this.irrdst.size();
    }

    @Override
    public BasicBlock<InsnType> getOutputBlock(int n) {
        return this.dst.get(n);
    }

    @Override
    public List<BasicBlock<InsnType>> getOutputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.dst);
    }

    @Override
    public BasicBlock<InsnType> getIrregularOutputBlock(int n) {
        return this.irrdst.get(n);
    }

    @Override
    public List<BasicBlock<InsnType>> getIrregularOutputBlocks() {
        return new ArrayList<BasicBlock<InsnType>>(this.irrdst);
    }

    @Override
    public List<BasicBlock<InsnType>> getAllOutputBlocks() {
        ArrayList<BasicBlock<InsnType>> arrayList = new ArrayList<BasicBlock<InsnType>>(this.dst);
        arrayList.addAll(this.irrdst);
        return arrayList;
    }

    public boolean hasUnknownDst() {
        return this.unknownDst;
    }

    public boolean isSelfReferencing() {
        if (this.dst.size() > 0 && this.src.size() > 0) {
            for (BasicBlock<InsnType> basicBlock : this.dst) {
                if (!this.src.contains(basicBlock)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInfiniteLoop() {
        return this.dst.size() == 1 && this.isSelfReferencing();
    }

    public String toString() {
        return String.format("%Xh(%d)", this.base, this.insns.size());
    }

    void allocDuChains() {
        this.listDuChains = new ArrayList<Map<Integer, Set<Integer>>>(this.insns.size());
        this.listFullDuChains = new ArrayList<Map<Integer, Set<Long>>>(this.insns.size());
        for (int j = 0; j < this.insns.size(); ++j) {
            this.listDuChains.add(null);
            this.listFullDuChains.add(null);
        }
    }

    void allocUdChains() {
        this.listUdChains = new ArrayList<Map<Integer, Set<Integer>>>(this.insns.size());
        this.listFullUdChains = new ArrayList<Map<Integer, Set<Long>>>(this.insns.size());
        for (int j = 0; j < this.insns.size(); ++j) {
            this.listUdChains.add(null);
            this.listFullUdChains.add(null);
        }
    }

    private <T> T verifyNonNull(T t) {
        if (t == null) {
            throw new RuntimeException("Data flow analysis must be performed first");
        }
        return t;
    }

    public Tracker<InsnType> getTrackerLiveRegisters() {
        return this.verifyNonNull(this.trkLive);
    }

    public Tracker<InsnType> getTrackerReachingRegisters() {
        return this.verifyNonNull(this.trkReaching);
    }

    public Map<Integer, Set<Integer>> getSimpleDefUseChains(int n) {
        return this.verifyNonNull(this.listDuChains).get(n);
    }

    public Map<Integer, Set<Long>> getFullDefUseChains(int n) {
        return this.verifyNonNull(this.listFullDuChains).get(n);
    }

    public Map<Integer, Set<Integer>> getSimpleUseDefChains(int n) {
        return this.verifyNonNull(this.listUdChains).get(n);
    }

    public Map<Integer, Set<Long>> getFullUseDefChains(int n) {
        return this.verifyNonNull(this.listFullUdChains).get(n);
    }

    public void setData(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.datamap == null) {
            this.datamap = new HashMap<String, Object>();
        }
        this.datamap.put(string, object);
    }

    public Object getData(String string) {
        return this.verifyNonNull(this.datamap).get(string);
    }

    public boolean removeData(String string) {
        return this.verifyNonNull(this.datamap).remove(string) != null;
    }

    @Override
    public Iterator<InsnType> iterator() {
        return this.insns.iterator();
    }

    public Iterable<AddressableInstruction<InsnType>> addressableInstructions() {
        return new Iterable<AddressableInstruction<InsnType>>(){

            @Override
            public Iterator<AddressableInstruction<InsnType>> iterator() {
                return new AddressableInstructionsIterator();
            }
        };
    }

    private class AddressableInstructionsIterator
    implements Iterator<AddressableInstruction<InsnType>> {
        private long address;
        private Iterator<InsnType> iter;

        private AddressableInstructionsIterator() {
            this.address = BasicBlock.this.base;
            this.iter = BasicBlock.this.insns.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public AddressableInstruction<InsnType> next() {
            IInstruction iInstruction = (IInstruction)this.iter.next();
            AddressableInstruction<IInstruction> addressableInstruction = new AddressableInstruction<IInstruction>(this.address, iInstruction);
            this.address += (long)iInstruction.getSize();
            return addressableInstruction;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

