/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.analyzer;

import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBinaryPattern;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class BinaryPattern
implements IBinaryPattern {
    @SerId(value=1)
    byte[] binary;
    @SerId(value=2)
    byte[] mask;
    @SerId(value=3)
    int realStartOffset;
    @SerId(value=4)
    int processorMode;

    public BinaryPattern(byte[] byArray) {
        this(byArray, null, 0, 0);
    }

    public BinaryPattern(byte[] byArray, byte[] byArray2) {
        this(byArray, byArray2, 0, 0);
    }

    public BinaryPattern(byte[] byArray, byte[] byArray2, int n) {
        this(byArray, byArray2, n, 0);
    }

    public BinaryPattern(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.binary = byArray;
        if (byArray2 != null && byArray2.length != byArray.length) {
            throw new IllegalArgumentException();
        }
        this.mask = byArray2;
        this.realStartOffset = n;
        this.processorMode = n2;
    }

    @Override
    public byte[] getBinary() {
        return this.binary;
    }

    @Override
    public byte[] getMask() {
        return this.mask;
    }

    @Override
    public int getRealStartOffset() {
        return this.realStartOffset;
    }

    @Override
    public int getProcessorMode() {
        return this.processorMode;
    }

    @Override
    public boolean validate(INativeCodeAnalyzer<?> iNativeCodeAnalyzer, long l2, byte[] byArray, int n, int n2) {
        return true;
    }

    @Override
    public Object getExtra() {
        return null;
    }

    public String toString() {
        if (this.getMask() == null) {
            return String.format("bin=[%s]", Formatter.byteArrayToHexString(this.getBinary()));
        }
        return String.format("bin=[%s],mask=[%s]", Formatter.byteArrayToHexString(this.getBinary()), Formatter.byteArrayToHexString(this.getMask()));
    }
}

